/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.ui.Options_m_CancelButton_actionAdapter;
import com.qlogic.ui.Options_m_OKButton_actionAdapter;
import com.qlogic.ui.Options_this_windowAdapter;
import com.qlogic.util.Options;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class OptionsDialog
extends JDialog {
    public static final int MIN_LOG_SIZE = 20;
    public static final int MAX_LOG_SIZE = 200;
    JPanel m_MainjPanel = new JPanel(new BorderLayout());
    JPanel m_CenterjPanel = new JPanel(new BorderLayout());
    JButton m_OKButton = new JButton();
    JButton m_CancelButton = new JButton();
    JPanel m_ButtonjPanel = new JPanel();
    JPanel m_EventjPanel = new JPanel(new GridBagLayout());
    JLabel m_EventExplain1jLabel = new JLabel();
    JLabel m_EventLogSizejLabel = new JLabel();
    JTextField m_EventLogSizejTextField = new JTextField();
    JCheckBox m_LogInfoEventsjCheckBox = new JCheckBox();
    JCheckBox m_LogWarnEventsjCheckBox = new JCheckBox();
    JLabel m_EventExplain2jLabel = new JLabel();
    JLabel m_EventIconjLabel = new JLabel();
    JPanel m_AlarmjPanel = new JPanel(new GridBagLayout());
    JLabel m_AlarmExplain1jLabel = new JLabel();
    JLabel m_AlarmExplain2jLabel = new JLabel();
    JLabel m_AlarmLogSizejLabel = new JLabel();
    JTextField m_AlarmLogSizejTextField = new JTextField();
    JLabel m_AlarmIconjLabel = new JLabel();
    private JCheckBox m_WarningsCheckBox = new JCheckBox("Enable warning displays");
    private JRadioButton m_AutoRadio = new JRadioButton(QConstants.getString("option_cfg_change_1"));
    private JRadioButton m_ConfirmRadio = new JRadioButton(QConstants.getString("option_cfg_change_2"));
    private JRadioButton m_IgnoreRadio = new JRadioButton(QConstants.getString("option_cfg_change_3"));

    public OptionsDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        Trace.traceAt(900, "In OptionsDialog.");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        Trace.traceAt(600, "OptionsDialog Created.");
        Trace.traceAt(900, "Out OptionsDialog.");
    }

    private void jbInit() throws Exception {
        Trace.traceAt(900, "In OptionsDialog.jbInit.");
        TitledBorder m_EventLogTitle = new TitledBorder(QConstants.getString("Event_Log"));
        TitledBorder m_AlarmLogTitle = new TitledBorder(QConstants.getString("Alarm_Log1"));
        TitledBorder warningTitle = new TitledBorder("Warning Displays");
        TitledBorder configTitle = new TitledBorder("Configuration Change Alarm");
        EmptyBorder m_SpaceBorder = new EmptyBorder(5, 5, 5, 5);
        CompoundBorder m_EventLogBorder = new CompoundBorder(m_EventLogTitle, m_SpaceBorder);
        CompoundBorder m_AlarmLogBorder = new CompoundBorder(m_AlarmLogTitle, m_SpaceBorder);
        CompoundBorder warningBorder = new CompoundBorder(warningTitle, m_SpaceBorder);
        CompoundBorder configBorder = new CompoundBorder(configTitle, m_SpaceBorder);
        this.m_EventIconjLabel.setIcon(SkinConstants.EVENT_IMAGE);
        this.m_AlarmIconjLabel.setIcon(SkinConstants.CLOCK_IMAGE);
        this.m_EventLogSizejTextField.setText(Utilities.getProperty(QConstants.EVENT_LOG_SIZE_KEY));
        this.m_AlarmLogSizejTextField.setText(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY));
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.m_AutoRadio);
        radioGroup.add(this.m_ConfirmRadio);
        radioGroup.add(this.m_IgnoreRadio);
        int option = Options.getConfigurationChangeOperation();
        switch (option) {
            case 0: {
                this.m_AutoRadio.setSelected(true);
                break;
            }
            case 1: {
                this.m_ConfirmRadio.setSelected(true);
                break;
            }
            case 2: {
                this.m_IgnoreRadio.setSelected(true);
                break;
            }
            default: {
                this.m_ConfirmRadio.setSelected(true);
            }
        }
        this.m_OKButton.setText(QConstants.getString("OK"));
        this.m_OKButton.addActionListener(new Options_m_OKButton_actionAdapter(this));
        this.m_CancelButton.setText(QConstants.getString("Cancel"));
        this.m_CancelButton.addActionListener(new Options_m_CancelButton_actionAdapter(this));
        this.addWindowListener(new Options_this_windowAdapter(this));
        this.m_MainjPanel.setLayout(new BorderLayout());
        this.m_EventExplain1jLabel.setText(QConstants.getString("The_size_of_the_event"));
        this.m_EventLogSizejLabel.setText(QConstants.getString("Log_Size_"));
        this.m_EventLogSizejTextField.setColumns(5);
        this.m_LogInfoEventsjCheckBox.setText(QConstants.getString("Log_Informational"));
        this.m_LogWarnEventsjCheckBox.setText(QConstants.getString("Log_Warning_Events"));
        this.m_EventExplain2jLabel.setText(QConstants.getString("set_from_20_to_200"));
        this.m_AlarmjPanel.setBorder(m_AlarmLogBorder);
        this.m_AlarmExplain1jLabel.setText(QConstants.getString("The_size_of_the_alarm"));
        this.m_AlarmExplain2jLabel.setText(QConstants.getString("set_from_20_to_2001"));
        this.m_AlarmLogSizejLabel.setText(QConstants.getString("Log_Size_"));
        this.m_AlarmLogSizejTextField.setColumns(5);
        this.m_MainjPanel.add((Component)this.m_CenterjPanel, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.anchor = 17;
        this.m_EventjPanel.add((Component)this.m_EventIconjLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        this.m_EventjPanel.add((Component)this.m_EventExplain1jLabel, gbc);
        gbc.gridy = 1;
        this.m_EventjPanel.add((Component)this.m_EventExplain2jLabel, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.m_EventjPanel.add((Component)this.m_EventLogSizejLabel, gbc);
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        this.m_EventjPanel.add((Component)this.m_LogInfoEventsjCheckBox, gbc);
        gbc.gridy = 4;
        this.m_EventjPanel.add((Component)this.m_LogWarnEventsjCheckBox, gbc);
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.m_EventjPanel.add((Component)this.m_EventLogSizejTextField, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.m_EventjPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.anchor = 17;
        this.m_AlarmjPanel.add((Component)this.m_AlarmIconjLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.m_AlarmjPanel.add((Component)this.m_AlarmExplain1jLabel, gbc);
        gbc.gridy = 2;
        this.m_AlarmjPanel.add((Component)this.m_AlarmExplain2jLabel, gbc);
        gbc.gridy = 3;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridwidth = 1;
        this.m_AlarmjPanel.add((Component)this.m_AlarmLogSizejLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.m_AlarmjPanel.add((Component)this.m_AlarmLogSizejTextField, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 1.0;
        this.m_AlarmjPanel.add((Component)new JPanel(), gbc);
        JPanel warningPanel = new JPanel(new GridBagLayout());
        warningPanel.setBorder(warningBorder);
        Icon warnIcon = SkinConstants.WARNING_IMAGE;
        JLabel warnIconLabel = new JLabel(warnIcon);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 10, 0, 10);
        gbc.anchor = 17;
        warningPanel.add((Component)warnIconLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        warningPanel.add((Component)this.m_WarningsCheckBox, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        warningPanel.add((Component)new JPanel(), gbc);
        JPanel configAlarmPanel = new JPanel(new GridBagLayout());
        configAlarmPanel.setBorder(configBorder);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        configAlarmPanel.add((Component)this.m_AutoRadio, gbc);
        gbc.gridy = 1;
        configAlarmPanel.add((Component)this.m_ConfirmRadio, gbc);
        gbc.gridy = 2;
        configAlarmPanel.add((Component)this.m_IgnoreRadio, gbc);
        this.m_MainjPanel.add((Component)this.m_ButtonjPanel, "South");
        JPanel topPanel = new JPanel(new GridLayout(1, 2));
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2));
        topPanel.add(this.m_EventjPanel);
        topPanel.add(this.m_AlarmjPanel);
        bottomPanel.add(warningPanel);
        bottomPanel.add(configAlarmPanel);
        this.m_CenterjPanel.add((Component)topPanel, "North");
        this.m_CenterjPanel.add((Component)bottomPanel, "South");
        this.m_EventjPanel.setBorder(m_EventLogBorder);
        Dimension dim = this.m_OKButton.getPreferredSize();
        dim.width = Math.max(dim.width, this.m_CancelButton.getPreferredSize().width);
        dim.height = Math.max(dim.height, this.m_CancelButton.getPreferredSize().height);
        this.m_OKButton.setPreferredSize(dim);
        this.m_CancelButton.setPreferredSize(dim);
        this.m_ButtonjPanel.add(this.m_OKButton);
        this.m_ButtonjPanel.add(this.m_CancelButton);
        this.getContentPane().add(this.m_MainjPanel);
        this.m_LogInfoEventsjCheckBox.setSelected(Options.isInfoEventLoggingEnabled());
        this.m_LogWarnEventsjCheckBox.setSelected(Options.isWarningEventLoggingEnabled());
        this.m_WarningsCheckBox.setSelected(Options.isDisplayWarningsEnabled());
        Trace.traceAt(900, "Out OptionsDialog.jbInit.");
    }

    void okPressed() {
        String eventLogSize = null;
        String alarmLogSize = null;
        boolean bFound = false;
        boolean bValid = true;
        Trace.traceAt(900, "In OptionsDialog.m_OKButton_actionPerformed.");
        eventLogSize = this.m_EventLogSizejTextField.getText();
        alarmLogSize = this.m_AlarmLogSizejTextField.getText();
        try {
            int iEventValue = 0;
            int iAlarmValue = 0;
            iEventValue = Integer.valueOf(eventLogSize);
            iAlarmValue = Integer.valueOf(alarmLogSize);
            if (iEventValue < 20 || iEventValue > 200) {
                throw new Exception(QConstants.getString("Invalid_Log_Size"));
            }
            if (!eventLogSize.equalsIgnoreCase(Utilities.getProperty(QConstants.EVENT_LOG_SIZE_KEY))) {
                Utilities.setProperty(QConstants.EVENT_LOG_SIZE_KEY, eventLogSize);
            }
            if (iAlarmValue < 20 || iAlarmValue > 200) {
                throw new Exception(QConstants.getString("Invalid_Log_Size"));
            }
            if (!alarmLogSize.equalsIgnoreCase(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY))) {
                Utilities.setProperty(QConstants.ALARM_LOG_SIZE_KEY, alarmLogSize);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, QConstants.getString("Invalid_Log_Size1"), QConstants.getString("Log_Size"), 0);
            bValid = false;
        }
        Options.enableInfoEventLogging(this.m_LogInfoEventsjCheckBox.isSelected());
        Options.enableWarningEventLogging(this.m_LogWarnEventsjCheckBox.isSelected());
        Options.enableDisplayWarnings(this.m_WarningsCheckBox.isSelected());
        if (this.m_AutoRadio.isSelected()) {
            Options.setConfigurationChangeOperation(0);
        } else if (this.m_IgnoreRadio.isSelected()) {
            Options.setConfigurationChangeOperation(2);
        } else {
            Options.setConfigurationChangeOperation(1);
        }
        if (bValid) {
            this.dispose();
        }
        Trace.traceAt(900, "Out OptionsDialog.m_OKButton_actionPerformed.");
    }

    void cancelPressed() {
        Trace.traceAt(900, "In OptionsDialog.m_CancelButton_actionPerformed.");
        Trace.traceAt(900, "Out OptionsDialog.m_CancelButton_actionPerformed.");
        this.dispose();
    }

    void windowClosing() {
        Trace.traceAt(900, "In OptionsDialog.this_windowClosing.");
        Trace.traceAt(900, "Out OptionsDialog.this_windowClosing.");
        this.dispose();
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(900, "In OptionsDialog.finalize.");
        this.m_MainjPanel = null;
        this.m_CenterjPanel = null;
        this.m_OKButton = null;
        this.m_CancelButton = null;
        this.m_ButtonjPanel = null;
        this.m_EventjPanel = null;
        this.m_EventExplain1jLabel = null;
        this.m_EventLogSizejLabel = null;
        this.m_EventLogSizejTextField = null;
        this.m_LogInfoEventsjCheckBox = null;
        this.m_LogWarnEventsjCheckBox = null;
        this.m_EventExplain2jLabel = null;
        this.m_EventIconjLabel = null;
        this.m_AlarmjPanel = null;
        this.m_AlarmExplain1jLabel = null;
        this.m_AlarmExplain2jLabel = null;
        this.m_AlarmLogSizejLabel = null;
        this.m_AlarmLogSizejTextField = null;
        this.m_AlarmIconjLabel = null;
        this.m_WarningsCheckBox = null;
        super.finalize();
        Trace.traceAt(600, "OptionsDialog Freed.");
        Trace.traceAt(900, "Out OptionsDialog.finalize.");
    }
}

