/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.actions;

import com.qlogic.QConstants;
import com.qlogic.SkinConstants;
import com.qlogic.ui.AlarmDialog;
import com.qlogic.ui.MainFrame;
import com.qlogic.ui.tools.QAction;
import com.qlogic.ui.tools.RolloverListener;
import com.qlogic.util.AlarmFilter;
import com.qlogic.util.AlarmFilterSource;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;

public class AlarmAction
implements QAction {
    private AlarmFilterSource m_FilterSource = null;

    public AlarmAction(AlarmFilterSource filterSource) {
        this.m_FilterSource = filterSource;
    }

    public JButton createButton() {
        JButton b = new JButton(QConstants.getString("alarm"));
        b.setRolloverIcon(SkinConstants.ALARM_IMAGE);
        b.setIcon(SkinConstants.ALARM_DISABLE_IMAGE);
        b.setVerticalTextPosition(3);
        b.setHorizontalAlignment(0);
        b.setHorizontalTextPosition(0);
        b.setMargin(new Insets(2, 2, 2, 2));
        b.setAlignmentY(0.5f);
        b.setRequestFocusEnabled(false);
        b.setToolTipText(QConstants.getString("View_Application1"));
        b.addActionListener(this);
        RolloverListener roll = new RolloverListener(b);
        b.addMouseListener(roll);
        return b;
    }

    public JMenuItem createMenuItem() {
        JMenuItem mi = new JMenuItem(QConstants.getString("Alarms_"));
        mi.addActionListener(this);
        return mi;
    }

    public void actionPerformed(ActionEvent e) {
        AlarmFilter filter = null;
        if (this.m_FilterSource != null) {
            filter = this.m_FilterSource.getCurrentFilter();
        }
        AlarmDialog dlg = new AlarmDialog((Frame)MainFrame.instance(), filter);
        dlg.setLocationRelativeTo(MainFrame.instance());
        ((Component)dlg).setVisible(true);
        MainFrame.instance().repaint();
    }
}

