/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import com.qlogic.QConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DetailsDialog
extends JDialog
implements ActionListener,
WindowListener {
    public static final int CLOSE_PRESSED = 0;
    public static final int NEXT_PRESSED = 1;
    public static final int PREVIOUS_PRESSED = 2;
    private JButton m_CloseButton = new JButton(QConstants.getString("close"));
    private JButton m_NextButton = new JButton(QConstants.getString("next"));
    private JButton m_PrevButton = new JButton(QConstants.getString("prev"));
    private JTextArea m_DetailsArea = new JTextArea(8, 30);
    private int m_ReturnValue = 0;

    public DetailsDialog(JDialog dialog, String title) {
        super(dialog, title, true);
        this.m_DetailsArea.setEditable(false);
        JScrollPane pane = new JScrollPane(this.m_DetailsArea);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.m_CloseButton);
        buttonPanel.add(this.m_NextButton);
        buttonPanel.add(this.m_PrevButton);
        this.getContentPane().add(pane);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setDefaultCloseOperation(0);
        this.m_CloseButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_NextButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_PrevButton.setMargin(new Insets(0, 0, 0, 0));
        Dimension size = this.m_CloseButton.getPreferredSize();
        Dimension temp = this.m_NextButton.getPreferredSize();
        size.width = Math.max(temp.width, size.width);
        size.height = Math.max(temp.height, size.height);
        temp = this.m_PrevButton.getPreferredSize();
        size.width = Math.max(temp.width, size.width);
        size.height = Math.max(temp.height, size.height);
        this.m_CloseButton.setPreferredSize(size);
        this.m_NextButton.setPreferredSize(size);
        this.m_PrevButton.setPreferredSize(size);
        this.m_CloseButton.addActionListener(this);
        this.m_NextButton.addActionListener(this);
        this.m_PrevButton.addActionListener(this);
        this.addWindowListener(this);
        this.pack();
    }

    public void append(String info) {
        this.m_DetailsArea.append(info);
    }

    public void setText(String text) {
        this.m_DetailsArea.setText(text);
    }

    public int getRows() {
        return this.m_DetailsArea.getRows();
    }

    public void setRows(int rows) {
        this.m_DetailsArea.setRows(rows);
    }

    public int getColumns() {
        return this.m_DetailsArea.getColumns();
    }

    public void setColumns(int columns) {
        this.m_DetailsArea.setColumns(columns);
    }

    public boolean getLineWrap() {
        return this.m_DetailsArea.getLineWrap();
    }

    public void setLineWrap(boolean wrap) {
        this.m_DetailsArea.setLineWrap(wrap);
    }

    public boolean getWrapStyleWord() {
        return this.m_DetailsArea.getWrapStyleWord();
    }

    public void setWrapStyleWord(boolean word) {
        this.m_DetailsArea.setWrapStyleWord(word);
    }

    public int display() {
        this.show();
        return this.m_ReturnValue;
    }

    protected void nextPressed() {
        this.m_ReturnValue = 1;
        ((Component)this).setVisible(false);
    }

    protected void prevPressed() {
        this.m_ReturnValue = 2;
        ((Component)this).setVisible(false);
    }

    protected void closePressed() {
        this.m_ReturnValue = 0;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_CloseButton) {
            this.closePressed();
        } else if (src == this.m_NextButton) {
            this.nextPressed();
        } else if (src == this.m_PrevButton) {
            this.prevPressed();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.m_ReturnValue = 0;
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

