/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools;

import com.qlogic.QConstants;
import com.qlogic.ui.tools.SortHeaderRenderer;
import com.qlogic.ui.tools.SortModelAdapter;
import com.qlogic.util.Utilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class SortControl
extends MouseAdapter
implements ActionListener {
    private JPopupMenu m_Menu = new JPopupMenu();
    private JMenuItem m_AscendMenu = new JMenuItem(QConstants.getString("sort_ascend"));
    private JMenuItem m_DescendMenu = new JMenuItem(QConstants.getString("sort_descend"));
    private JTable m_Table = null;
    private SortModelAdapter m_SortModel = null;
    private SortHeaderRenderer m_Renderer = null;
    private int m_SortColumn = -1;
    private int m_PopupColumn = -1;

    public SortControl() {
        this.m_Menu.add(this.m_AscendMenu);
        this.m_Menu.add(this.m_DescendMenu);
        this.m_AscendMenu.addActionListener(this);
        this.m_DescendMenu.addActionListener(this);
    }

    protected void finalize() throws Throwable {
        this.m_Menu = null;
        this.m_AscendMenu = null;
        this.m_DescendMenu = null;
        this.m_Table = null;
        this.m_SortModel = null;
        this.m_Renderer = null;
        super.finalize();
    }

    public void install(JTable table) {
        if (table != null) {
            table.getTableHeader().addMouseListener(this);
            this.m_Table = table;
            this.m_Renderer = new SortHeaderRenderer();
            if (Utilities.getProperty(QConstants.getString("node_option_logs_sort_accending")).equalsIgnoreCase("true")) {
                this.m_SortModel.sort(0, true);
                this.m_Renderer.setSortColumn(0, true);
            } else {
                this.m_SortModel.sort(0, false);
                this.m_Renderer.setSortColumn(0, false);
            }
            Enumeration<TableColumn> enumeration = table.getColumnModel().getColumns();
            TableColumn tc = null;
            while (enumeration.hasMoreElements()) {
                tc = enumeration.nextElement();
                tc.setHeaderRenderer(this.m_Renderer);
            }
        }
    }

    public void uninstall(JTable table) {
        if (table != null) {
            table.getTableHeader().removeMouseListener(this);
        }
    }

    public void setSortableModel(SortModelAdapter sma) {
        this.m_SortModel = sma;
    }

    public SortHeaderRenderer getRenderer() {
        return this.m_Renderer;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        boolean ascend = obj == this.m_AscendMenu;
        this.m_SortColumn = this.m_PopupColumn;
        this.m_SortModel.sort(this.m_SortColumn, ascend);
        this.m_Renderer.setSortColumn(this.m_SortColumn, ascend);
        this.m_Table.getTableHeader().repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == 4) {
            int vCol = this.m_Table.columnAtPoint(e.getPoint());
            this.m_PopupColumn = this.m_Table.convertColumnIndexToModel(vCol);
            this.m_Menu.show(this.m_Table, e.getX(), e.getY());
        }
    }
}

