/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.chart;

import java.awt.Color;
import javax.swing.JComponent;

public abstract class AbstractLineChart
extends JComponent {
    private boolean m_VerticalLines = true;
    private boolean m_HorizontalLines = true;
    private boolean m_XAxisLabels = true;
    private boolean m_YAxisLabels = true;
    private int m_HorizontalLineCount = 4;
    private int m_VerticalLineCount = 4;
    private Color m_GridColor = new Color(180, 180, 180);
    private Color m_ChartColor = new Color(240, 240, 240);

    protected void finalize() throws Throwable {
        this.m_GridColor = null;
        this.m_ChartColor = null;
        super.finalize();
    }

    public void enableHorizontalLines(boolean enable) {
        this.m_HorizontalLines = enable;
    }

    public void enableVerticalLines(boolean enable) {
        this.m_VerticalLines = enable;
    }

    public void enableXAxis(boolean enable) {
        this.m_XAxisLabels = enable;
    }

    public void enableYAxes(boolean enable) {
        this.m_YAxisLabels = enable;
    }

    public boolean isShowingHorizontalLines() {
        return this.m_HorizontalLines && this.getHorizontalLineCount() > 0;
    }

    public boolean isShowingVerticalLines() {
        return this.m_VerticalLines && this.getVerticalLineCount() > 0;
    }

    public boolean isShowingXAxis() {
        return this.m_XAxisLabels;
    }

    public boolean isShowingYAxes() {
        return this.m_YAxisLabels;
    }

    public void setGridColor(Color color) {
        if (color != null) {
            this.m_GridColor = color;
            this.repaint();
        }
    }

    public Color getGridColor() {
        return this.m_GridColor;
    }

    public Color getChartColor() {
        return this.m_ChartColor;
    }

    public void setChartColor(Color color) {
        if (color != null) {
            this.m_ChartColor = color;
            this.repaint();
        }
    }

    public void setVerticalLineCount(int count) {
        this.m_VerticalLineCount = count;
        this.repaint();
    }

    public int getVerticalLineCount() {
        return this.m_VerticalLineCount;
    }

    public void setHorizontalLineCount(int count) {
        this.m_HorizontalLineCount = count;
        this.repaint();
    }

    public int getHorizontalLineCount() {
        return this.m_HorizontalLineCount;
    }
}

