/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.chart;

import com.qlogic.QConstants;
import com.qlogic.ui.tools.chart.ChartData;
import com.qlogic.ui.tools.chart.ChartTrace;
import com.qlogic.ui.tools.chart.DataListener;
import com.qlogic.ui.tools.chart.SwatchIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ChartKey
extends JPanel
implements MouseListener,
ActionListener,
DataListener {
    private LineBorder m_LineBorder = new LineBorder(Color.black);
    private EmptyBorder m_EmptyBorder = new EmptyBorder(1, 1, 1, 1);
    private ChartData m_Data;
    private JLabel[] m_Labels;
    private JLabel[] m_Values;
    private JRadioButtonMenuItem m_SolidMenuItem = new JRadioButtonMenuItem(QConstants.getString("chart_solid_line"));
    private JRadioButtonMenuItem m_DashedMenuItem = new JRadioButtonMenuItem(QConstants.getString("chart_dashed_line"));
    private JCheckBoxMenuItem m_HideMenuItem = new JCheckBoxMenuItem(QConstants.getString("chart_hide_trace"));
    private JMenuItem m_ColorMenuItem = new JMenuItem(QConstants.getString("chart_trace_color_"));
    private JPopupMenu m_Popup = new JPopupMenu();
    private ChartTrace m_SelectedTrace = null;
    private JLabel m_SelectedLabel = null;

    public ChartKey(ChartData data) {
        super(new GridBagLayout());
        this.m_Data = data;
        this.m_Data.addDataListener(this);
        this.m_Labels = new JLabel[data.getTraceCount()];
        this.m_Values = new JLabel[data.getTraceCount()];
        Insets topRow = new Insets(5, 4, 1, 4);
        Insets bottomRow = new Insets(1, 4, 5, 4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        for (int i = 0; i < this.m_Labels.length; ++i) {
            ChartTrace trace = data.getTrace(i);
            SwatchIcon icon = new SwatchIcon(10, 10);
            icon.setColor(trace.getColor());
            this.m_Labels[i] = new JLabel(trace.getName(), icon, 0);
            this.m_Labels[i].setBorder(this.m_EmptyBorder);
            this.m_Labels[i].addMouseListener(this);
            this.m_Values[i] = new JLabel(" ");
            gbc.gridy = 0;
            gbc.insets = topRow;
            this.add((Component)this.m_Labels[i], gbc);
            gbc.gridy = 1;
            gbc.insets = bottomRow;
            this.add((Component)this.m_Values[i], gbc);
            ++gbc.gridx;
        }
        JMenu lineStyle = new JMenu(QConstants.getString("chart_line_style"));
        lineStyle.add(this.m_SolidMenuItem);
        lineStyle.add(this.m_DashedMenuItem);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_SolidMenuItem);
        bg.add(this.m_DashedMenuItem);
        this.m_Popup.add(this.m_ColorMenuItem);
        this.m_Popup.add(lineStyle);
        this.m_Popup.add(this.m_HideMenuItem);
        this.m_ColorMenuItem.addActionListener(this);
        this.m_SolidMenuItem.addActionListener(this);
        this.m_DashedMenuItem.addActionListener(this);
        this.m_HideMenuItem.addActionListener(this);
    }

    public void dataChanged() {
        int count = this.m_Data.getTraceCount();
        int index = this.m_Data.getDataPoints() - 1;
        for (int i = 0; i < count; ++i) {
            ChartTrace trace = this.m_Data.getTrace(i);
            String value = Long.toString((long)trace.getData(index));
            this.m_Values[i].setText(value);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.m_SelectedLabel = (JLabel)e.getComponent();
        int index = -1;
        boolean found = false;
        while (index < this.m_Labels.length && !found) {
            found = this.m_SelectedLabel == this.m_Labels[++index];
        }
        if (found) {
            this.m_SelectedTrace = this.m_Data.getTrace(index);
            this.m_HideMenuItem.setSelected(!this.m_SelectedTrace.isVisible());
            if (this.m_SelectedTrace.getStyle() == 0) {
                this.m_SolidMenuItem.setSelected(true);
            } else {
                this.m_DashedMenuItem.setSelected(true);
            }
            this.m_Popup.show(this.m_SelectedLabel, e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
        JLabel label = (JLabel)e.getComponent();
        label.setBorder(this.m_LineBorder);
    }

    public void mouseExited(MouseEvent e) {
        JLabel label = (JLabel)e.getComponent();
        label.setBorder(this.m_EmptyBorder);
    }

    public void actionPerformed(ActionEvent e) {
        Color color;
        Object src = e.getSource();
        if (src == this.m_SolidMenuItem) {
            this.m_SelectedTrace.setStyle(0);
        } else if (src == this.m_DashedMenuItem) {
            this.m_SelectedTrace.setStyle(1);
        } else if (src == this.m_HideMenuItem) {
            this.m_SelectedTrace.setVisible(!this.m_HideMenuItem.isSelected());
        } else if (src == this.m_ColorMenuItem && (color = JColorChooser.showDialog(this, QConstants.getString("chart_trace_color"), this.m_SelectedTrace.getColor())) != null) {
            this.m_SelectedTrace.setColor(color);
            SwatchIcon icon = (SwatchIcon)this.m_SelectedLabel.getIcon();
            icon.setColor(this.m_SelectedTrace.getColor());
            this.m_SelectedLabel.repaint();
        }
    }
}

