/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.tools.chart;

import com.qlogic.QConstants;
import com.qlogic.ui.tools.chart.AbstractLineChart;
import com.qlogic.ui.tools.chart.ChartData;
import com.qlogic.ui.tools.chart.ChartTrace;
import com.qlogic.ui.tools.chart.DataListener;
import com.qlogic.ui.tools.chart.TraceSettingsListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import javax.swing.border.Border;

public class LineChart
extends AbstractLineChart
implements DataListener,
TraceSettingsListener {
    private static final int TOL_VALUE = 15;
    private static final int MIN_GRID_SIZE = 2;
    private static final int HASH_WIDTH = 8;
    private static final int AXIS_PAD_RIGHT = 4;
    private static final int AXIS_PAD_LEFT = 4;
    private static final int DEFAULT_CHART_PADDING = 40;
    private static final int MAX_VALUE_PAD = 2;
    private int m_ChartPadding = 40;
    private ChartData m_Data = null;

    public LineChart() {
        this(null);
    }

    public LineChart(ChartData data) {
        this.setChartData(data);
        this.setOpaque(true);
    }

    protected void finalize() throws Throwable {
        this.m_Data = null;
        super.finalize();
    }

    public void setChartData(ChartData data) {
        if (this.m_Data != data) {
            if (this.m_Data != null) {
                this.m_Data.removeDataListener(this);
                this.m_Data.removeTraceSettingsListener(this);
            }
            this.m_Data = data;
            if (this.m_Data != null) {
                this.m_Data.addDataListener(this);
                this.m_Data.addTraceSettingsListener(this);
            }
            this.repaint();
        }
    }

    public ChartData getChartData() {
        return this.m_Data;
    }

    public void setBorder(Border border) {
    }

    private Rectangle getStringWidth(String string) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Font font = this.getFont();
        FontRenderContext fcr = g2.getFontRenderContext();
        return font.getStringBounds(string, fcr).getBounds();
    }

    public int getChartPadding() {
        return this.m_ChartPadding;
    }

    public void setChartPadding(int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("Negative chart padding");
        }
        this.m_ChartPadding = padding;
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension(0, 0);
        Dimension grid = this.getPreferredGridSize();
        size.width += this.getYAxisWidth() + grid.width + this.m_ChartPadding;
        size.height += grid.height;
        size.height += this.getXAxisHeight();
        return size;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle area = this.getBounds();
        area.x = 0;
        area.y = 0;
        Rectangle oldClip = g2.getClipBounds();
        g2.setColor(this.getBackground());
        g2.fillRect(area.x, area.y, area.width, area.height);
        int xaxisHeight = this.getXAxisHeight();
        int yaxesWidth = this.getYAxisWidth();
        Rectangle xaxis = new Rectangle(area.x, area.y + area.height - xaxisHeight, area.width, xaxisHeight);
        Rectangle yaxes = new Rectangle(area.x, area.y, yaxesWidth, area.height - xaxisHeight);
        Rectangle grid = new Rectangle(area.x + yaxes.width, yaxes.y, area.width - yaxes.width - this.m_ChartPadding, yaxes.height);
        g2.setColor(this.getChartColor());
        g2.fillRect(grid.x, grid.y, grid.width, grid.height);
        this.paintGrid(g2, grid);
        Rectangle traceClip = new Rectangle(grid.x + 1, grid.y + 1, grid.width - 2, grid.height - 2);
        traceClip = oldClip.intersection(traceClip);
        g2.setClip(traceClip);
        this.paintTraces(g2, grid);
        g2.setClip(oldClip);
        this.paintXAxis(g2, xaxis, grid);
        this.paintYAxis(g2, yaxes);
    }

    protected void paintTraces(Graphics2D g2, Rectangle bounds) {
        block3: {
            ChartData data = this.getChartData();
            if (data == null) break block3;
            Stroke oldStroke = g2.getStroke();
            int traces = data.getTraceCount();
            int cols = data.getDataPoints();
            if (traces < 1 || cols < 1) {
                return;
            }
            for (int i = 0; i < traces; ++i) {
                ChartTrace trace = data.getTrace(i);
                String maxStr = Long.toString((long)trace.getMaxValue());
                double max = Math.pow(10.0, maxStr.length());
                if (!trace.isVisible() || !(max > 0.0)) continue;
                double yMul = (double)bounds.height / max;
                double xMul = cols > 1 ? bounds.width / (cols - 1) : bounds.width;
                g2.setStroke(trace.getStroke());
                g2.setColor(trace.getColor());
                for (int j = 0; j < cols - 1; ++j) {
                    int x1 = (int)Math.round((double)j * xMul) + bounds.x;
                    int x2 = (int)Math.round((double)x1 + xMul);
                    int y1 = (int)Math.round((max - data.getData(i, j)) * yMul);
                    int y2 = (int)Math.round((max - data.getData(i, j + 1)) * yMul);
                    g2.drawLine(x1, y1 += bounds.y, x2, y2 += bounds.y);
                }
            }
            g2.setStroke(oldStroke);
        }
    }

    private void paintGrid(Graphics2D g2, Rectangle bounds) {
        int i;
        int gap;
        int count;
        g2.setColor(this.getGridColor());
        int x = bounds.x;
        int y = bounds.y;
        if (this.isShowingHorizontalLines()) {
            count = this.getHorizontalLineCount();
            gap = bounds.height / count;
            for (i = 1; i < count; ++i) {
                y = bounds.y + gap * i;
                g2.drawLine(x, y, x + bounds.width, y);
            }
        }
        if (this.isShowingVerticalLines()) {
            count = this.m_Data.getDataPoints() - 1;
            gap = bounds.width / count;
            y = bounds.y;
            for (i = 1; i < count; ++i) {
                x = bounds.x + gap * i;
                g2.drawLine(x, y, x, y + bounds.height);
            }
        }
        g2.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
    }

    private Dimension getPreferredGridSize() {
        Dimension size = new Dimension(0, 0);
        ChartData data = this.getChartData();
        if (data != null) {
            size.height = size.width = 2 * data.getDataPoints();
        }
        return size;
    }

    protected void paintYAxis(Graphics2D g2, Rectangle bounds) {
        int x1;
        Color oldColor = g2.getColor();
        int width = this.getYAxisWidth();
        g2.setColor(Color.black);
        String maxStr = QConstants.getString("chart_max");
        String minStr = Integer.toString(0);
        int x2 = x1 = bounds.x + width - 5;
        int y1 = bounds.y;
        int y2 = bounds.y + bounds.height - 1;
        int padRight = 12;
        g2.drawLine(x1, y1, x2, y2);
        x1 = bounds.x + width - padRight;
        y1 = y2 = bounds.y + 1;
        g2.drawLine(x1, y1, x2, y2);
        y1 = y2 = bounds.y + bounds.height - 1;
        g2.drawLine(x1, y1, x2, y2);
        Font font = this.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle charRect = font.getMaxCharBounds(frc).getBounds();
        Rectangle rect = font.getStringBounds(maxStr, frc).getBounds();
        x1 = bounds.x + width - rect.width - padRight;
        y1 = bounds.y + rect.height;
        g2.drawString(maxStr, x1, y1);
        int maxY = bounds.y + bounds.height;
        for (int i = 0; i < this.m_Data.getTraceCount(); ++i) {
            ChartTrace trace = this.m_Data.getTrace(i);
            String value = Long.toString((long)trace.getMaxValue());
            rect = font.getStringBounds(value, frc).getBounds();
            x1 = bounds.x + width - rect.width - padRight;
            g2.setColor(trace.getColor());
            if ((y1 += rect.height + 2) > maxY) break;
            g2.drawString(value, x1, y1);
        }
        g2.setColor(Color.black);
        rect = font.getStringBounds(minStr, frc).getBounds();
        x1 = bounds.x + width - rect.width - padRight;
        y1 = bounds.y + bounds.height - 4;
        g2.drawString(minStr, x1, y1);
        g2.setColor(oldColor);
    }

    private int getYAxisWidth() {
        String maxStr = QConstants.getString("chart_max");
        String minStr = Integer.toString(0);
        int width = this.getStringWidth((String)minStr).width;
        for (int i = 0; i < this.m_Data.getTraceCount(); ++i) {
            String value = Long.toString((long)this.m_Data.getMaxValue(i));
            int temp = this.getStringWidth((String)value).width;
            width = Math.max(width, temp);
        }
        width = Math.max(width, this.getStringWidth((String)maxStr).width);
        return width += 16;
    }

    private int getXAxisHeight() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Font font = this.getFont();
        FontRenderContext fcr = g2.getFontRenderContext();
        return font.getMaxCharBounds((FontRenderContext)fcr).getBounds().height;
    }

    protected void paintXAxis(Graphics g, Rectangle bounds, Rectangle gridArea) {
        String label;
        ChartData data = this.getChartData();
        if (data == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getForeground());
        Font font = this.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle charRect = font.getMaxCharBounds(frc).getBounds();
        int labelCount = data.getLabelCount();
        int x = gridArea.x;
        int y = bounds.y + charRect.height - 4;
        int validLabels = 0;
        int spread = gridArea.width / (labelCount - 1);
        Rectangle[] labelBounds = new Rectangle[labelCount];
        int totalWidth = 0;
        for (int i = 0; i < labelBounds.length; ++i) {
            label = data.getLabel(i);
            if (label == null) {
                labelBounds[i] = new Rectangle(0, 0, 0, 0);
                continue;
            }
            labelBounds[i] = font.getStringBounds(label, frc).getBounds();
            totalWidth += labelBounds[i].width;
            ++validLabels;
        }
        int inc = 1;
        if (totalWidth > validLabels * spread) {
            inc = 2;
        }
        for (int i = 0; i < labelCount; i += inc) {
            x = gridArea.x + i * spread;
            label = data.getLabel(i);
            if (label == null) continue;
            int labelx = x - labelBounds[i].width / 2;
            g2.drawString(label, labelx, y);
        }
    }

    public String getToolTipText(MouseEvent e) {
        String tip;
        block5: {
            int dataPoint;
            double xspan;
            int xrel;
            int xoffset;
            Point p;
            tip = null;
            String name = null;
            String units = null;
            String maxStr = null;
            ChartData data = this.getChartData();
            StringBuffer buffer = null;
            if (data == null) {
                return tip;
            }
            Rectangle area = this.getBounds();
            int xAxisHeight = this.getXAxisHeight();
            int yAxesWidth = this.getYAxisWidth();
            Rectangle grid = new Rectangle(area.x + yAxesWidth, area.y, area.width - yAxesWidth - this.m_ChartPadding, area.height - xAxisHeight);
            if (!grid.contains(p = e.getPoint()) || (xoffset = Math.abs((xrel = p.x - grid.x) - (int)Math.round((xspan = (double)(grid.width / (data.getDataPoints() - 1))) * (double)(dataPoint = (int)Math.round((double)xrel / xspan))))) >= 15) break block5;
            for (int i = 0; i < data.getTraceCount(); ++i) {
                double yscale;
                int ytrace;
                int yoffset;
                ChartTrace trace = data.getTrace(i);
                maxStr = Long.toString((long)trace.getMaxValue());
                double max = Math.pow(10.0, maxStr.length());
                if (max < 1.0 || (yoffset = Math.abs((ytrace = (int)Math.round((double)grid.height * (yscale = 1.0 - trace.getData(dataPoint) / max))) - p.y)) >= 15) continue;
                name = trace.getName();
                units = trace.getUnits();
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                if (name != null) {
                    buffer.append(name);
                    buffer.append(" ");
                }
                buffer.append((long)trace.getData(dataPoint));
                buffer.append(" ");
                if (units == null) continue;
                buffer.append(trace.getUnits());
                buffer.append(" ");
            }
            if (buffer != null) {
                tip = buffer.toString();
            }
        }
        return tip;
    }

    public void dataChanged() {
        this.repaint();
    }

    public void settingsChanged(ChartTrace trace) {
        this.repaint();
    }
}

