/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.AlarmEntry;
import com.qlogic.util.AlarmFilter;
import com.qlogic.util.AlarmListener;
import com.qlogic.util.AlarmNotifyRunnable;
import com.qlogic.util.EntryManager;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AlarmManager
extends EntryManager {
    public static final int TOKEN_COUNT = 6;
    private static AlarmManager m_instance = new AlarmManager();
    public Vector m_AlarmListeners = new Vector();

    private AlarmManager() {
    }

    public static AlarmManager instance() {
        return m_instance;
    }

    public void addAlarmListener(AlarmListener listener) {
        this.m_AlarmListeners.addElement(listener);
    }

    public void removeAlarmListener(AlarmListener listener) {
        this.m_AlarmListeners.removeElement(listener);
    }

    private void notifyListeners(AlarmEntry alarm) {
        Object[] listeners;
        Vector vector = this.m_AlarmListeners;
        synchronized (vector) {
            try {
                listeners = new AlarmListener[this.m_AlarmListeners.size()];
                this.m_AlarmListeners.copyInto(listeners);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        if (listeners.length > 0) {
            AlarmNotifyRunnable runnable = new AlarmNotifyRunnable(alarm, (AlarmListener[])listeners);
            SwingUtilities.invokeLater(runnable);
        }
    }

    public synchronized void addEntry(Date timeStamp, String hostName, String deviceID, int applicationType, String description, int severity) {
        Trace.traceAt(400, "In AlarmManager.addEntry()");
        if (this.m_AlarmListeners.size() > 0) {
            AlarmEntry newAlarm = new AlarmEntry(timeStamp, hostName, deviceID, applicationType, description, severity);
            this.notifyListeners(newAlarm);
        }
        if (this.m_enabled && this.m_open) {
            try {
                String date;
                int iAlarmLimit = new Integer(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY));
                int iAlarmCount = 0;
                int iAlarmDiff = 0;
                AlarmEntry[] alarms = this.getEntries();
                iAlarmCount = alarms == null ? 0 : alarms.length;
                boolean bShouldWrite = true;
                if (iAlarmCount > iAlarmLimit) {
                    iAlarmDiff = iAlarmCount - iAlarmLimit;
                    if (bShouldWrite) {
                        ++iAlarmDiff;
                    }
                    this.truncate();
                    date = null;
                    for (int i = iAlarmDiff; i < iAlarmCount; ++i) {
                        date = QConstants.DATE_FORMAT.format(alarms[i].getTimeStamp());
                        this.m_file.write(date.getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarms[i].getHostName().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarms[i].getAdapterID().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(alarms[i].getApplicationType()).getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(alarms[i].getDescription().getBytes());
                        this.m_file.write(", ".getBytes());
                        this.m_file.write(Integer.toString(alarms[i].getSeverity()).getBytes());
                        this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                    }
                }
                if (bShouldWrite) {
                    date = QConstants.DATE_FORMAT.format(timeStamp);
                    this.m_file.write(date.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(hostName.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(deviceID.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(applicationType).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(description.getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(severity).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                }
            }
            catch (IOException ex) {
                Trace.warn(String.valueOf(String.valueOf("Add of Entry failed.  Exception ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(".")));
                ex.printStackTrace();
            }
        }
    }

    public synchronized void removeFilteredEntries(AlarmFilter filter) {
        Trace.traceAt(900, "In AlarmManager.writeFilteredEntries()");
        if (filter == null) {
            this.truncate();
            return;
        }
        AlarmEntry[] alarms = this.getEntries();
        this.writeEntries(filter.removeAlarms(alarms));
        Trace.traceAt(900, "Out AlarmManager.writeFilteredEntries()");
    }

    private void writeEntries(AlarmEntry[] entries) {
        Trace.traceAt(900, "In AlarmManager.writeEntries()");
        this.truncate();
        if (entries != null) {
            int iAlarmDiff = 0;
            int iAlarmLimit = 0;
            try {
                iAlarmLimit = Integer.parseInt(Utilities.getProperty(QConstants.ALARM_LOG_SIZE_KEY));
            }
            catch (NumberFormatException nfe) {
                Trace.warn(String.valueOf(String.valueOf("Invalid AlarmLimit.  Exception ").concat(String.valueOf(nfe.toString()))).concat(String.valueOf(".")));
            }
            if (entries.length > iAlarmLimit) {
                iAlarmDiff = entries.length - iAlarmLimit;
            }
            try {
                this.truncate();
                for (int i = iAlarmDiff; i < entries.length; ++i) {
                    this.m_file.write(QConstants.DATE_FORMAT.format(entries[i].getTimeStamp()).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(entries[i].getHostName().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(entries[i].getAdapterID().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(entries[i].getApplicationType()).getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(entries[i].getDescription().getBytes());
                    this.m_file.write(", ".getBytes());
                    this.m_file.write(Integer.toString(entries[i].getSeverity()).getBytes());
                    this.m_file.write(System.getProperty(QConstants.getString("line_separator")).getBytes());
                }
            }
            catch (IOException ex) {
                Trace.warn(String.valueOf(String.valueOf("writeEntries () failed.  Exception ").concat(String.valueOf(ex.toString()))).concat(String.valueOf(".")));
                ex.printStackTrace();
            }
        }
        Trace.traceAt(900, "Out AlarmManager.writeEntries()");
    }

    public synchronized AlarmEntry[] getEntries() {
        Trace.traceAt(900, "In AlarmManager.getAlarmEntries()");
        String lineString = null;
        Date timeStamp = null;
        String hostName = null;
        String deviceID = null;
        int appType = -1;
        String description = null;
        int severity = -1;
        String delims = QConstants.getString("_t_n_r_");
        this.entryVector.removeAllElements();
        if (this.m_enabled && this.m_open) {
            block13: {
                try {
                    if (this.m_file.length() != (long)0) {
                        this.m_file.seek(0L);
                        while ((lineString = this.m_file.readLine()) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(lineString, delims);
                            if (tokenizer.countTokens() == 6) {
                                boolean valid = true;
                                while (tokenizer.hasMoreTokens()) {
                                    try {
                                        timeStamp = QConstants.DATE_FORMAT.parse(tokenizer.nextToken().trim());
                                    }
                                    catch (ParseException pe) {
                                        valid = false;
                                        Trace.traceAt(900, "AlarmManager could not parse date string from file.");
                                    }
                                    hostName = tokenizer.nextToken().trim();
                                    deviceID = tokenizer.nextToken().trim();
                                    try {
                                        appType = Integer.parseInt(tokenizer.nextToken().trim());
                                    }
                                    catch (NumberFormatException nfe) {
                                        valid = false;
                                        Trace.traceAt(900, "Error reading AlarmEntry app type (int) from alarms file.");
                                    }
                                    description = tokenizer.nextToken().trim();
                                    try {
                                        severity = Integer.parseInt(tokenizer.nextToken().trim());
                                    }
                                    catch (NumberFormatException nfe) {
                                        valid = false;
                                        Trace.traceAt(900, "Error reading AlarmEntry severity (int) from alarms file.");
                                    }
                                    if (!valid) continue;
                                    this.entryVector.add(new AlarmEntry(timeStamp, hostName, deviceID, appType, description, severity));
                                }
                                continue;
                            }
                            Trace.traceAt(900, "AlarmManager.getEntries (): Invalid entry encountered and rejected.");
                        }
                        break block13;
                    }
                    AlarmEntry[] tokenizer = null;
                    return tokenizer;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Object[] entries = new AlarmEntry[this.entryVector.size()];
            this.entryVector.copyInto(entries);
            Trace.traceAt(900, String.valueOf(String.valueOf("Returning ").concat(String.valueOf(this.entryVector.size()))).concat(String.valueOf(" Events.")));
            Trace.traceAt(900, "Out AlarmManager.getAlarmEntries()");
            return entries;
        }
        Trace.traceAt(900, "Out AlarmManager.getAlarmEntries()");
        return null;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In AlarmManager.finalize()");
        Trace.traceAt(600, "This should not be called when the application is running.");
        m_instance = null;
        super.finalize();
        Trace.traceAt(600, "In AlarmManager.finalize()");
    }
}

