/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public abstract class EntryManager {
    protected String m_filePath = "";
    protected RandomAccessFile m_file;
    protected boolean m_enabled = true;
    protected boolean m_open = false;
    protected Vector entryVector = new Vector();

    public boolean open(String filePath) {
        boolean bOpen = true;
        Trace.traceAt(900, "In EntryManager.open()");
        bOpen = this.open(filePath, false);
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out EntryManager.open(), Returning:  ").append(bOpen).append(".")));
        return bOpen;
    }

    public synchronized boolean open(String filePath, boolean overwrite) {
        boolean bOpen = true;
        Trace.traceAt(400, "EntryManager.open()");
        try {
            if (this.m_open) {
                this.close();
                this.m_open = false;
            }
            this.m_file = new RandomAccessFile(filePath, "rw");
            this.m_filePath = filePath;
            this.m_open = true;
            if (!overwrite) {
                this.m_file.seek(this.m_file.length());
            } else {
                this.truncate();
            }
        }
        catch (IOException ex) {
            Trace.warn(String.valueOf(new StringBuffer("File Open Failed.  Exception ").append(ex.toString()).append(".")));
            ex.printStackTrace();
            bOpen = false;
        }
        return bOpen;
    }

    public synchronized void close() {
        Trace.traceAt(400, "EntryManager.close()");
        if (this.m_open) {
            try {
                this.m_file.close();
            }
            catch (IOException ex) {
                Trace.warn(String.valueOf(new StringBuffer("File close failed.  Exception ").append(ex.toString()).append(".")));
                ex.printStackTrace();
            }
            this.m_filePath = "";
            this.m_open = false;
        }
    }

    public void enable(boolean flag) {
        Trace.traceAt(900, "In EntryManager.enable()");
        this.m_enabled = flag;
        Trace.traceAt(900, "Out EntryManager.enable()");
    }

    public boolean isEnabled() {
        Trace.traceAt(900, "In EntryManager.isEnabled()");
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out EntryManager.isEnabled().  Returns:  ").append(this.m_enabled).append(".")));
        return this.m_enabled;
    }

    public String getFile() {
        Trace.traceAt(900, "In EntryManager.getFile()");
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out EntryManager.getFile().  Returns:  ").append(this.m_filePath).append(".")));
        return this.m_filePath;
    }

    public synchronized void truncate() {
        Trace.traceAt(900, "In, EntryManager.truncate()");
        if (this.m_open && this.m_file != null) {
            try {
                this.m_file.setLength(0L);
            }
            catch (IOException ex) {
                Trace.warn("Couldn't set the log file length to zero.");
            }
        }
        Trace.traceAt(900, "Out EntryManager.getAlarmTypeString()");
    }

    public boolean isOpen() {
        Trace.traceAt(900, "In EntryManager.isOpen()");
        Trace.traceAt(900, String.valueOf(new StringBuffer("Out EntryManager.isOpen().  Returns:  ").append(this.m_open).append(".")));
        return this.m_open;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In EntryManager.finalize()");
        this.m_filePath = null;
        this.m_file = null;
        super.finalize();
        Trace.traceAt(600, "In EntryManager.finalize()");
    }
}

