/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.QConstants;
import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;

public class QMSJHelp {
    private static final String CLASS_NAME = "QMSJHelp";
    private boolean m_bQMSJHelpReady = false;
    private String m_strPathToBrowser = null;

    public QMSJHelp() {
        String strTrace = CLASS_NAME;
        Trace.traceAt(900, String.valueOf(new StringBuffer("IN ").append(strTrace).append(".")));
        this.m_bQMSJHelpReady = false;
        this.m_strPathToBrowser = Utilities.addPathSeperator(Utilities.getProperty(QConstants.BROWSER_LOCATION_KEY));
        if (this.m_strPathToBrowser != null) {
            this.m_bQMSJHelpReady = true;
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("OUT ").append(strTrace).append(".")));
    }

    public boolean isReady() {
        return this.m_bQMSJHelpReady;
    }

    public boolean displayTopic(String strHelpTopic) {
        String strTrace = "QMSJHelp.displayTopic";
        boolean bRetVal = false;
        StringBuffer strBufferCmdLine = new StringBuffer();
        Trace.traceAt(900, String.valueOf(new StringBuffer("IN ").append(strTrace).append(".")));
        if (this.m_bQMSJHelpReady) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                strBufferCmdLine.append("\"");
            }
            strBufferCmdLine.append(this.m_strPathToBrowser);
            if (System.getProperty("os.name").startsWith("Windows")) {
                strBufferCmdLine.append("\" \"");
            } else {
                strBufferCmdLine.append(" ");
            }
            strBufferCmdLine.append(String.valueOf(System.getProperty("user.dir")).concat("/help/"));
            strBufferCmdLine.append(strHelpTopic);
            if (System.getProperty("os.name").startsWith("Windows")) {
                strBufferCmdLine.append("\"");
            }
            Trace.traceAt(900, String.valueOf(new StringBuffer(String.valueOf(strTrace)).append(": strBufferCmdLine:  *").append(strBufferCmdLine.toString()).append("*")));
            if (Utilities.run(strBufferCmdLine.toString()) == 0) {
                bRetVal = true;
            }
        }
        Trace.traceAt(900, String.valueOf(new StringBuffer("OUT ").append(strTrace).append(".")));
        return bRetVal;
    }
}

