/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;

public class Trace {
    static final String TRACE_KEY = new String("node.trace.level");
    static final String ABORT_HEADER = new String("ABORT: ");
    static final String WARN_HEADER = new String("WARN : ");
    static final String EVENT_HEADER = new String("Event: ");
    static final String SPAWN_HEADER = new String("Spawn: ");
    static final String TRACE_HEADER = new String("Trace: ");
    static final String COM_HEADER = new String("Com: ");
    static final String CONFIG_HEADER = new String("Config: ");
    static final String MEM_HEADER = new String("Mem: ");
    static final String LOW_HEADER = new String("Low: ");
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_WARN = 100;
    public static final int LEVEL_EVENT = 200;
    public static final int LEVEL_SPAWN = 300;
    public static final int LEVEL_TRACE = 400;
    public static final int LEVEL_COM = 500;
    public static final int LEVEL_MEM = 600;
    public static final int LEVEL_CONFIG = 700;
    public static final int LEVEL_LOW = 900;
    public static final int LEVEL_ALL = 1000;
    public static final int INVALID_MODIFY = -1;
    public static final int NOT_TRACED = 0;
    public static final int TRACED = 1;
    static int iLevel = 0;
    static long lModified = -1L;
    static boolean bLevelTranslated = false;
    static final String TRACE_OUTPUT_DATETIMEPREFIX_KEY = new String("node.trace.output.datetimeprefix");
    static final String TRACE_OUTPUT_CONSOLE_KEY = new String("node.trace.output.console");
    static final String TRACE_OUTPUT_FILE_KEY = new String("node.trace.output.file");
    static final String TRACE_OUTPUT_FILE_FILENAME_KEY = new String("node.trace.output.file.filename");
    static boolean m_bTraceOutputDateTimePrefix = false;
    static boolean m_bTraceOutputConsole = true;
    static boolean m_bTraceOutputFile = false;
    static String m_strTraceOutputFilename = null;
    static final String TRACE_OUTPUT_ONLY_SET_LEVEL_KEY = new String("node.trace.output.setlevelonly");
    static final String TRACE_OUTPUT_FILE_BUFFERED_KEY = new String("node.trace.output.file.buffered");
    static boolean m_bTracingBegan = false;
    static boolean m_bTracingPaused = false;
    static boolean m_bTracingOnlySetLevel = false;
    static boolean m_bTraceWithBufferedStream = false;
    static PrintStream m_streamTraceOutput = null;

    public static boolean isTracing() {
        return m_bTracingBegan;
    }

    public static boolean isTracingPaused() {
        return m_bTracingPaused;
    }

    public static boolean isTracingOnlySetLevel() {
        return m_bTracingOnlySetLevel;
    }

    public static boolean isTracingWithDateTimePrefix() {
        return m_bTraceOutputDateTimePrefix;
    }

    public static boolean isTracingToConsole() {
        return m_bTraceOutputConsole;
    }

    public static boolean isTracingToFile() {
        return m_bTraceOutputFile;
    }

    public static boolean isTracingWithBufferedStream() {
        return m_bTraceWithBufferedStream;
    }

    public static int getLevel() {
        return iLevel;
    }

    public static void setLevel(int iNewLevel) {
        if (iNewLevel < 0) {
            iNewLevel = 0;
        }
        if (iNewLevel > 1000) {
            iNewLevel = 1000;
        }
        iLevel = iNewLevel;
    }

    public static boolean begin(boolean bReadLocalProperties) {
        boolean ok = false;
        if (!Trace.isTracing()) {
            ok = true;
            if (bReadLocalProperties) {
                ok = Trace.loadSettingsFromPropertiesFile();
            }
            if (ok) {
                ok = Trace.startFileStream();
            }
            if (ok) {
                m_bTracingBegan = true;
                m_bTracingPaused = false;
            }
        }
        return ok;
    }

    public static boolean end() {
        boolean ok = false;
        if (Trace.isTracing()) {
            m_bTracingBegan = false;
            m_bTracingPaused = false;
            ok = Trace.stopFileStream();
        }
        return ok;
    }

    public static boolean pause() {
        boolean ok = false;
        if (Trace.isTracing() && !Trace.isTracingPaused()) {
            m_bTracingPaused = true;
            ok = true;
        }
        return ok;
    }

    public static boolean resume() {
        boolean ok = false;
        if (Trace.isTracing() && Trace.isTracingPaused()) {
            m_bTracingPaused = false;
            ok = true;
        }
        return ok;
    }

    public static void setTraceOnlySetLevel(boolean on) {
        m_bTracingOnlySetLevel = on;
    }

    public static void setTraceWithDateTimePrefix(boolean on) {
        m_bTraceOutputDateTimePrefix = on;
    }

    public static void setTraceToConsole(boolean on) {
        m_bTraceOutputConsole = on;
    }

    public static void setTraceToFile(boolean on, String strFileName, boolean bUseBufferedStream) {
        boolean ok = true;
        if (Trace.isTracing() && Trace.isTracingToFile()) {
            ok = Trace.stopFileStream();
        }
        m_bTraceOutputFile = on;
        m_strTraceOutputFilename = strFileName;
        m_bTraceWithBufferedStream = bUseBufferedStream;
        if (ok && Trace.isTracing()) {
            ok = Trace.startFileStream();
        }
    }

    public static int trace(String msgString) {
        int iTraced = 0;
        if (Trace.shouldOutput(400)) {
            iTraced = 1;
            Trace.traceOutput(String.valueOf(TRACE_HEADER).concat(String.valueOf(msgString)));
        }
        return iTraced;
    }

    public static int traceAt(int iSpecifiedLevel, String msgString) {
        int iTraced = 0;
        if (Trace.shouldOutput(iSpecifiedLevel)) {
            String strTraceOutput;
            if (iSpecifiedLevel == 100) {
                strTraceOutput = String.valueOf(WARN_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 200) {
                strTraceOutput = String.valueOf(EVENT_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 300) {
                strTraceOutput = String.valueOf(SPAWN_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 400) {
                strTraceOutput = String.valueOf(TRACE_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 500) {
                strTraceOutput = String.valueOf(COM_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 600) {
                strTraceOutput = String.valueOf(MEM_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else if (iSpecifiedLevel == 700) {
                strTraceOutput = String.valueOf(CONFIG_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            } else {
                strTraceOutput = String.valueOf(LOW_HEADER).concat(String.valueOf(msgString));
                iTraced = 1;
            }
            if (iTraced == 1) {
                Trace.traceOutput(strTraceOutput);
            }
        }
        return iTraced;
    }

    public static int warn(String msgString) {
        int iTraced = 0;
        if (Trace.shouldOutput(100)) {
            iTraced = 1;
            Trace.traceOutput(String.valueOf(WARN_HEADER).concat(String.valueOf(msgString)));
        }
        return iTraced;
    }

    private static boolean shouldOutput(int iSpecifiedLevel) {
        boolean okToOutput = false;
        if (Trace.isTracing() && !Trace.isTracingPaused()) {
            if (Trace.isTracingOnlySetLevel()) {
                if (iSpecifiedLevel == iLevel) {
                    okToOutput = true;
                }
            } else if (iLevel >= iSpecifiedLevel) {
                okToOutput = true;
            }
        }
        return okToOutput;
    }

    private static void traceOutput(String msgString) {
        block3: {
            String strTraceEntry;
            block4: {
                Date entryDate = new Date(System.currentTimeMillis());
                strTraceEntry = Trace.isTracingWithDateTimePrefix() ? String.valueOf(String.valueOf(entryDate.toString()).concat(String.valueOf(" - "))).concat(String.valueOf(msgString)) : msgString;
                if (Trace.isTracingToConsole()) {
                    System.out.println(strTraceEntry);
                }
                if (!Trace.isTracingToFile()) break block3;
                if (!Trace.isTracingWithBufferedStream()) break block4;
                m_streamTraceOutput.println(strTraceEntry);
                if (!m_streamTraceOutput.checkError()) break block3;
                System.out.println(String.valueOf("Error: (traceOutput) cannot write to buffered Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
                break block3;
            }
            try {
                PrintStream localTraceOutput = new PrintStream(new BufferedOutputStream(new FileOutputStream(m_strTraceOutputFilename, true)));
                localTraceOutput.println(strTraceEntry);
                localTraceOutput.close();
            }
            catch (Exception exception) {
                System.out.println(String.valueOf("Error: (traceOutput) cannot write to unbuffered Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
                System.out.println(String.valueOf("Exception:  ").concat(String.valueOf(exception.toString())));
            }
        }
    }

    private static void clearTraceOptionsSettings() {
        iLevel = 0;
        m_bTracingOnlySetLevel = false;
        m_bTraceOutputDateTimePrefix = false;
        m_bTraceOutputConsole = true;
        m_bTraceOutputFile = false;
        m_bTraceWithBufferedStream = false;
        m_strTraceOutputFilename = null;
    }

    private static boolean loadSettingsFromPropertiesFile() {
        Properties localProperties = null;
        String valueString = null;
        Trace.clearTraceOptionsSettings();
        try {
            localProperties = new Properties(System.getProperties());
            localProperties.load(new BufferedInputStream(new FileInputStream(Utilities.LOCAL_PROPERTIES)));
            System.setProperties(localProperties);
        }
        catch (Exception ex) {
            System.out.println("Error: (loadSettingsFromPropertiesFile) reading trace values from properties file");
        }
        valueString = System.getProperty(TRACE_KEY);
        if (valueString != null) {
            iLevel = new Integer(valueString);
            if (iLevel < 0) {
                iLevel = 0;
            }
            if (iLevel > 1000) {
                iLevel = 1000;
            }
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_ONLY_SET_LEVEL_KEY)) != null) {
            m_bTracingOnlySetLevel = new Boolean(valueString);
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_DATETIMEPREFIX_KEY)) != null) {
            m_bTraceOutputDateTimePrefix = new Boolean(valueString);
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_CONSOLE_KEY)) != null) {
            m_bTraceOutputConsole = new Boolean(valueString);
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_FILE_KEY)) != null) {
            m_bTraceOutputFile = new Boolean(valueString);
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_FILE_BUFFERED_KEY)) != null) {
            m_bTraceWithBufferedStream = new Boolean(valueString);
        }
        if ((valueString = System.getProperty(TRACE_OUTPUT_FILE_FILENAME_KEY)) != null) {
            m_strTraceOutputFilename = new String(valueString);
        }
        return true;
    }

    private static boolean startFileStream() {
        boolean ok = true;
        if (m_bTraceOutputFile) {
            if (m_bTraceWithBufferedStream) {
                try {
                    m_streamTraceOutput = new PrintStream(new BufferedOutputStream(new FileOutputStream(m_strTraceOutputFilename)));
                    if (m_streamTraceOutput.checkError()) {
                        ok = false;
                        m_bTraceOutputFile = false;
                        System.out.println(String.valueOf("Error: (startFileStream) cannot open Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
                    }
                }
                catch (Exception ex) {
                    ok = false;
                    m_bTraceOutputFile = false;
                    System.out.println(String.valueOf("Error: (startFileStream) cannot open Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
                }
            } else {
                m_streamTraceOutput = null;
                try {
                    File localTraceFile = new File(m_strTraceOutputFilename);
                    if (localTraceFile.exists()) {
                        localTraceFile.delete();
                    }
                    localTraceFile.createNewFile();
                }
                catch (Exception ex) {
                    ok = false;
                    m_bTraceOutputFile = false;
                    System.out.println(String.valueOf("Error: (startFileStream) cannot truncate Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
                }
            }
        }
        return ok;
    }

    private static boolean stopFileStream() {
        boolean ok = true;
        if (m_bTraceWithBufferedStream) {
            m_streamTraceOutput.close();
            if (m_streamTraceOutput.checkError()) {
                ok = false;
                System.out.println(String.valueOf("Error: (stopFileStream) cannot close Trace file stream: ").concat(String.valueOf(m_strTraceOutputFilename)));
            }
            m_bTraceOutputFile = false;
            m_streamTraceOutput = null;
        } else {
            m_bTraceOutputFile = false;
        }
        return ok;
    }

    protected void finalize() throws Throwable {
        Trace.stopFileStream();
        System.out.println("NOTE: (Trace.finalize) invoked");
        super.finalize();
    }
}

