/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_CPU_IMPL_H
#define	_SYS_CPU_IMPL_H

#pragma ident	"@(#)cpu_impl.h	1.1	06/06/08 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Definitions of UltraSparc III cpu implementations as specified
 * in version register
 */
#define	CHEETAH_IMPL			0x14
#define	IS_CHEETAH(impl)		((impl) == CHEETAH_IMPL)
#define	CHEETAH_MAJOR_VERSION(rev)	(((rev) >> 4) & 0xf)
#define	CHEETAH_MINOR_VERSION(rev)	((rev) & 0xf)

/*
 * Definitions of UltraSPARC III+ cpu implementation as specified
 * in version register
 */
#define	CHEETAH_PLUS_IMPL		0x15
#define	IS_CHEETAH_PLUS(impl)		((impl) == CHEETAH_PLUS_IMPL)
#define	CHEETAH_PLUS_MAJOR_VERSION(rev)	CHEETAH_MAJOR_VERSION(rev)
#define	CHEETAH_PLUS_MINOR_VERSION(rev)	CHEETAH_MINOR_VERSION(rev)

/*
 * Definitions of UltraSPARC IIIi cpu implementation as specified
 * in version register.  Jalapeno major and minor rev's are in
 * the same location and are the same size as Cheetah/Cheetah+.
 */
#define	JALAPENO_IMPL			0x16
#define	IS_JALAPENO(impl)		((impl) == JALAPENO_IMPL)
#define	JALAPENO_MAJOR_VERSION(rev)	CHEETAH_MAJOR_VERSION(rev)
#define	JALAPENO_MINOR_VERSION(rev)	CHEETAH_MINOR_VERSION(rev)

/*
 * Definitions of UltraSPARC IV cpu implementation as specified
 * in version register. Jaguar major and minor rev's are in
 * the same location and are the same size as Cheetah/Cheetah+.
 */
#define	JAGUAR_IMPL			0x18
#define	IS_JAGUAR(impl)			((impl) == JAGUAR_IMPL)
#define	JAGUAR_MAJOR_VERSION(rev)	CHEETAH_MAJOR_VERSION(rev)
#define	JAGUAR_MINOR_VERSION(rev)	CHEETAH_MINOR_VERSION(rev)

/*
 * Definitions of UltraSPARC IIIi+ cpu implementation as specified
 * in version register.  Serrano major and minor rev's are in
 * the same location and are the same size as Cheetah/Cheetah+.
 */
#define	SERRANO_IMPL			0x22
#define	IS_SERRANO(impl)		((impl) == SERRANO_IMPL)
#define	SERRANO_MAJOR_VERSION(rev)	CHEETAH_MAJOR_VERSION(rev)
#define	SERRANO_MINOR_VERSION(rev)	CHEETAH_MINOR_VERSION(rev)

/*
 * Definitions of UltraSPARC IV+ cpu implementation as specified
 * in version register. Panther major and minor rev's are in
 * the same location and are the same size as Cheetah/Cheetah+.
 */
#define	PANTHER_IMPL			0x19
#define	IS_PANTHER(impl)		((impl) == PANTHER_IMPL)
#define	PANTHER_MAJOR_VERSION(rev)	CHEETAH_MAJOR_VERSION(rev)
#define	PANTHER_MINOR_VERSION(rev)	CHEETAH_MINOR_VERSION(rev)


/*
 * Definitions of Olympus-C cpu implementations as specified
 * in version register
 */
#define	OLYMPUS_C_IMPL			0x6
#define	IS_OLYMPUS_C(impl)		((impl) == OLYMPUS_C_IMPL)
#define	OLYMPUS_REV_MASK(x)		(((x) >> 28) & 0x7)
#define	OLYMPUS_C_A			0


#define	CPU_IMPL_IS_CMP(impl)		(IS_JAGUAR(impl) || \
					IS_PANTHER(impl) || IS_OLYMPUS_C(impl))

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_CPU_IMPL_H */
