/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * Modified by Fujitsu Limited to provide support
 * for Solaris on Fujitsu's hardware platforms
 */

#ifndef	_SYS_MACHASI_H
#define	_SYS_MACHASI_H

#pragma ident	"@(#)machasi.h	1.15	06/06/08 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Spitfire ancillary state registers, for asrset_t
 */
#define	ASR_GSR	(3)

/*
 * alternate address space identifiers
 *
 * 0x00 - 0x7F are privileged
 * 0x80 - 0xFF can be used by users
 */


/*
 * UltraSPARC ASIs
 */
#define	ASI_NQUAD_LD		0x24	/* 128-bit atomic load */
#define	ASI_NQUAD_LD_L		0x2c	/* 128-bit atomic load little */

#define	ASI_QUAD_LDD_PHYS	0x34	/* 128-bit physical atomic load */
#define	ASI_QUAD_LDD_PHYS_L	0x3C	/* 128-bit phys. atomic load little */

#define	ASI_INTR_DISPATCH_STATUS 0x48	/* interrupt vector dispatch status */
#define	ASI_INTR_RECEIVE_STATUS	0x49	/* interrupt vector receive status */

#define	ASI_SCRATCHPAD		0x4F	/* Scratchpad registers ASI */

#define	ASI_BLK_AIUP		0x70	/* block as if user primary */
#define	ASI_BLK_AIUS		0x71	/* block as if user secondary */

#define	ASI_SDB_INTR_W		0x77	/* interrupt vector dispatch */
#define	ASI_SDB_INTR_R		0x7F	/* incoming interrupt vector */
#define	ASI_INTR_DISPATCH	ASI_SDB_INTR_W
#define	ASI_INTR_RECEIVE	ASI_SDB_INTR_R

#define	ASI_BLK_AIUPL		0x78	/* block as if user primary little */
#define	ASI_BLK_AIUSL		0x79	/* block as if user secondary little */

/*
 * Spitfire asis
 */
#ifdef FJCPU
#define	ASI_MTLB_DEMAP		0x30	/* match and invalidate in mtlb */
#define	ASI_UDTLB_INVALIDATE	0x31	/* invalidate uDTLB */
#define	ASI_UITLB_INVALIDATE	0x32	/* invalidate uITLB */
#define	ASI_ITLB_ACCESS_WR	0x33	/* immu tlb data access, write */
#define	ASI_ITLB_DATA_IN	0x34	/* immu tlb data in */
#define	ASI_DTLB_ACCESS_WR	0x35	/* dmmu tlb data access, write */
#define	ASI_DTLB_DATA_IN	0x36	/* dmmu tlb data in */
#define	ASI_MTLB_TAGREAD	0x37	/* mmu mtlb tag read, x field */
#define	ASI_MTLB_ACCESS_RD	0x38	/* mmu mtlb data access, read */
#define	ASI_IMMU_TTARGET 	0x39	/* immu TMB tag target */
#define	ASI_DMMU_TTARGET 	0x3A	/* dmmu TMB tag target */
#define	ASI_IMMU_TMB_8K		0x3B	/* immu tmb 8k ptr */
#define	ASI_IMMU_TMB_64K	0x3C	/* immu tmb 64k ptr */
#define	ASI_DMMU_TMB_8K		0x3D	/* dmmu tmb 8k ptr */
#define	ASI_DMMU_TMB_64K	0x3E	/* dmmu tmb 64k ptr */
#define	ASI_MMU			0x3F	/* mmu tlb tag access and TMB base */
#define	ASI_MMU_CONFIG		0x40	/* context registers, tlb fifo and lock index */
#define	ASI_MMU_CTX		ASI_MMU_CONFIG
#define	ASI_MTLB_TAGREAD_DIAG	0x41	/* mmu mtlb tag read, y field (diag) */

#define	ASI_MMU_RESERVED1	0x42	/* reserved */
#define	ASI_MMU_RESERVED2	0x43	/* reserved */

#define	ASI_SCRATCH_REGISTER	0x44	/* scratch registers */

#define	ASI_MMU_RESERVED3	0x45	/* reserved */
#define	ASI_MMU_RESERVED4	0x46	/* reserved */
#define	ASI_MMU_RESERVED5	0x47	/* reserved */
#else /* FJCPU */
#define	ASI_LSU			0x45	/* load-store unit control */
#define	ASI_DC_INVAL		0x42	/* d$ invalidate */


#define	ASI_DC_DATA		0x46	/* d$ data */
#define	ASI_DC_TAG		0x47	/* d$ tag */
#endif /* FJCPU */

#define	ASI_UPA_CONFIG		0x4A	/* upa configuration reg */

#ifndef FJCPU
#define	ASI_ESTATE_ERR		0x4B	/* estate error enable reg */

#define	ASI_AFSR		0x4C	/* asynchronous fault status */
#define	ASI_AFAR		0x4D	/* asynchronous fault address */

#define	ASI_IMMU		0x50	/* instruction mmu */
#define	ASI_IMMU_TSB_8K		0x51	/* immu tsb 8k ptr */
#define	ASI_IMMU_TSB_64K	0x52	/* immu tsb 64k ptr */
#define	ASI_DEVICE_SERIAL_ID	0x53	/* device serial id */
#define	ASI_ITLB_IN		0x54	/* immu tlb data in */
#define	ASI_ITLB_ACCESS		0x55	/* immu tlb data access */
#define	ASI_ITLB_TAGREAD	0x56	/* immu tlb tag read */
#define	ASI_ITLB_DEMAP		0x57	/* immu tlb demap */

#define	ASI_DMMU		0x58	/* data mmu */
#define	ASI_MMU_CTX		ASI_DMMU
#define	ASI_DMMU_TSB_8K		0x59	/* dmmu tsb 8k ptr */
#define	ASI_DMMU_TSB_64K	0x5A	/* dmmu tsb 64k ptr */
#define	ASI_DMMU_TSB_DIRECT	0x5B	/* dmmu tsb direct ptr */
#define	ASI_DTLB_IN		0x5C	/* dmmu tlb data in */
#define	ASI_DTLB_ACCESS		0x5D	/* dmmu tlb data access */
#define	ASI_DTLB_TAGREAD	0x5E	/* dmmu tlb tag read */
#define	ASI_DTLB_DEMAP		0x5F	/* dmmu tlb demap */
#endif /* !FJCPU */

#ifdef FJCPU
#define	ASI_P_SO		0x60	/* Primary strong-order */
#define	ASI_P_SO_NP		0xE2	/* Primary strong-order non-priviledged */

#define	ASI_UC_ACCESS		0x68	/* e$ access reg */
#define	ASI_UC_FLUSH		0x69	/* e$ flush PA (diag) */
#define	ASI_L1_FLUSH_UC		0x6A	/* flush L1 to UC per UC index */
#define	ASI_SRAM_CONFIG		0x6B	/* read SRAM configuration register */

#define	ASI_TDU_ERROR		0x6C	/* TDU Error log register */
#define	ASI_ICU_ERROR		0x6D	/* ICU Error log register */
#define	ASI_DC_ERROR		0x6E	/* DC Error log register */
#define	ASI_UC_ECC_ERROR	0x6F	/* UC ECC Error injection register */

#else /* FJCPU */

#define	ASI_IC_DATA		0x66	/* i$ data */
#define	ASI_IC_TAG		0x67	/* i$ tag */
#define	ASI_IC_DECODE		0x6E	/* i$ pre-decode */
#define	ASI_IC_NEXT		0x6F	/* i$ next field */

#define	ASI_EC_W		0x76	/* e$ access write */
#define	ASI_EC_R		0x7E	/* e$ access read */
#define	ASI_EC_DIAG		0x4E	/* e$ diagnostic reg */
					/* PRM calls this ASI_ECACHE_TAG */
#endif /* FJCPU */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MACHASI_H */
