/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_HSVC_H
#define	_SYS_HSVC_H

#pragma ident	"@(#)hsvc.h	1.2	06/06/22 SMI"


/*
 * Niagara services information
 */

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Hypervisor service groups
 */
#define	HSVC_GROUP_SUN4V		0x0000
#define	HSVC_GROUP_CORE			0x0001
#define	HSVC_GROUP_INTR			0x0002
#define	HSVC_GROUP_VPCI			0x0100
#define	HSVC_GROUP_LDC			0x0101
#define	HSVC_GROUP_VSC			0x0102
#define	HSVC_GROUP_NCS			0x0103
#define	HSVC_GROUP_NIAGARA_CPU		0x0200
#define	HSVC_GROUP_FIRE_PERF		0x0201
#define	HSVC_GROUP_DIAG			0x0300

#ifndef _ASM

#include <sys/types.h>

/*
 * Hypervisor service negotiation data strcture
 */
struct hsvc_info {
	int		hsvc_rev;	/* data structure revision number */
	void		*hsvc_private;	/* reserved for the framework */
	uint64_t	hsvc_group;	/* hypervisor API group */
	uint64_t	hsvc_major;	/* API group major number */
	uint64_t	hsvc_minor;	/* API group minor number */
	char		*hsvc_modname;	/* module name */
};

typedef struct hsvc_info hsvc_info_t;

/*
 * hsvc_rev field
 */
#define	HSVC_REV_1		1

/*
 * External interface
 */
extern int hsvc_register(hsvc_info_t *hsvcreq, uint64_t *supported_minor);
extern int hsvc_unregister(hsvc_info_t *hsvcreq);
extern int hsvc_version(uint64_t hsvc_group, uint64_t *major, uint64_t *minor);

#endif /* _ASM */

#ifdef __cplusplus
}
#endif

#endif /* _SYS_HSVC_H */
