/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_NIAGARAASI_H
#define	_SYS_NIAGARAASI_H

#pragma ident	"@(#)niagaraasi.h	1.1	05/06/30 SMI"

/*
 * alternate address space identifiers
 *
 * 0x00 - 0x2F are privileged
 * 0x30 - 0x7f are hyperprivileged
 * 0x80 - 0xFF can be used by users
 */

#ifdef __cplusplus
extern "C" {
#endif

#if defined(NIAGARA_IMPL)

/*
 * NIAGARA specific ASIs
 */
#define	ASI_BLK_INIT_QUAD_LDD_AIUS	0x23	/* block as if user secondary */
#define	ASI_BLK_INIT_ST_QUAD_LDD_P	0xE2	/* block initializing primary */

#else
#error	"This file has ASIs which are specific to Niagara CPU"
#endif	/* NIAGARA_IMPL */

#ifdef __cplusplus
}
#endif

#endif /* _SYS_NIAGARAASI_H */
