/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.DoPrinterNS;
import com.sun.admin.pm.server.Host;
import com.sun.admin.pm.server.pmInternalErrorException;

public class NameService {
    private String nameservice = null;
    private String nshost = null;
    private String user = null;
    private String passwd = null;
    private boolean boundtonisslave = false;
    private boolean isauth = false;

    public NameService() {
        this.nameservice = "system";
        this.isauth = true;
    }

    public NameService(String string) throws Exception {
        if (!(string.equals("system") || string.equals("nis") || string.equals("nisplus") || string.equals("ldap"))) {
            throw new pmInternalErrorException("Unknown name service: " + string);
        }
        this.nameservice = string;
        Host host = new Host();
        Host.isNSConfigured(this.nameservice);
        if (string.equals("nis")) {
            String string2 = Host.getNisHost("master");
            String string3 = Host.getNisHost("bound");
            if (!string2.equals(string3)) {
                this.boundtonisslave = true;
            }
            this.setUser("root");
            this.setNameServiceHost(string2);
            this.setPasswd("");
        } else if (string.equals("ldap")) {
            String string4 = host.getLDAPMaster();
            if (string4 == null) {
                this.setNameServiceHost("");
            } else {
                this.setNameServiceHost(string4);
            }
            String string5 = host.getDefaultAdminDN();
            if (string5 == null) {
                this.setUser("");
            } else {
                this.setUser(string5);
            }
            this.setPasswd("");
        }
    }

    public void setNameServiceHost(String string) {
        this.nshost = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPasswd(String string) {
        this.passwd = string;
    }

    public String getNameService() {
        return this.nameservice;
    }

    public String getNameServiceHost() {
        return this.nshost;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public boolean getBoundToNisSlave() {
        return this.boundtonisslave;
    }

    public boolean isAuth() {
        return this.isauth;
    }

    public void checkAuth() throws Exception {
        Debug.message("SVR: NameService.checkAuth()");
        DoPrinterNS.doAuth(this);
        this.isauth = true;
    }
}

