/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.ComponentMove;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;

public final class DecisionHistory
implements Serializable {
    public static final int DECISION_LIFETIME = 256;
    private HashMap decisions = new HashMap();
    private transient HashMap resourcesAwaitingImprovement = new HashMap();
    private transient LinkedList decisionList = new LinkedList();
    private static final long serialVersionUID = -142211449L;

    public void recordProcessorMove(ComponentMove componentMove, double d, int n) throws PoolsException {
        Decision decision = Decision.forMove(componentMove, d);
        decision.setStartingSampleCount(n);
        Decision decision2 = this.decisions.put(decision.getKey(), decision);
        Poold.OPT_LOG.log((Level)Severity.DEBUG, "recorded decision (" + decision + ")" + (decision2 == null ? "" : " (displaced " + decision2 + ")"));
        this.resourcesAwaitingImprovement.put(componentMove.getTo(), decision.getKey());
        this.decisionList.add(decision);
    }

    private void recordImprovementWithUtilization(Resource resource, double d) {
        Decision decision;
        String string = (String)this.resourcesAwaitingImprovement.get(resource);
        if (string != null && (decision = (Decision)this.decisions.get(string)) != null) {
            decision.setImprovementWithNewUtilization(d);
            Poold.OPT_LOG.log((Level)Severity.DEBUG, resource + " improvement measured for decision " + decision.describe());
        }
    }

    public boolean veto(Move move, double d) {
        Decision decision = Decision.forMove(move, d);
        if (decision != null) {
            Decision decision2 = (Decision)this.decisions.get(decision.getKey());
            if (decision2 != null) {
                decision2.incrementUsage();
            }
            if (decision2 != null && decision2.getImprovement() < 0.0) {
                Poold.OPT_LOG.log((Level)Severity.DEBUG, move + " vetoed by decision " + decision2.describe());
                return true;
            }
        }
        return false;
    }

    public static DecisionHistory loadFromFile(String string) throws IOException, ClassNotFoundException {
        return DecisionHistory.load(new FileInputStream(string));
    }

    public void syncToFile(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.sync(fileOutputStream);
        fileOutputStream.close();
    }

    public static DecisionHistory load(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        DecisionHistory decisionHistory = (DecisionHistory)objectInputStream.readObject();
        return decisionHistory;
    }

    public void sync(OutputStream outputStream) throws IOException {
        new ObjectOutputStream(outputStream).writeObject(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.decisions.keySet().size() + " decisions {");
        Iterator iterator = this.decisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Decision decision = (Decision)this.decisions.get(string);
            stringBuffer.append("\t(");
            stringBuffer.append(decision.describe());
            stringBuffer.append(")\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void expireAndMeasureImprovements(Monitor monitor) {
        int n;
        Object object;
        if (monitor.isValid()) {
            Iterator iterator = this.resourcesAwaitingImprovement.keySet().iterator();
            while (iterator.hasNext()) {
                block6: {
                    object = (Resource)iterator.next();
                    try {
                        double d = monitor.getUtilization((Resource)object);
                        this.recordImprovementWithUtilization((Resource)object, d);
                    }
                    catch (StaleMonitorException staleMonitorException) {
                        String string = (String)this.resourcesAwaitingImprovement.get(object);
                        if (string == null) break block6;
                        this.decisions.remove(string);
                    }
                }
                iterator.remove();
            }
        }
        if ((n = monitor.getSampleCount() - 256) > 0) {
            int n2;
            ListIterator listIterator = this.decisionList.listIterator(0);
            while (listIterator.hasNext() && (n2 = ((Decision)(object = (Decision)listIterator.next())).getStartingSampleCount()) < n) {
                if (n2 <= 0) continue;
                Poold.OPT_LOG.log((Level)Severity.DEBUG, "expiring decision (" + object + ")");
                listIterator.remove();
                this.decisions.remove(((Decision)object).getKey());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.resourcesAwaitingImprovement = new HashMap();
        this.decisionList = new LinkedList();
        Iterator iterator = this.decisions.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Decision decision = (Decision)this.decisions.get(string);
            decision.setStartingSampleCount(0);
            this.decisionList.add(decision);
        }
    }

    private static final class ComponentMoveDecision
    extends Decision {
        private String cpuid;
        private String fromPsetName;
        private String toPsetName;
        private String fromPsetComposition;
        private String toPsetComposition;
        private int toPsetSize;
        private String utilizationClass;
        private static final long serialVersionUID = -142211449L;

        public ComponentMoveDecision(ComponentMove componentMove, double d) throws IllegalArgumentException {
            try {
                this.cpuid = componentMove.getComponents().toString();
                this.fromPsetName = componentMove.getFrom().toString();
                this.toPsetName = componentMove.getTo().toString();
                this.fromPsetComposition = componentMove.getFrom().getComponents(null).toString();
                this.toPsetComposition = componentMove.getTo().getComponents(null).toString();
                this.toPsetSize = componentMove.getTo().getComponents(null).size();
                this.utilizationClass = this.computeUtilizationClass(d);
                this.setStartingUtilization(d);
            }
            catch (PoolsException poolsException) {
                throw (IllegalArgumentException)new IllegalArgumentException().initCause(poolsException);
            }
        }

        public String getKey() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.cpuid);
            stringBuffer.append(", ");
            stringBuffer.append(this.fromPsetName);
            stringBuffer.append(", ");
            stringBuffer.append(this.toPsetName);
            return stringBuffer.toString();
        }

        public void setImprovementWithNewUtilization(double d) {
            double d2 = (double)(this.toPsetSize - 1) / (double)this.toPsetSize;
            double d3 = d2 * this.getStartingUtilization();
            Poold.OPT_LOG.log((Level)Severity.DEBUG, "pset improvement calculation expected " + d3 + ", got " + d);
            this.setImprovement(d - d3);
        }

        public int hashCode() {
            return this.cpuid.hashCode() ^ this.fromPsetName.hashCode() ^ this.toPsetName.hashCode() ^ this.fromPsetComposition.hashCode() ^ this.toPsetComposition.hashCode() ^ this.utilizationClass.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentMoveDecision)) {
                return false;
            }
            ComponentMoveDecision componentMoveDecision = (ComponentMoveDecision)object;
            return this.cpuid.equals(componentMoveDecision.cpuid) && this.fromPsetName.equals(componentMoveDecision.fromPsetName) && this.toPsetName.equals(componentMoveDecision.toPsetName) && this.fromPsetComposition.equals(componentMoveDecision.fromPsetComposition) && this.toPsetComposition.equals(componentMoveDecision.toPsetComposition) && this.utilizationClass.equals(componentMoveDecision.utilizationClass);
        }

        private String computeUtilizationClass(double d) {
            return "I";
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.cpuid.toString());
            stringBuffer.append(", ");
            stringBuffer.append(this.fromPsetName.toString());
            stringBuffer.append(", ");
            stringBuffer.append(this.toPsetName.toString());
            stringBuffer.append(", ");
            stringBuffer.append(this.fromPsetComposition.toString());
            stringBuffer.append(", ");
            stringBuffer.append(this.toPsetComposition.toString());
            stringBuffer.append(", ");
            stringBuffer.append(this.utilizationClass.toString());
            return stringBuffer.toString();
        }
    }

    private static abstract class Decision
    implements Serializable {
        private double startingUtilization = 0.0;
        private double improvement = 0.0;
        private int usage = 0;
        private int startingSampleCount;
        private Date date = new Date();
        private static final long serialVersionUID = 126224007L;
        private static SimpleDateFormat dateFormatter;
        private static final String dateFormat = "MMM d kk:mm:ss";

        public abstract String getKey();

        public static final Decision forMove(Move move, double d) {
            if (move instanceof ComponentMove) {
                return new ComponentMoveDecision((ComponentMove)move, d);
            }
            return null;
        }

        private Decision() {
        }

        public final void setStartingUtilization(double d) {
            this.startingUtilization = d;
        }

        public void setStartingSampleCount(int n) {
            this.startingSampleCount = n;
        }

        public int getStartingSampleCount() {
            return this.startingSampleCount;
        }

        public abstract void setImprovementWithNewUtilization(double var1);

        protected void setImprovement(double d) {
            this.improvement = d;
        }

        public final double getImprovement() {
            return this.improvement;
        }

        public final double getStartingUtilization() {
            return this.startingUtilization;
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract String toString();

        public final int getUsage() {
            return this.usage;
        }

        private final void incrementUsage() {
            ++this.usage;
        }

        public final Date getDate() {
            return this.date;
        }

        public final String describe() {
            if (dateFormatter == null) {
                dateFormatter = new SimpleDateFormat(dateFormat);
            }
            return this.toString() + " made at " + dateFormatter.format(this.getDate()) + " with improvement " + this.getImprovement() + " used " + this.getUsage() + " times";
        }
    }
}

