/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.ComponentMove;
import com.sun.solaris.domain.pools.KVExpression;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.service.locality.LocalityDomain;
import com.sun.solaris.service.locality.LocalityGroup;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

final class LocalityObjective
extends AbstractObjective {
    static final String name = "locality";
    private LocalityDomain ldom;

    LocalityObjective() {
    }

    public void prepare(LocalityDomain localityDomain, Resource resource) throws PoolsException {
        this.ldom = localityDomain;
    }

    public double calculate(Configuration configuration, Move move, Element element) throws PoolsException {
        KVExpression kVExpression = (KVExpression)this.getExpression();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Resource resource = (Resource)element;
        ComponentMove componentMove = (ComponentMove)move;
        Poold.MON_LOG.log((Level)Severity.DEBUG, "Calculating objective type: locality for: " + element);
        if (kVExpression.getValue().compareTo("none") == 0) {
            return d;
        }
        if (this.ldom.getMaxLatency() == 0) {
            return d;
        }
        if (!element.equals(move.getFrom()) && !element.equals(move.getTo())) {
            return d;
        }
        List list = resource.getComponents(null);
        Set set = this.ldom.foreignGroups(new HashSet(), list);
        d3 = this.calcQ(list, set);
        if (element.equals(move.getFrom())) {
            list.removeAll(componentMove.getComponents());
        } else {
            list.addAll(componentMove.getComponents());
        }
        set = this.ldom.foreignGroups(new HashSet(), list);
        d2 = this.calcQ(list, set);
        d = d2 - d3;
        if (kVExpression.getValue().compareTo("loose") == 0) {
            d = 0.0 - d;
        }
        Poold.MON_LOG.log((Level)Severity.DEBUG, "ret: " + d);
        return d;
    }

    private double calcQ(List list, Set set) throws PoolsException {
        Iterator iterator = set.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            int n;
            LocalityGroup localityGroup = (LocalityGroup)iterator.next();
            int[] nArray = localityGroup.getCPUIDs();
            Iterator iterator2 = list.iterator();
            int n2 = 0;
            double d2 = 0.0;
            block1: while (iterator2.hasNext()) {
                Component component = (Component)iterator2.next();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != (int)component.getLongProperty("cpu.sys_id")) continue;
                    ++n2;
                    continue block1;
                }
            }
            double d3 = 0.0;
            for (n = 1; n <= nArray.length; ++n) {
                d3 += (double)n;
            }
            d3 = 1.0 / d3;
            for (n = 1; n <= n2; ++n) {
                d += (double)n * d3;
            }
        }
        return d /= (double)set.size();
    }
}

