/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.DoubleStatistic;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.ResourceMonitor;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.StatisticList;
import com.sun.solaris.domain.pools.UnsignedInt64Statistic;
import com.sun.solaris.service.kstat.Kstat;
import com.sun.solaris.service.kstat.KstatChainUpdateException;
import com.sun.solaris.service.kstat.KstatCtl;
import com.sun.solaris.service.kstat.KstatException;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.UnsignedInt64;
import com.sun.solaris.service.pools.Value;
import com.sun.solaris.service.timer.RecurringEventTimer;
import com.sun.solaris.service.timer.SimpleRecurringEventTimer;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;

class SystemMonitor
implements Monitor {
    private Configuration conf;
    private Map monitored;
    public static final int DEF_SAMPLE_INT = 15000;
    private int interval;
    static final String SAMPLE_INTERVAL_PROP_NAME = "system.poold.monitor-interval";
    private KstatCtl kc;
    private final String[] stats = new String[]{"idle", "kernel", "wait", "user"};
    private RecurringEventTimer timer;
    private int sampleCount = 0;
    private Date lastSampleTime = null;

    public SystemMonitor() {
        this(null);
    }

    public SystemMonitor(Configuration configuration) {
        this.conf = configuration;
        this.monitored = new HashMap();
        this.kc = new KstatCtl();
    }

    public void initialize(Configuration configuration) throws PoolsException, StaleMonitorException {
        Poold.CONF_LOG.log((Level)Severity.DEBUG, "initializing");
        this.conf = configuration;
        try {
            this.kc.chainUpdate();
        }
        catch (KstatChainUpdateException kstatChainUpdateException) {
            Poold.utility.die(Poold.CONF_LOG, kstatChainUpdateException);
        }
        try {
            this.interval = (int)configuration.getLongProperty(SAMPLE_INTERVAL_PROP_NAME);
        }
        catch (PoolsException poolsException) {
            this.interval = 15000;
        }
        this.timer = new SimpleRecurringEventTimer(this.interval);
        this.setResourceMonitors("pset");
    }

    private void setResourceMonitors(String string) throws PoolsException, StaleMonitorException {
        Value value = new Value("type", string);
        LinkedList<Value> linkedList = new LinkedList<Value>();
        linkedList.add(value);
        Iterator iterator = this.conf.getResources(linkedList).iterator();
        value.close();
        HashSet hashSet = new HashSet(this.monitored.keySet());
        while (iterator.hasNext()) {
            int n;
            Object object;
            Resource resource = (Resource)iterator.next();
            ResourceMonitor resourceMonitor = null;
            boolean bl = false;
            List list = resource.getComponents(null);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Component component = (Component)iterator2.next();
                object = component.getStringProperty("cpu.status");
                if (((String)object).compareTo("off-line") == 0 || ((String)object).compareTo("powered-off") == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            if (this.monitored.containsKey(resource)) {
                resourceMonitor = this.get(resource);
                for (n = 0; n < this.stats.length; ++n) {
                    resourceMonitor.resetData(this.stats[n]);
                }
            } else {
                resourceMonitor = new ResourceMonitor(resource, 50);
                for (n = 0; n < this.stats.length; ++n) {
                    object = new StatisticList(this.stats[n], 2);
                    resourceMonitor.put(this.stats[n], object);
                }
                resourceMonitor.put("utilization", new StatisticList("utilization", resourceMonitor.getMaxSampleSize(), true));
                this.monitored.put(resource, resourceMonitor);
            }
            resourceMonitor.initialize();
            hashSet.remove(resource);
        }
        this.monitored.keySet().removeAll(hashSet);
    }

    public void getNext() throws StaleMonitorException, PoolsException, InterruptedException {
        Poold.MON_LOG.log((Level)Severity.DEBUG, "waiting sampling interval");
        Date date = this.lastSampleTime;
        if (date == null) {
            date = new Date();
        }
        this.timer.waitUntilNextFiring();
        Date date2 = new Date();
        Poold.MON_LOG.log((Level)Severity.DEBUG, "sampling");
        Iterator iterator = this.monitored.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            ResourceMonitor resourceMonitor = (ResourceMonitor)iterator.next();
            List list = resourceMonitor.getComponents();
            Iterator iterator2 = list.iterator();
            BigInteger[] bigIntegerArray = new BigInteger[4];
            while (iterator2.hasNext()) {
                Component component = (Component)iterator2.next();
                object = this.kc.lookup("cpu", (int)component.getLongProperty("cpu.sys_id"), "sys");
                if (object == null) {
                    throw new StaleMonitorException();
                }
                try {
                    ((Kstat)object).read();
                    for (int i = 0; i < this.stats.length; ++i) {
                        UnsignedInt64 unsignedInt64 = (UnsignedInt64)((Kstat)object).getValue("cpu_ticks_" + this.stats[i]);
                        if (unsignedInt64 == null) {
                            throw new StaleMonitorException();
                        }
                        bigIntegerArray[i] = bigIntegerArray[i] == null ? unsignedInt64 : bigIntegerArray[i].add(unsignedInt64);
                    }
                }
                catch (KstatException kstatException) {
                    StaleMonitorException staleMonitorException = new StaleMonitorException();
                    staleMonitorException.initCause(kstatException);
                    Poold.MON_LOG.log((Level)Severity.DEBUG, "configuration necessary due to " + kstatException);
                    throw staleMonitorException;
                }
            }
            if (!list.isEmpty()) {
                for (int i = 0; i < this.stats.length; ++i) {
                    object = (StatisticList)resourceMonitor.get(this.stats[i]);
                    ((StatisticList)object).add(new UnsignedInt64Statistic(new UnsignedInt64(bigIntegerArray[i].divide(new BigInteger(Integer.toString(list.size())))), date, date2));
                }
            }
            resourceMonitor.updateDerived();
        }
        ++this.sampleCount;
        this.lastSampleTime = date2;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public double getUtilization(Resource resource) throws StaleMonitorException {
        ResourceMonitor resourceMonitor = this.get(resource);
        DoubleStatistic doubleStatistic = null;
        try {
            doubleStatistic = (DoubleStatistic)resourceMonitor.getDerivedStatistic("utilization");
        }
        catch (NoSuchElementException noSuchElementException) {
            doubleStatistic = new DoubleStatistic(new Double(0.0));
        }
        Poold.MON_LOG.log((Level)Severity.DEBUG, resource + " utilization " + doubleStatistic.toString());
        return (Double)doubleStatistic.getValue();
    }

    public boolean isValid() {
        Iterator iterator = this.monitored.values().iterator();
        while (iterator.hasNext()) {
            ResourceMonitor resourceMonitor = (ResourceMonitor)iterator.next();
            Iterator iterator2 = resourceMonitor.values().iterator();
            while (iterator2.hasNext()) {
                StatisticList statisticList = (StatisticList)iterator2.next();
                if (statisticList.getName().compareTo("utilization") != 0 || statisticList.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public ResourceMonitor get(Resource resource) throws StaleMonitorException {
        ResourceMonitor resourceMonitor = (ResourceMonitor)this.monitored.get(resource);
        if (resourceMonitor == null) {
            throw new StaleMonitorException();
        }
        return resourceMonitor;
    }
}

