/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.KVOpExpression;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.ResourceMonitor;
import com.sun.solaris.domain.pools.Solver;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.StatisticList;
import com.sun.solaris.domain.pools.WorkloadDependentObjective;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

final class UtilizationObjective
extends AbstractObjective
implements WorkloadDependentObjective {
    static final String name = "utilization";
    private List zoneList = new LinkedList();
    private static final DecimalFormat uf = new DecimalFormat("0.00");
    private Solver gapSolver;

    UtilizationObjective() {
    }

    public boolean examine(Configuration configuration, Solver solver, Element element) throws PoolsException, StaleMonitorException {
        ResourceMonitor resourceMonitor;
        KVOpExpression kVOpExpression = (KVOpExpression)this.getExpression();
        try {
            resourceMonitor = solver.getMonitor().get((Resource)element);
        }
        catch (StaleMonitorException staleMonitorException) {
            Poold.MON_LOG.log((Level)Severity.INFO, element.toString() + " utilization objective not measured " + this.toString() + " as there are no available " + "statistics.");
            return false;
        }
        this.gapSolver = solver;
        double d = solver.getMonitor().getUtilization((Resource)element);
        StatisticList statisticList = (StatisticList)resourceMonitor.get(name);
        int n = statisticList.getZone(kVOpExpression, d);
        if (this.zoneList.size() == 9) {
            this.zoneList.remove(0);
        }
        this.zoneList.add(new Integer(statisticList.getZoneMean(d)));
        if ((n & 0x10000) == 65536) {
            if (kVOpExpression.getOp() == '<' && (n & 1) == 0) {
                return false;
            }
            if (kVOpExpression.getOp() == '>' && (n & 1) == 1) {
                return false;
            }
            Poold.MON_LOG.log((Level)Severity.INFO, element.toString() + " utilization objective not satisfied " + this.toString() + " with utilization " + uf.format(d) + " (control zone bounds exceeded)");
            return true;
        }
        this.checkShort(resourceMonitor, element, d);
        return false;
    }

    public double calculate(Configuration configuration, Move move, Element element) throws PoolsException {
        double d;
        KVOpExpression kVOpExpression = (KVOpExpression)this.getExpression();
        try {
            if (element.equals(move.getFrom())) {
                double d2 = this.gapSolver.getMonitor().getUtilization(move.getFrom());
                StatisticList statisticList = (StatisticList)this.gapSolver.getMonitor().get(move.getFrom()).get(name);
                double d3 = statisticList.getGap(kVOpExpression, d2) / 100.0;
                d = this.gapSolver.getObjectives(move.getTo()) == null ? (d3 < 0.0 ? -1.0 - d3 : -1.0) : 0.0 - d3;
            } else if (element.equals(move.getTo())) {
                double d4 = this.gapSolver.getMonitor().getUtilization(move.getTo());
                StatisticList statisticList = (StatisticList)this.gapSolver.getMonitor().get(move.getTo()).get(name);
                double d5 = statisticList.getGap(kVOpExpression, d4) / 100.0;
                d = this.gapSolver.getObjectives(move.getFrom()) == null ? (d5 < 0.0 ? 0.0 - d5 : 1.0) : 0.0 + d5;
            } else {
                d = 0.0;
            }
        }
        catch (StaleMonitorException staleMonitorException) {
            d = 0.0;
        }
        Poold.MON_LOG.log((Level)Severity.DEBUG, "ret: " + d);
        return d;
    }

    private void checkShort(ResourceMonitor resourceMonitor, Element element, double d) {
        boolean bl = true;
        int n = 0;
        boolean bl2 = false;
        Iterator iterator = this.zoneList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (bl2) {
                if (!bl || (n2 & 1) == n) continue;
                bl = false;
                continue;
            }
            if (this.zoneList.size() < 9) continue;
            n = n2 & 1;
            bl2 = true;
        }
        if (this.zoneList.size() >= 9 && bl) {
            Poold.MON_LOG.log((Level)Severity.INFO, element.toString() + " utilization objective statistics reinitialized " + this.toString() + " with utilization " + uf.format(d) + " (nine points on same side of mean)");
            resourceMonitor.resetData(name);
            this.zoneList.clear();
        }
    }
}

