/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.AbstractObjective;
import com.sun.solaris.domain.pools.Monitor;
import com.sun.solaris.domain.pools.Move;
import com.sun.solaris.domain.pools.Poold;
import com.sun.solaris.domain.pools.Solver;
import com.sun.solaris.domain.pools.StaleMonitorException;
import com.sun.solaris.domain.pools.WorkloadDependentObjective;
import com.sun.solaris.service.logging.Severity;
import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

final class WeightedLoadObjective
extends AbstractObjective
implements WorkloadDependentObjective {
    static final String name = "wt-load";
    Map calcMap;

    WeightedLoadObjective() {
    }

    public boolean examine(Configuration configuration, Solver solver, Element element) throws PoolsException, StaleMonitorException {
        Object object;
        Object object2;
        Monitor monitor = solver.getMonitor();
        Value value = new Value("type", "pset");
        LinkedList<Value> linkedList = new LinkedList<Value>();
        this.calcMap = new HashMap();
        linkedList.add(value);
        List list = configuration.getResources(linkedList);
        value.close();
        Iterator iterator = list.iterator();
        Calculation.totalUtil = 0.0;
        Calculation.resQ = 0;
        while (iterator.hasNext()) {
            object2 = (Resource)iterator.next();
            object = ((Resource)object2).getComponents(null);
            try {
                Calculation calculation = new Calculation((Resource)object2, (List)object, monitor.getUtilization((Resource)object2), ((Element)object2).getLongProperty("pset.min"), ((Element)object2).getLongProperty("pset.max"));
                this.calcMap.put(object2, calculation);
            }
            catch (StaleMonitorException staleMonitorException) {
                Poold.MON_LOG.log((Level)Severity.INFO, ((Resource)object2).toString() + " not participating in " + this.toString() + " calculatation as it has no " + "available statistics.");
            }
        }
        object2 = this.calcMap.values().iterator();
        while (object2.hasNext()) {
            object = (Calculation)object2.next();
            if (((Calculation)object).getShare() == (long)((Calculation)object).comp.size() || ((Calculation)object).getShare() < ((Calculation)object).min) continue;
            Poold.MON_LOG.log((Level)Severity.INFO, element.toString() + " utilization objective not satisfied " + this.toString() + " with desired share " + ((Calculation)object).getShare() + " and actual share " + ((Calculation)object).comp.size());
            return true;
        }
        return false;
    }

    public double calculate(Configuration configuration, Move move, Element element) throws PoolsException {
        double d = 0.0;
        Poold.OPT_LOG.log((Level)Severity.DEBUG, "Calculating objective type: wt-load");
        if (move.getQty() == 0L) {
            return 0.0;
        }
        Calculation calculation = (Calculation)this.calcMap.get(move.getFrom());
        Calculation calculation2 = (Calculation)this.calcMap.get(move.getTo());
        long l = Math.abs(calculation.getShare() - (long)calculation.comp.size());
        long l2 = Math.abs(calculation.getShare() - ((long)calculation.comp.size() - move.getQty()));
        d = l - l2;
        l = Math.abs(calculation2.getShare() - (long)calculation2.comp.size());
        l2 = Math.abs(calculation2.getShare() - ((long)calculation2.comp.size() + move.getQty()));
        d += (double)(l - l2);
        Poold.MON_LOG.log((Level)Severity.DEBUG, "ret: " + (d /= (double)Calculation.resQ * 2.0));
        return d;
    }

    static class Calculation {
        Resource res;
        List comp;
        double util;
        long min;
        long max;
        static double totalUtil;
        static int resQ;

        public Calculation(Resource resource, List list, double d, long l, long l2) {
            this.res = resource;
            this.comp = list;
            this.min = l;
            this.max = l2;
            this.util = d / 100.0 * (double)list.size();
            totalUtil += this.util;
            resQ += list.size();
        }

        long getShare() {
            if (this.util == 0.0) {
                return 0L;
            }
            return Math.round(this.util / totalUtil * (double)resQ);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("res: " + this.res.toString());
            stringBuffer.append(" components: " + this.comp.toString());
            stringBuffer.append(" min: " + this.min);
            stringBuffer.append(" max: " + this.max);
            stringBuffer.append(" util: " + this.util);
            stringBuffer.append(" total resource: " + resQ);
            stringBuffer.append(" total utilization: " + totalUtil);
            stringBuffer.append(" share: " + this.getShare());
            return stringBuffer.toString();
        }
    }
}

