/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.exception;

import java.io.PrintStream;

public class SuccinctStackTraceFormatter {
    public static String formatWithDescription(Throwable throwable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(throwable.getClass().getName());
        stringBuffer.append(", ");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            SuccinctStackTraceFormatter.appendStackTraceElement(i > 0 ? stackTraceElementArray[i - 1] : null, stackTraceElementArray[i], stringBuffer);
            if (i == stackTraceElementArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        if (throwable.getCause() != null) {
            stringBuffer.append(" caused by ");
            stringBuffer.append(SuccinctStackTraceFormatter.format(throwable.getCause()));
        }
        return stringBuffer.toString();
    }

    public static String format(Throwable throwable) {
        return SuccinctStackTraceFormatter.formatWithDescription(throwable, null);
    }

    private static void appendStackTraceElement(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2, StringBuffer stringBuffer) {
        if (stackTraceElement == null || !stackTraceElement.getClassName().equals(stackTraceElement2.getClassName())) {
            stringBuffer.append(stackTraceElement2.getClassName());
            stringBuffer.append(".");
        } else {
            stringBuffer.append("&.");
        }
        stringBuffer.append(stackTraceElement2.getMethodName());
        if (stackTraceElement2.getLineNumber() > 0) {
            stringBuffer.append(":");
            stringBuffer.append(stackTraceElement2.getLineNumber());
        }
        if (stackTraceElement2.isNativeMethod()) {
            stringBuffer.append(":");
            stringBuffer.append("native");
        }
    }

    public static void printStackTrace(Throwable throwable) {
        SuccinctStackTraceFormatter.printStackTrace(throwable, System.err);
    }

    public static void printStackTrace(Throwable throwable, PrintStream printStream) {
        printStream.print(throwable);
        printStream.print(" at ");
        printStream.print(SuccinctStackTraceFormatter.format(throwable));
    }

    public static final void main(String[] stringArray) {
        SuccinctStackTraceFormatter.printStackTrace(SuccinctStackTraceFormatter.big());
    }

    public static final Throwable big() {
        return new Throwable().initCause(SuccinctStackTraceFormatter.little());
    }

    public static final Throwable little() {
        return new Throwable();
    }
}

