/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.Component;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.Pool;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configuration
extends Element {
    private boolean _valid = false;
    private long _this = PoolInternal.pool_conf_alloc();
    private String name;
    private Map elements;
    private String key;

    public Configuration(String string, int n) throws PoolsException {
        if (this._this == 0L) {
            throw new PoolsException();
        }
        this._conf = this;
        this.open(string, n);
        this.elements = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            if (this._this != 0L) {
                PoolInternal.pool_conf_free(this._this);
                this._this = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    final long getConf() {
        return this._this;
    }

    public void open(String string, int n) throws PoolsException {
        if (!this._valid) {
            if (PoolInternal.pool_conf_open(this.getConf(), string, n) != 0) {
                throw new PoolsException();
            }
            this._valid = true;
            this.name = this.getStringProperty("system.name");
            this.key = "system." + this.name;
        }
    }

    public void close() {
        if (this._valid) {
            this.elements.clear();
            PoolInternal.pool_conf_close(this.getConf());
            this.key = null;
            this.name = null;
        }
        this._valid = false;
    }

    public String getLocation() {
        return PoolInternal.pool_conf_location(this.getConf());
    }

    public int status() {
        return PoolInternal.pool_conf_status(this.getConf());
    }

    public void remove() throws PoolsException {
        if (PoolInternal.pool_conf_remove(this.getConf()) != 0) {
            throw new PoolsException();
        }
    }

    public void rollback() throws PoolsException {
        if (PoolInternal.pool_conf_rollback(this.getConf()) != 0) {
            throw new PoolsException();
        }
    }

    public void commit(int n) throws PoolsException {
        if (PoolInternal.pool_conf_commit(this.getConf(), n) != 0) {
            throw new PoolsException();
        }
    }

    public void export(String string, int n) throws PoolsException {
        if (PoolInternal.pool_conf_export(this.getConf(), string, n) != 0) {
            throw new PoolsException();
        }
    }

    public void validate(int n) throws PoolsException {
        if (PoolInternal.pool_conf_validate(this.getConf(), n) != 0) {
            throw new PoolsException();
        }
    }

    public int update() throws PoolsException {
        return PoolInternal.pool_conf_update(this.getConf());
    }

    public Pool createPool(String string) throws PoolsException {
        long l = PoolInternal.pool_create(this.getConf(), string);
        if (l == 0L) {
            throw new PoolsException();
        }
        Pool pool = new Pool(this, l);
        this.elements.put(pool.getKey(), pool);
        return pool;
    }

    public void destroyPool(Pool pool) throws PoolsException {
        this.elements.remove(pool.getKey());
        PoolInternal.pool_destroy(this.getConf(), pool.getPool());
    }

    public Pool getPool(String string) throws PoolsException {
        long l = PoolInternal.pool_get_pool(this.getConf(), string);
        if (l == 0L) {
            throw new PoolsException();
        }
        if (this.elements.containsKey("PoolInternal." + string)) {
            return (Pool)this.elements.get("PoolInternal." + string);
        }
        Pool pool = new Pool(this, l);
        this.elements.put(pool.getKey(), pool);
        return pool;
    }

    long checkPool(String string) throws PoolsException {
        long l = PoolInternal.pool_get_pool(this.getConf(), string);
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    public List getPools(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_pools(this.getConf(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        ArrayList<Pool> arrayList = new ArrayList<Pool>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(new Pool(this, (Long)list2.get(i)));
        }
        return arrayList;
    }

    public Resource createResource(String string, String string2) throws PoolsException {
        long l = PoolInternal.pool_resource_create(this.getConf(), string, string2);
        if (l == 0L) {
            throw new PoolsException();
        }
        Resource resource = new Resource(this, l);
        this.elements.put(resource.getKey(), resource);
        return resource;
    }

    public void destroyResource(Resource resource) throws PoolsException {
        this.elements.remove(resource.getKey());
        PoolInternal.pool_resource_destroy(this.getConf(), resource.getResource());
    }

    public Resource getResource(String string, String string2) throws PoolsException {
        long l = PoolInternal.pool_get_resource(this.getConf(), string, string2);
        if (l == 0L) {
            throw new PoolsException();
        }
        if (this.elements.containsKey(string + "." + string2)) {
            return (Resource)this.elements.get(string + "." + string2);
        }
        Resource resource = new Resource(this, l);
        this.elements.put(resource.getKey(), resource);
        return resource;
    }

    long checkResource(String string, String string2) throws PoolsException {
        long l = PoolInternal.pool_get_resource(this.getConf(), string, string2);
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    public List getResources(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_resources(this.getConf(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(new Resource(this, (Long)list2.get(i)));
        }
        return arrayList;
    }

    public Component getComponent(String string, long l) throws PoolsException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        Value value = new Value("type", string);
        Value value2 = new Value(string + ".sys_id", l);
        arrayList.add(value);
        arrayList.add(value2);
        List list = this.getComponents(arrayList);
        value.close();
        value2.close();
        if (list.size() != 1) {
            throw new PoolsException();
        }
        return (Component)list.get(0);
    }

    long checkComponent(String string, long l) throws PoolsException {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        Value value = new Value("type", string);
        Value value2 = new Value(string + ".sys_id", l);
        arrayList.add(value);
        arrayList.add(value2);
        List list = this.checkComponents(arrayList);
        value.close();
        value2.close();
        if (list.size() != 1) {
            throw new PoolsException();
        }
        return (Long)list.get(0);
    }

    public List getComponents(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_components(this.getConf(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        ArrayList<Component> arrayList = new ArrayList<Component>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            Value value = new Value(this.name);
            if (PoolInternal.pool_get_property(this.getConf(), (Long)list2.get(i), "type", value.getValue()) == PoolInternal.POC_INVAL) {
                throw new PoolsException();
            }
            if (value == null) {
                throw new PoolsException();
            }
            String string = value.getString();
            value.close();
            Value value2 = new Value(this.name);
            if (PoolInternal.pool_get_property(this.getConf(), (Long)list2.get(i), string + ".sys_id", value2.getValue()) == PoolInternal.POC_INVAL) {
                throw new PoolsException();
            }
            if (value2 == null) {
                throw new PoolsException();
            }
            long l = value2.getLong();
            value2.close();
            if (this.elements.containsKey(string + "." + l)) {
                arrayList.add((Component)this.elements.get(string + "." + l));
                continue;
            }
            arrayList.add(new Component(this, (Long)list2.get(i)));
        }
        return arrayList;
    }

    List checkComponents(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_components(this.getConf(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        return list2;
    }

    public String getInformation(int n) {
        return PoolInternal.pool_conf_info(this._conf.getConf(), n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("system: ");
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)object;
        return this.name.compareTo(configuration.getName()) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected long getElem() throws PoolsException {
        long l = PoolInternal.pool_conf_to_elem(this.getConf());
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    String getName() {
        return this.name;
    }

    String getKey() {
        return this.key;
    }
}

