/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Resource;
import com.sun.solaris.service.pools.Value;
import java.util.ArrayList;
import java.util.List;

public class Pool
extends Element {
    private final String name;
    private final String key;

    Pool(Configuration configuration, long l) throws PoolsException {
        this._conf = configuration;
        Value value = this.getProperty("pool.name", l);
        this.name = value.getString();
        value.close();
        this.key = "pool." + this.name;
    }

    long getPool() throws PoolsException {
        return this._conf.checkPool(this.name);
    }

    public void associate(Resource resource) throws PoolsException {
        if (PoolInternal.pool_associate(this._conf.getConf(), this.getPool(), resource.getResource()) != 0) {
            throw new PoolsException();
        }
    }

    public void dissociate(Resource resource) throws PoolsException {
        if (PoolInternal.pool_dissociate(this._conf.getConf(), this.getPool(), resource.getResource()) != 0) {
            throw new PoolsException();
        }
    }

    public List getResources(List list) throws PoolsException {
        List list2 = PoolInternal.pool_query_pool_resources(this._conf.getConf(), this.getPool(), list);
        if (list2 == null) {
            if (PoolInternal.pool_error() == 4) {
                return new ArrayList();
            }
            throw new PoolsException();
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            arrayList.add(new Resource(this._conf, (Long)list2.get(i)));
        }
        return arrayList;
    }

    public String getInformation(int n) throws PoolsException {
        return PoolInternal.pool_info(this._conf.getConf(), this.getPool(), n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pool: ");
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Pool)) {
            return false;
        }
        Pool pool = (Pool)object;
        return this.name.compareTo(pool.getName()) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected long getElem() throws PoolsException {
        long l = PoolInternal.pool_to_elem(this._conf.getConf(), this.getPool());
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    String getName() {
        return this.name;
    }

    String getKey() {
        return this.key;
    }
}

