/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.UnsignedInt64;

public class Value {
    private long _this;

    private Value(long l) {
        this._this = l;
    }

    public Value(String string) throws PoolsException {
        this._this = PoolInternal.pool_value_alloc();
        if (this._this == 0L) {
            throw new PoolsException();
        }
        this.setName(string);
    }

    public Value(String string, long l) throws PoolsException {
        this(string);
        this.setValue(l);
    }

    public Value(String string, long l, boolean bl) throws PoolsException {
        this(string);
        this.setValue(l, bl);
    }

    public Value(String string, String string2) throws PoolsException {
        this(string);
        this.setValue(string2);
    }

    public Value(String string, boolean bl) throws PoolsException {
        this(string);
        this.setValue(bl);
    }

    public Value(String string, double d) throws PoolsException {
        this(string);
        this.setValue(d);
    }

    public void close() {
        if (this._this != 0L) {
            PoolInternal.pool_value_free(this._this);
            this._this = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void setName(String string) {
        PoolInternal.pool_value_set_name(this._this, string);
    }

    public void setValue(long l) {
        PoolInternal.pool_value_set_int64(this._this, l);
    }

    public void setValue(long l, boolean bl) {
        if (bl) {
            this.setValue(l);
        }
        PoolInternal.pool_value_set_uint64(this._this, l);
    }

    public void setValue(String string) throws PoolsException {
        if (PoolInternal.pool_value_set_string(this._this, string) != 0) {
            throw new PoolsException();
        }
    }

    public void setValue(boolean bl) {
        if (bl) {
            PoolInternal.pool_value_set_bool(this._this, (short)1);
        } else {
            PoolInternal.pool_value_set_bool(this._this, (short)0);
        }
    }

    public void setValue(double d) {
        PoolInternal.pool_value_set_double(this._this, d);
    }

    public String getName() {
        return PoolInternal.pool_value_get_name(this._this);
    }

    public long getValue() {
        return this._this;
    }

    public int getType() {
        return PoolInternal.pool_value_get_type(this._this);
    }

    public String toString() {
        int n = PoolInternal.pool_value_get_type(this._this);
        try {
            if (n == PoolInternal.POC_INT || n == PoolInternal.POC_UINT) {
                return String.valueOf(this.getLong());
            }
            if (n == PoolInternal.POC_STRING) {
                return this.getString();
            }
            if (n == PoolInternal.POC_BOOL) {
                return String.valueOf(this.getBool());
            }
            if (n == PoolInternal.POC_DOUBLE) {
                return String.valueOf(this.getDouble());
            }
        }
        catch (PoolsException poolsException) {
            return poolsException.toString();
        }
        return "";
    }

    public final UnsignedInt64 getUnsignedInt64() throws PoolsException {
        return Value.getUnsignedInt64Value(this._this);
    }

    public final long getLong() throws PoolsException {
        return Value.getLongValue(this._this);
    }

    public final String getString() throws PoolsException {
        return Value.getStringValue(this._this);
    }

    public final boolean getBool() throws PoolsException {
        return Value.getBoolValue(this._this);
    }

    public final double getDouble() throws PoolsException {
        return Value.getDoubleValue(this._this);
    }

    private static final native UnsignedInt64 getUnsignedInt64Value(long var0);

    private static final native long getLongValue(long var0);

    private static final native String getStringValue(long var0);

    private static final native boolean getBoolValue(long var0);

    private static final native double getDoubleValue(long var0);
}

