/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.opensolaris.os.dtrace.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinearDistribution
extends Distribution
implements Serializable,
Comparable<LinearDistribution> {
    static final long serialVersionUID = 7100080045858770132L;
    private long base;
    private long step;

    private LinearDistribution(long lowerBound, long frequencyStep, long[] frequencies) {
        super(lowerBound, frequencyStep, frequencies);
        this.base = lowerBound;
        this.step = frequencyStep;
    }

    public LinearDistribution(long lowerBound, long bucketStep, List<Distribution.Bucket> frequencies) {
        super(frequencies);
        this.base = lowerBound;
        this.step = bucketStep;
        this.initialize();
        if (this.step < 1L) {
            throw new IllegalArgumentException("step is less than one");
        }
    }

    @Override
    long[] getBucketRange(int i, int len, long base, long step) {
        long min = i == 0 ? Long.MIN_VALUE : base + (long)(i - 1) * step;
        long max = i == len - 1 ? Long.MAX_VALUE : base + (long)i * step - 1L;
        long[] range = new long[]{min, max};
        return range;
    }

    @Override
    long[] getBucketRange(int i, int len) {
        return this.getBucketRange(i, len, this.base, this.step);
    }

    public long getBase() {
        return this.base;
    }

    public long getStep() {
        return this.step;
    }

    @Override
    public Number getValue() {
        Distribution.Bucket bucket;
        double total = 0.0;
        List<Distribution.Bucket> buckets = this.getBuckets();
        int len = buckets.size();
        if (len > 0) {
            bucket = buckets.get(0);
            total = (double)bucket.getFrequency() * (double)(this.getBase() - 1L);
        }
        for (int i = 1; i < len - 1; ++i) {
            bucket = buckets.get(i);
            total += (double)bucket.getFrequency() * (double)bucket.getMin();
        }
        if (len > 1) {
            bucket = buckets.get(len - 1);
            total += (double)bucket.getFrequency() * (double)(bucket.getMin() + 1L);
        }
        return new Double(total);
    }

    private long getZeroBucketValue() {
        for (Distribution.Bucket b : this) {
            if (b.getMin() != 0L) continue;
            return b.getFrequency();
        }
        return 0L;
    }

    @Override
    public int compareTo(LinearDistribution d) {
        int cmp;
        double d2;
        Number v1 = this.getValue();
        Number v2 = d.getValue();
        double d1 = v1.doubleValue();
        int n = d1 < (d2 = v2.doubleValue()) ? -1 : (cmp = d1 > d2 ? 1 : 0);
        if (cmp == 0) {
            long z2;
            long z1 = this.getZeroBucketValue();
            cmp = z1 < (z2 = d.getZeroBucketValue()) ? -1 : (z1 > z2 ? 1 : 0);
        }
        return cmp;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
        if (this.step < 1L) {
            throw new InvalidObjectException("step is less than one");
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(LinearDistribution.class.toString());
        buf.append("[base = ");
        buf.append(this.getBase());
        buf.append(", step = ");
        buf.append(this.getStep());
        buf.append(", buckets = ");
        List<Distribution.Bucket> list = this.getDisplayRange();
        if (list.isEmpty()) {
            buf.append("<empty>");
        } else {
            buf.append(Arrays.toString(this.getDisplayRange().toArray()));
        }
        buf.append(", total = ");
        buf.append(this.getTotal());
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(LinearDistribution.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"base", "step", "buckets"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

