/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.SymbolValueRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserSymbolRecord
implements SymbolValueRecord,
Serializable,
Comparable<UserSymbolRecord> {
    static final long serialVersionUID = -591954442654439794L;
    private transient Value value;
    private transient String symbol;

    private UserSymbolRecord(int pid, long addressValue) {
        this.value = new Value(pid, addressValue);
    }

    public UserSymbolRecord(int pid, String lookupValue, long addressValue) {
        this.value = new Value(pid, addressValue);
        this.symbol = lookupValue;
        this.validate();
    }

    private void validate() {
        if (this.symbol == null) {
            throw new NullPointerException("symbol is null");
        }
    }

    public int getProcessID() {
        return this.value.getProcessID();
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    void setSymbol(String lookupValue) {
        this.symbol = lookupValue;
        this.validate();
    }

    @Override
    public long getAddress() {
        return this.value.getAddress();
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof UserSymbolRecord) {
            UserSymbolRecord r = (UserSymbolRecord)o;
            return this.value.equals(r.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(UserSymbolRecord r) {
        return this.value.compareTo(r.value);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.getProcessID());
        s.writeObject(this.getSymbol());
        s.writeLong(this.getAddress());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int pid = s.readInt();
        this.symbol = (String)s.readObject();
        long addressValue = s.readLong();
        try {
            this.value = new Value(pid, addressValue);
            this.validate();
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String toString() {
        return this.symbol;
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(UserSymbolRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"processID", "symbol", "address"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Value
    implements Serializable,
    Comparable<Value> {
        static final long serialVersionUID = -91449037747641135L;
        private final int processID;
        private final long address;

        public Value(int pid, long addressValue) {
            this.processID = pid;
            this.address = addressValue;
            this.validate();
        }

        private void validate() {
            if (this.processID < 0) {
                throw new IllegalArgumentException("process ID is negative");
            }
        }

        public int getProcessID() {
            return this.processID;
        }

        public long getAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (o instanceof Value) {
                Value v = (Value)o;
                return this.processID == v.processID && this.address == v.address;
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = 37 * hash + this.processID;
            hash = 37 * hash + (int)(this.address ^ this.address >>> 32);
            return hash;
        }

        @Override
        public int compareTo(Value v) {
            int cmp;
            int n = this.processID < v.processID ? -1 : (cmp = this.processID > v.processID ? 1 : 0);
            if (cmp == 0) {
                cmp = ProbeData.compareUnsigned(this.address, v.address);
            }
            return cmp;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            try {
                this.validate();
            }
            catch (Exception e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(Value.class.getName());
            buf.append("[processID = ");
            buf.append(this.processID);
            buf.append(", address = ");
            buf.append(this.address);
            buf.append(']');
            return buf.toString();
        }

        static {
            try {
                BeanInfo info = Introspector.getBeanInfo(Value.class);
                DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"processID", "address"}){

                    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                        return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                    }
                };
                BeanDescriptor d = info.getBeanDescriptor();
                d.setValue("persistenceDelegate", persistenceDelegate);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
    }
}

