/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"@(#)TestAPI.java	1.1	07/02/02 SMI"
 */

import org.opensolaris.os.dtrace.*;
import java.io.File;

public class TestAPI {
    public static void
    main(String[] args)
    {
	if (args.length < 1) {
	    System.err.println("Usage: java TestAPI <script> [ macroargs... ]");
	    System.exit(2);
	}

	File file = new File(args[0]);
	String[] macroArgs = new String[args.length - 1];
	System.arraycopy(args, 1, macroArgs, 0, (args.length - 1));

	Consumer consumer = new LocalConsumer();
	consumer.addConsumerListener(new ConsumerAdapter() {
	    public void dataReceived(DataEvent e) {
		System.out.println(e.getProbeData());
	    }
	});

	try {
	    consumer.open();
	    consumer.compile(file, macroArgs);
	    consumer.enable();
	    consumer.go();
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}
    }
}
