/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 *
 * ident	"@(#)TestTarget.java	1.1	07/02/02 SMI"
 */

import org.opensolaris.os.dtrace.*;
import java.io.File;

public class TestTarget {
    public static void
    main(String[] args)
    {
	if (args.length != 2) {
	    System.err.println("Usage: java TestTarget <script> <command>");
	    System.exit(2);
	}

	File file = new File(args[0]);
	String command = args[1];

	final Consumer consumer = new LocalConsumer();
	consumer.addConsumerListener(new ConsumerAdapter() {
	    public void dataReceived(DataEvent e) {
		System.out.println(e.getProbeData());
	    }
	    public void consumerStopped(ConsumerEvent e) {
		try {
		    Aggregate a = consumer.getAggregate();
		    for (Aggregation agg : a.asMap().values()) {
			for (AggregationRecord rec : agg.asMap().values()) {
			    System.out.println(rec.getTuple() + " " +
				    rec.getValue());
			}
		    }
		} catch (Exception x) {
		    x.printStackTrace();
		    System.exit(1);
		}
		consumer.close();
	    }
	    public void processStateChanged(ProcessEvent e) {
		System.out.println(e.getProcessState());
	    }
	});

	try {
	    consumer.open();
	    // pid replaces $target variable in D script
	    consumer.createProcess(command);
	    consumer.compile(file);
	    consumer.enable();
	    consumer.go();
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}
    }
}
