/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_PATTR_H
#define	_SYS_PATTR_H

#pragma ident	"@(#)pattr.h	1.5	07/03/05 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Attribute types and structures.
 */
#define	PATTR_DSTADDRSAP	0x1	/* destination physical address+SAP */
#define	PATTR_SRCADDRSAP	0x2	/* source physical address+SAP */
#define	PATTR_HCKSUM		0x3	/* hardware checksum attribute */
#define	PATTR_ZCOPY		0x4	/* zerocopy attribute */

/*
 * Structure shared by {source,destination} physical address+SAP attributes.
 */
typedef struct pattr_addr_s {
	uint8_t	addr_is_group;	/* address is broadcast or multicast */
	uint8_t	addr_len;	/* length of address */
	uint8_t	addr[1];	/* address */
} pattr_addr_t;

/*
 * Structure used for Hardware Checksum attribute.
 */

typedef struct pattr_hcksum_s {
	uint32_t	hcksum_start_offset;
	uint32_t	hcksum_stuff_offset;
	uint32_t	hcksum_end_offset;
	union {
		uint64_t value;
		uint16_t inet_cksum; /* to store H/W computed cksum value */
	} hcksum_cksum_val;
	uint32_t	hcksum_flags;
} pattr_hcksum_t;

/*
 * Values for hcksum_flags
 */
#define	HCK_IPV4_HDRCKSUM	0x01	/* On Transmit: Compute IP header */
					/* checksum in hardware. */
					/* On Receive: IP header checksum */
					/* was verified by h/w and is */
					/* correct. */
#define	HCK_PARTIALCKSUM	0x02	/* On Transmit: Compute partial 1's */
					/* complement checksum based on */
					/* start, stuff and end offsets. */
					/* On Receive : Partial checksum */
					/* computed and attached. */
#define	HCK_FULLCKSUM		0x04	/* On Transmit: Compute full(in case */
					/* of TCP/UDP, full is pseudo-header */
					/* + header + payload) checksum for */
					/* this packet. */
					/* On Receive : Full checksum  */
					/* computed in h/w and is attached */
#define	HCK_FULLCKSUM_OK	0x08	/* On Transmit: N/A */
					/* On Receive: Full checksum status */
					/* If set, implies full checksum */
					/* computation was successful */
					/* i.e. checksum was correct. */
					/* If it is not set, IP will also */
					/* check the attached h/w computed */
					/* checksum value to determine if */
					/* checksum was bad */
/*
 * Extended hardware offloading flags that also use hcksum_flags
 */
#define	HW_LSO			0x10	/* On Transmit: hardware does LSO */
					/* On Receive: N/A */

/*
 * Structure used for zerocopy attribute.
 */
typedef struct pattr_zcopy_s {
	uint_t zcopy_flags;
} pattr_zcopy_t;

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_PATTR_H */
