/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DurationHelper
extends Dialog {
    private boolean save;
    private Frame parent;
    private Choice unit;
    private TextField value;
    private Label total;
    private Button ok;
    private Button cancel;
    private Button help;
    private Button compute;
    private HelpDialog hd = null;
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static ResourceBundle hrb = ResourceBundle.getBundle("HelpData");
    private static String[] units = new String[]{DurationHelper.getString("Seconds"), DurationHelper.getString("Minutes"), DurationHelper.getString("Hours"), DurationHelper.getString("Days"), DurationHelper.getString("Weeks"), DurationHelper.getString("Months"), DurationHelper.getString("Years")};
    private static int[] unitMultipliers = new int[]{1, 60, 3600, 86400, 604800, 2592000, 31536000};
    private static NumberFormat nf = NumberFormat.getInstance();
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();

    public DurationHelper(Frame frame, Color color, Color color2) {
        super(frame, DurationHelper.getString("SEAM Duration Helper"), true);
        this.parent = frame;
        this.setLayout(new GridBagLayout());
        this.addLabels();
        this.addFields(color, color2);
        this.addButtons();
        this.setSize(350, 150);
        this.setResizable(false);
        this.addWindowListener(new DHWindowListener());
    }

    private void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new Label(DurationHelper.getString("Unit")), gridBagConstraints);
        this.add((Component)new Label(DurationHelper.getString("Value")), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)new Label(DurationHelper.getString("Seconds")), gridBagConstraints);
    }

    private void initUnits() {
        this.unit = new Choice();
        for (int i = 0; i < units.length; ++i) {
            this.unit.add(units[i]);
        }
        this.unit.select(DurationHelper.getString("Hours"));
        this.unit.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DurationHelper.this.checkErrorAndSetTotal();
            }
        });
    }

    private void addFields(Color color, Color color2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.initUnits();
        this.value = new TextField();
        this.value.setBackground(color);
        this.value.setForeground(color2);
        this.value.setColumns(10);
        this.total = new Label("             ", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.unit, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.value, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.add((Component)this.total, gridBagConstraints);
        this.value.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DurationHelper.this.durationHelperClose(true);
            }
        });
    }

    private void addButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)new LineSeparator(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        this.ok = new Button(DurationHelper.getString("OK"));
        this.cancel = new Button(DurationHelper.getString("Cancel"));
        this.help = new Button(DurationHelper.getString("Help"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.ok, gridBagConstraints);
        panel.add((Component)this.cancel, gridBagConstraints);
        panel.add((Component)this.help, gridBagConstraints);
        ButtonListener buttonListener = new ButtonListener();
        this.ok.addActionListener(buttonListener);
        this.cancel.addActionListener(buttonListener);
        this.help.addActionListener(buttonListener);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)panel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.compute = new Button(DurationHelper.getString("="));
        this.add((Component)this.compute, gridBagConstraints);
        this.compute.addActionListener(buttonListener);
    }

    private boolean checkErrorAndSetTotal() {
        try {
            String string = this.value.getText().trim();
            this.value.setText(string);
            Long l = Long.valueOf(string);
            this.total.setText(nf.format(l * (long)unitMultipliers[this.unit.getSelectedIndex()]));
        }
        catch (NumberFormatException numberFormatException) {
            this.value.requestFocus();
            this.value.selectAll();
            toolkit.beep();
            return false;
        }
        return true;
    }

    private void durationHelperClose(boolean bl) {
        if (bl && !this.checkErrorAndSetTotal()) {
            return;
        }
        this.save = bl;
        this.setVisible(false);
    }

    public boolean isSaved() {
        return this.save;
    }

    public String toString() {
        return this.total.getText();
    }

    private static final String getString(String string) {
        return DurationHelper.getString(rb, string);
    }

    private static final String getString(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DurationHelper.this.ok) {
                DurationHelper.this.durationHelperClose(true);
            } else if (actionEvent.getSource() == DurationHelper.this.cancel) {
                DurationHelper.this.durationHelperClose(false);
            } else if (actionEvent.getSource() == DurationHelper.this.help) {
                if (DurationHelper.this.hd != null) {
                    DurationHelper.this.hd.show();
                } else {
                    DurationHelper.this.hd = new HelpDialog(DurationHelper.this.parent, DurationHelper.getString("Help for entering time duration"), false, 5, 45);
                    DurationHelper.this.hd.setVisible(true);
                    DurationHelper.this.hd.setText(DurationHelper.getString(hrb, "DurationHelperHelp"));
                }
            } else if (actionEvent.getSource() == DurationHelper.this.compute) {
                DurationHelper.this.checkErrorAndSetTotal();
            }
        }
    }

    private class DHWindowListener
    extends WindowAdapter {
        private DHWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DurationHelper.this.durationHelperClose(false);
        }
    }
}

