/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;

public class LabelBar
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final int barAndLabelPad = 2;
    private static final int barAndEdgePad = 1;
    private static final int barThickness = 2;
    private int alignment = 0;
    private int labelOffsetFromEdge = 10;
    private String label;

    public LabelBar() {
        this.label = null;
    }

    public LabelBar(String string) {
        this.label = string;
    }

    public void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabelOffsetFromEdge(int n) {
        if (n != this.labelOffsetFromEdge) {
            this.labelOffsetFromEdge = n;
            this.repaint();
        }
    }

    public int getLabelOffsetFromEdge() {
        return this.labelOffsetFromEdge;
    }

    public void setAlignment(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                this.repaint();
                break;
            }
            default: {
                throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.ImageLabel.ImproperAlignment"));
            }
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        Font font = this.getFont();
        if (this.label != null && this.label.length() > 0 && font != null) {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            return new Dimension(fontMetrics.stringWidth(this.label) + this.labelOffsetFromEdge * 2, fontMetrics.getHeight());
        }
        return new Dimension(this.labelOffsetFromEdge * 2, 6);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void disable() {
        super.disable();
        this.repaint();
    }

    public void enable() {
        super.enable();
        this.repaint();
    }

    private void checkerStipple(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                if (i % 2 != j % 2) continue;
                graphics.drawLine(j, i, j, i);
            }
        }
        graphics.setColor(color2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        Object object = DesignerAccess.mutex;
        synchronized (object) {
            super.paint(graphics);
            int n = this.size().height / 2 - 1;
            if (this.label != null && this.label.length() > 0) {
                int n2;
                Font font = this.getFont();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n3 = fontMetrics.stringWidth(this.label);
                switch (this.alignment) {
                    case 0: {
                        n2 = this.labelOffsetFromEdge;
                        break;
                    }
                    case 1: {
                        n2 = (this.size().width - n3) / 2;
                        break;
                    }
                    case 2: {
                        n2 = this.size().width - (this.labelOffsetFromEdge + n3);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(Global.getMsg("sunsoft.jws.visual.rt.awt.ImageLabel.ImproperAlignment"));
                    }
                }
                graphics.setColor(this.getForeground());
                graphics.setFont(this.getFont());
                graphics.drawString(this.label, n2, this.size().height - ((this.size().height - fontMetrics.getHeight()) / 2 + fontMetrics.getMaxDescent() + 1));
                int n4 = 1;
                int n5 = n2 - (2 + n4);
                int n6 = n2 + (n3 + 2);
                int n7 = this.size().width - (n6 + 1);
                graphics.setColor(this.getBackground());
                if (n5 > 0) {
                    graphics.fill3DRect(n4, n, n5, 2, false);
                }
                if (n7 > 0) {
                    graphics.fill3DRect(n6, n, n7, 2, false);
                }
            } else {
                int n8 = 1;
                int n9 = this.size().width - 2;
                graphics.setColor(this.getBackground());
                graphics.fill3DRect(n8, n, n9, 2, false);
            }
            if (!this.isEnabled()) {
                this.checkerStipple(graphics, this.getBackground(), 0, 0, this.size().width, this.size().height);
            }
        }
    }
}

