/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import sunsoft.jws.visual.rt.awt.GBLayout;
import sunsoft.jws.visual.rt.awt.RWHelper;
import sunsoft.jws.visual.rt.awt.RootWindow;
import sunsoft.jws.visual.rt.awt.VJPanel;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Message;

public class RootFrame
extends Frame
implements RootWindow {
    private Point location = new Point(0, 0);
    private boolean skipValidate = false;
    private boolean ignoreShow = false;
    private boolean ignoreHide = false;
    private RWHelper helper;
    private Group subGroup;

    public RootFrame() {
        this.initHelper();
    }

    public RootFrame(String string) {
        super(string);
        this.initHelper();
    }

    private void initHelper() {
        Class clazz = DesignerAccess.getRootWindowHelperClass();
        if (clazz != null) {
            try {
                this.helper = (RWHelper)clazz.newInstance();
                this.helper.setWindow(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setSubGroup(Group group) {
        this.subGroup = group;
    }

    public Group getSubGroup() {
        return this.subGroup;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component.getParent() != this) {
            super.addImpl(component, object, n);
        }
    }

    public Point location() {
        if (Global.isMotif()) {
            return new Point(this.location.x, this.location.y);
        }
        return super.location();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.location = new Point(n, n2);
    }

    public boolean postEvent(Event event) {
        if (event.id == 203) {
            this.ignoreHide = true;
        } else if (event.id == 204) {
            this.ignoreShow = true;
        }
        boolean bl = VJPanel.markEvent(event, this);
        boolean bl2 = super.postEvent(event);
        if (bl) {
            VJPanel.forwardEvent(event, this);
        }
        if (event.id == 203) {
            this.ignoreHide = false;
        } else if (event.id == 204) {
            this.ignoreShow = false;
        }
        return bl2;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            if (this.subGroup != null) {
                this.subGroup.postMessage(new Message(DesignerAccess.getContainer(this.subGroup), "AWT", event, true));
                return true;
            }
        } else if (event.target == this && event.id == 205 && event.x != 0 && event.y != 0) {
            this.location = new Point(event.x, event.y);
        }
        return super.handleEvent(event);
    }

    public void select() {
        if (this.helper != null) {
            this.helper.select();
        }
    }

    public void unselect() {
        if (this.helper != null) {
            this.helper.unselect();
        }
    }

    public void layoutMode() {
        if (this.helper != null) {
            this.helper.layoutMode();
        }
    }

    public void previewMode() {
        if (this.helper != null) {
            this.helper.previewMode();
        }
    }

    public Dimension previewSize() {
        if (this.helper != null) {
            return this.helper.previewSize();
        }
        return null;
    }

    public void addNotify() {
        if (this.helper != null) {
            this.helper.addNotify();
        }
        super.addNotify();
    }

    public void removeNotify() {
        if (this.helper != null) {
            this.helper.removeNotify();
        }
        super.removeNotify();
    }

    public void layout() {
        if (this.helper != null) {
            this.helper.layout();
        }
        super.layout();
    }

    public void paint(Graphics graphics) {
        if (Global.isWindows()) {
            graphics = this.getGraphics();
        }
        if (this.helper != null) {
            this.helper.paint(graphics);
        }
        super.paint(graphics);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.helper != null) {
            return this.helper.mouseDown(event, n, n2);
        }
        return false;
    }

    public void show() {
        if (this.ignoreShow) {
            return;
        }
        if (this.isShowing()) {
            if (!Global.isWindows()) {
                this.toFront();
            }
            return;
        }
        this.skipValidate = true;
        super.show();
        this.skipValidate = false;
    }

    public void hide() {
        if (!this.ignoreHide) {
            super.hide();
        }
    }

    public void validate() {
        if (!this.skipValidate) {
            super.validate();
        }
    }

    public Insets insets() {
        Insets insets = (Insets)super.insets().clone();
        if (Global.isWindows() && this.getMenuBar() != null && insets.top < 30) {
            insets.top += 30;
        }
        return insets;
    }

    static {
        if (Global.isWindows95()) {
            GBLayout.setWindowInsets(new Insets(1, 1, 1, 1));
        } else if (Global.isWindowsNT()) {
            GBLayout.setWindowInsets(new Insets(2, 3, 2, 3));
        } else {
            GBLayout.setWindowInsets(new Insets(4, 4, 4, 4));
        }
    }
}

