/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.base;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import sunsoft.jws.visual.rt.base.CustomClassLoader;
import sunsoft.jws.visual.rt.base.DesignerAccess;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.QSortCompare;
import sunsoft.jws.visual.rt.base.TransFilter;
import sunsoft.jws.visual.rt.base.VBClassLoader;

public class Util {
    public static final int RELIEF_FLAT = 0;
    public static final int RELIEF_RAISED = 1;
    public static final int RELIEF_SUNKEN = 2;
    public static final int RELIEF_RIDGE = 3;
    public static final int RELIEF_GROOVE = 4;
    public static final int WIN95_RAISED = 6;
    public static final int WIN95_SUNKEN = 7;
    public static final int WIN95_FIELD_BORDER = 8;
    public static final int WIN95_WINDOW_BORDER = 9;
    public static final int BLACK_BORDER = 10;
    public static final char BACKSLASH = '\\';
    public static final char COLON = ':';
    public static final char NEWLINE = '\n';
    public static final char RETURN = '\r';
    public static final char SLASH = '/';
    public static final char SPACE = ' ';
    private String codebaseStr = null;
    private CustomClassLoader classLoader = new VBClassLoader();
    private static final double BFACTOR = 0.82;
    private static final double DFACTOR = 0.7;
    private static final int BUFSIZE = 2048;
    private static String separator;
    private static String cwd;

    public Color brighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = Math.min((int)((double)n * 1.2195121951219512), 255);
        n2 = Math.min((int)((double)n2 * 1.2195121951219512), 255);
        n3 = Math.min((int)((double)n3 * 1.2195121951219512), 255);
        if (n > 250 && n2 > 250 && n3 > 250) {
            return new Color(225, 225, 225);
        }
        return new Color(n, n2, n3);
    }

    public Color darker(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        n = n == 255 ? 128 : Math.max((int)((double)n * 0.7), 0);
        n2 = n2 == 255 ? 128 : Math.max((int)((double)n2 * 0.7), 0);
        n3 = n3 == 255 ? 128 : Math.max((int)((double)n3 * 0.7), 0);
        return new Color(n, n2, n3);
    }

    public void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n6 + 1) / 2;
        for (int i = 0; i < n6; ++i) {
            this.draw3DRect(graphics, n + i, n2 + i, n3 - 2 * i, n4 - 2 * i, n5, i < n7);
        }
    }

    private void draw3DRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Color color = graphics.getColor();
        graphics.setColor(this.getEdgeColor(color, n5, true, bl));
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.setColor(this.getEdgeColor(color, n5, false, bl));
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics.setColor(color);
    }

    private Color getEdgeColor(Color color, int n, boolean bl, boolean bl2) {
        Color color2 = null;
        switch (n) {
            case 1: {
                if (bl) {
                    color2 = this.brighter(color);
                    break;
                }
                color2 = this.darker(color);
                break;
            }
            case 2: {
                if (bl) {
                    color2 = this.darker(color);
                    break;
                }
                color2 = this.brighter(color);
                break;
            }
            case 3: {
                if (bl) {
                    if (bl2) {
                        color2 = this.brighter(color);
                        break;
                    }
                    color2 = this.darker(color);
                    break;
                }
                if (bl2) {
                    color2 = this.darker(color);
                    break;
                }
                color2 = this.brighter(color);
                break;
            }
            case 4: {
                if (bl) {
                    if (bl2) {
                        color2 = this.darker(color);
                        break;
                    }
                    color2 = this.brighter(color);
                    break;
                }
                if (bl2) {
                    color2 = this.brighter(color);
                    break;
                }
                color2 = this.darker(color);
                break;
            }
            case 6: {
                if (bl) {
                    if (bl2) {
                        color2 = Color.white;
                        break;
                    }
                    color2 = this.brighter(color);
                    break;
                }
                if (bl2) {
                    color2 = Color.black;
                    break;
                }
                color2 = this.darker(color);
                break;
            }
            case 7: {
                if (bl) {
                    if (bl2) {
                        color2 = Color.black;
                        break;
                    }
                    color2 = this.darker(color);
                    break;
                }
                if (bl2) {
                    color2 = Color.white;
                    break;
                }
                color2 = this.brighter(color);
                break;
            }
            case 8: {
                if (bl) {
                    if (bl2) {
                        color2 = this.darker(color);
                        break;
                    }
                    color2 = Color.black;
                    break;
                }
                if (bl2) {
                    color2 = Color.white;
                    break;
                }
                color2 = this.brighter(color);
                break;
            }
            case 9: {
                if (bl) {
                    if (bl2) {
                        color2 = this.brighter(color);
                        break;
                    }
                    color2 = Color.white;
                    break;
                }
                if (bl2) {
                    color2 = Color.black;
                    break;
                }
                color2 = this.darker(color);
                break;
            }
            case 10: {
                color2 = Color.black;
                break;
            }
            default: {
                color2 = color;
            }
        }
        return color2;
    }

    public Image getWorkaroundImage(URL uRL, Component component) {
        Image image = component.getToolkit().getImage(uRL);
        return this.getWorkaroundImage(image, component);
    }

    public Image getWorkaroundImage(Image image, Component component) {
        if (image == null) {
            return null;
        }
        if (Global.isWindows95() && Global.javaVersion() == 1.0) {
            TransFilter transFilter = new TransFilter(component);
            image = component.createImage(new FilteredImageSource(image.getSource(), transFilter));
        }
        return image;
    }

    public boolean setUserCodebase(String string) {
        this.codebaseStr = string;
        return true;
    }

    public CustomClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(CustomClassLoader customClassLoader) {
        this.classLoader = customClassLoader;
    }

    public URL pathToURL(String string, Applet applet) {
        String string2;
        String string3;
        if (Global.isWindows()) {
            string3 = ";";
            string2 = "file:/";
        } else {
            string3 = ":";
            string2 = "file:";
        }
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            Object object;
            Object object2;
            String string4;
            if (applet != null && !applet.getClass().getName().startsWith("sun.jws")) {
                URL uRL;
                String string5 = applet.getCodeBase().toExternalForm();
                if (string5.charAt(string5.length() - 1) != '/') {
                    string = "/" + string;
                }
                try {
                    uRL = new URL(applet.getCodeBase(), string);
                }
                catch (MalformedURLException malformedURLException2) {
                    uRL = null;
                }
                return uRL;
            }
            try {
                string4 = System.getProperty("java.class.path");
            }
            catch (SecurityException securityException) {
                throw new Error(Global.fmtMsg("sunsoft.jws.visual.rt.base.Util.NeedAppletparam", Global.newline()));
            }
            string4 = DesignerAccess.getCWD() + string3 + string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string4, string3);
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens() && bl) {
                char c;
                object2 = stringTokenizer.nextToken();
                if (object2 == "") {
                    object2 = ".";
                }
                if ((c = ((String)(object2 = this.makeAbsolute((String)object2))).charAt(((String)object2).length() - 1)) != '/' && c != '\\') {
                    object2 = (String)object2 + separator;
                }
                object2 = (String)object2 + string;
                if (Global.isWindows()) {
                    object = ((String)object2).toCharArray();
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (object[i] != 47) continue;
                        object[i] = 92;
                    }
                    object2 = new String((char[])object);
                }
                if (!((File)(object = new File((String)object2))).exists()) continue;
                try {
                    URL uRL = new URL(string2 + (String)object2);
                    return uRL;
                }
                catch (MalformedURLException malformedURLException3) {
                    bl = false;
                }
            }
            if (this.codebaseStr != null) {
                String string6 = !this.codebaseStr.endsWith("/") && !this.codebaseStr.endsWith(File.separator) ? this.codebaseStr + "/" + string : this.codebaseStr + string;
                object = new File(string6);
                if (((File)object).exists()) {
                    string6 = string2 + string6;
                }
                try {
                    object2 = new URL(string6);
                    return object2;
                }
                catch (MalformedURLException malformedURLException4) {
                    object2 = null;
                }
            }
            return null;
        }
    }

    private String makeAbsolute(String string) {
        if (separator == null) {
            separator = System.getProperty("file.separator");
        }
        if (cwd == null && (cwd = System.getProperty("user.dir")).charAt(cwd.length() - 1) != separator.charAt(0)) {
            cwd = cwd + separator;
        }
        if (Global.isWindows()) {
            if (string.length() < 3 || string.charAt(1) != ':' || string.charAt(2) != '/' && string.charAt(2) != '\\') {
                string = cwd + string;
            }
        } else if (string.charAt(0) != '/') {
            string = cwd + string;
        }
        return string;
    }

    public boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public void qsort(String[] stringArray) {
        this.quicksort(stringArray, 0, stringArray.length - 1);
    }

    private void quicksort(String[] stringArray, int n, int n2) {
        if (n < n2) {
            int n3 = this.partition(stringArray, n, n2);
            if (n3 == n2) {
                --n3;
            }
            this.quicksort(stringArray, n, n3);
            this.quicksort(stringArray, n3 + 1, n2);
        }
    }

    private int partition(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (stringArray[n4].compareTo(string) >= 0 && n3 < n4) {
                --n4;
                continue;
            }
            while (stringArray[n3].compareTo(string) < 0 && n3 < n4) {
                ++n3;
            }
            if (n3 >= n4) break;
            String string2 = stringArray[n3];
            stringArray[n3] = stringArray[n4];
            stringArray[n4] = string2;
        }
        return n4;
    }

    public void qsort(Object[] objectArray, QSortCompare qSortCompare) {
        if (objectArray != null) {
            this.quicksort(objectArray, 0, objectArray.length - 1, qSortCompare);
        }
    }

    private void quicksort(Object[] objectArray, int n, int n2, QSortCompare qSortCompare) {
        if (n < n2) {
            int n3 = this.partition(objectArray, n, n2, qSortCompare);
            if (n3 == n2) {
                --n3;
            }
            this.quicksort(objectArray, n, n3, qSortCompare);
            this.quicksort(objectArray, n3 + 1, n2, qSortCompare);
        }
    }

    private int partition(Object[] objectArray, int n, int n2, QSortCompare qSortCompare) {
        Object object = objectArray[n];
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (qSortCompare.qsortCompare(objectArray[n4], object) >= 0 && n3 < n4) {
                --n4;
                continue;
            }
            while (qSortCompare.qsortCompare(objectArray[n3], object) < 0 && n3 < n4) {
                ++n3;
            }
            if (n3 >= n4) break;
            Object object2 = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object2;
        }
        return n4;
    }

    public static void pack(Window window) {
        window.pack();
        if (Global.isWindows95() || Global.isWindowsNT()) {
            Thread.yield();
            window.pack();
        }
    }
}

