/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.shadow;

import java.awt.SystemColor;
import sunsoft.jws.visual.rt.awt.StringVector;
import sunsoft.jws.visual.rt.awt.TextList;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.shadow.java.awt.CanvasShadow;

public class TextListShadow
extends CanvasShadow {
    public TextListShadow() {
        this.attributes.add("allowMultipleSelections", "java.lang.Boolean", Boolean.FALSE, 0);
        String[] stringArray = new String[]{"item1", "item2"};
        this.attributes.add("items", "[Ljava.lang.String;", stringArray, 0);
        this.attributes.add("selectedItem", "java.lang.String", null, 2);
        this.attributes.add("selectedItems", "[Ljava.lang.String;", null, 2);
        this.attributes.add("visibleRows", "java.lang.Integer", new Integer(10), 0);
        if (Global.isWindows()) {
            this.attributes.add("background", "java.awt.Color", SystemColor.window, 32);
        }
        if (Global.isMotif()) {
            this.attributes.add("background", "java.awt.Color", SystemColor.text, 32);
            this.attributes.add("foreground", "java.awt.Color", SystemColor.textText, 32);
        }
    }

    protected Object getOnBody(String string) {
        TextList textList = (TextList)this.body;
        if (string.equals("allowMultipleSelections")) {
            return new Boolean(textList.allowsMultipleSelections());
        }
        if (string.equals("items")) {
            return this.getFromTable("items");
        }
        if (string.equals("visibleRows")) {
            return new Integer(textList.getMinimumRows());
        }
        if (string.equals("selectedItem")) {
            return textList.getSelectedItem();
        }
        if (string.equals("selectedItems")) {
            return textList.getSelectedItems();
        }
        return super.getOnBody(string);
    }

    protected void setOnBody(String string, Object object) {
        TextList textList = (TextList)this.body;
        if (string.equals("allowMultipleSelections")) {
            textList.setMultipleSelections((Boolean)object);
        } else if (string.equals("items")) {
            String[] stringArray = (String[])object;
            StringVector stringVector = textList.items();
            stringVector.removeAllElements();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringVector.addElement(stringArray[i]);
                }
            }
            textList.updateView();
        } else if (string.equals("visibleRows")) {
            textList.setMinimumRows((Integer)object);
        } else if (string.equals("selectedItem")) {
            int n = -1;
            if (object != null) {
                n = textList.items().indexOf((String)object);
            }
            textList.select(n);
        } else if (string.equals("selectedItems")) {
            String[] stringArray = (String[])object;
            if (textList.allowsMultipleSelections()) {
                textList.deselectAll();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        textList.select(stringArray[i]);
                    }
                }
            } else if (stringArray != null && stringArray.length != 0) {
                textList.select(stringArray[0]);
            } else {
                textList.select(null);
            }
        } else {
            super.setOnBody(string, object);
        }
    }

    public void createBody() {
        this.body = new TextList();
    }
}

