/*
 * Decompiled with CFR 0.152.
 */
package sunsoft.jws.visual.rt.type;

import java.util.Enumeration;
import java.util.Vector;
import sunsoft.jws.visual.rt.awt.VJErrorDialog;
import sunsoft.jws.visual.rt.base.AMContainer;
import sunsoft.jws.visual.rt.base.AttributeManager;
import sunsoft.jws.visual.rt.base.Global;
import sunsoft.jws.visual.rt.base.Group;
import sunsoft.jws.visual.rt.base.Message;
import sunsoft.jws.visual.rt.base.VJException;
import sunsoft.jws.visual.rt.type.ApplyException;

public abstract class TypeEditor
extends Group {
    protected boolean hasChanges = false;
    private Object resetValue;
    private String disabledTitle = "<no value>";
    private boolean resetValueChanged;
    private Vector children = new Vector();
    private boolean applying = false;
    private VJErrorDialog errorDialog;
    private boolean isEnabled = true;
    private TypeEditor parentEditor;

    public TypeEditor() {
        this.attributes.add("enabled", "java.lang.Boolean", Boolean.TRUE, 16);
    }

    public Object get(String string) {
        if (string.equals("enabled")) {
            return new Boolean(this.isEnabled);
        }
        return super.get(string);
    }

    public void set(String string, Object object) {
        if (string.equals("enabled")) {
            this.enable((Boolean)object);
        } else {
            super.set(string, object);
        }
    }

    protected abstract Object getApplyValue() throws ApplyException;

    protected void childApply(TypeEditor typeEditor, Object object) {
    }

    protected abstract void resetFromValue(Object var1);

    protected boolean shouldEnableChild(TypeEditor typeEditor, Object object) {
        return true;
    }

    protected void resetChildFromValue(TypeEditor typeEditor, Object object) {
        typeEditor.setValue(null);
    }

    protected abstract void enableEditor(Boolean var1);

    protected String getTitle(String string, String string2) {
        if (string == null && string2 == null) {
            return this.disabledTitle;
        }
        return string + " " + string2;
    }

    public void setTitle(String string, String string2) {
        if (this.hasAttribute("title")) {
            this.set("title", this.getTitle(string, string2));
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TypeEditor typeEditor = (TypeEditor)enumeration.nextElement();
            typeEditor.setTitle(string, string2);
        }
    }

    public String editorButtonName() {
        return null;
    }

    protected void showGroup() {
        this.enable(this.isEnabled);
        if (this.resetValueChanged) {
            this.reset();
        }
    }

    protected void hideGroup() {
        this.resetValueChanged = false;
    }

    public void setParentEditor(TypeEditor typeEditor) {
        this.parentEditor = typeEditor;
    }

    public TypeEditor getParentEditor() {
        return this.parentEditor;
    }

    protected void addChildEditor(TypeEditor typeEditor) {
        for (TypeEditor typeEditor2 = typeEditor.getParentEditor(); typeEditor2 != null; typeEditor2 = typeEditor2.getParentEditor()) {
            if (typeEditor2 != typeEditor) continue;
            throw new VJException(Global.getMsg("sunsoft.jws.visual.rt.type.TypeEditor.AddChildError"));
        }
        if (typeEditor.getParentEditor() != null) {
            typeEditor.getParentEditor().removeChildEditor(typeEditor);
        }
        this.children.addElement(typeEditor);
        typeEditor.setParentEditor(this);
    }

    protected void removeChildEditor(TypeEditor typeEditor) {
        if (typeEditor.getParentEditor() != this) {
            return;
        }
        this.children.removeElement(typeEditor);
        typeEditor.setParentEditor(null);
    }

    protected Enumeration getChildEditorList() {
        return this.children.elements();
    }

    public boolean hasChanges() {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TypeEditor typeEditor = (TypeEditor)enumeration.nextElement();
            if (!typeEditor.hasChanges()) continue;
            return true;
        }
        return this.hasChanges;
    }

    private void clearChanges() {
        this.hasChanges = false;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TypeEditor typeEditor = (TypeEditor)enumeration.nextElement();
            typeEditor.clearChanges();
        }
    }

    public void setValue(Object object) {
        this.resetValue = object;
        this.resetValueChanged = true;
        this.reset();
    }

    public void setResetValue(Object object) {
        this.resetValue = object;
        this.resetValueChanged = true;
    }

    public Object getResetValue() {
        return this.resetValue;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean apply() {
        Object object;
        if (!this.isShowing()) {
            return true;
        }
        if (this.applying || !this.hasChanges()) {
            return true;
        }
        this.applying = true;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            object = (TypeEditor)enumeration.nextElement();
            if (((TypeEditor)object).apply()) continue;
            this.applying = false;
            return false;
        }
        try {
            object = this.getApplyValue();
        }
        catch (ApplyException applyException) {
            this.applying = false;
            this.showError(applyException.getMessage());
            return false;
        }
        this.resetValue = object;
        this.resetValueChanged = true;
        this.hasChanges = false;
        this.postMessageToParent(new Message(this, "Apply", object));
        this.applying = false;
        return true;
    }

    public void reset() {
        if (!this.isShowing()) {
            return;
        }
        this.hasChanges = false;
        this.resetFromValue(this.resetValue);
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            TypeEditor typeEditor = (TypeEditor)enumeration.nextElement();
            if (this.isEnabled && this.shouldEnableChild(typeEditor, this.resetValue)) {
                typeEditor.enable(true);
                this.resetChildFromValue(typeEditor, this.resetValue);
                continue;
            }
            typeEditor.enable(false);
            typeEditor.setValue(null);
        }
    }

    public void ok() {
        if (!this.isShowing()) {
            return;
        }
        if (this.apply()) {
            this.cancel();
        }
    }

    public void cancel() {
        if (!this.isShowing()) {
            return;
        }
        this.hide();
        this.clearChanges();
    }

    public void enable(boolean bl) {
        this.isEnabled = bl;
        if (!this.isShowing()) {
            return;
        }
        this.enableEditor(new Boolean(bl));
    }

    public boolean handleMessage(Message message) {
        if (!message.isAWT && message.name.equals("Apply")) {
            this.childApply((TypeEditor)message.target, message.arg);
            this.apply();
            return true;
        }
        return super.handleMessage(message);
    }

    protected void recurseEnable(AttributeManager attributeManager, Boolean bl) {
        if (attributeManager.hasAttribute("enabled")) {
            attributeManager.set("enabled", bl);
        }
        if (attributeManager instanceof AMContainer) {
            AMContainer aMContainer = (AMContainer)((Object)attributeManager);
            Enumeration enumeration = aMContainer.getChildList();
            while (enumeration.hasMoreElements()) {
                this.recurseEnable((AttributeManager)enumeration.nextElement(), bl);
            }
        }
    }

    protected void showError(String string) {
        if (this.errorDialog == null) {
            this.errorDialog = new VJErrorDialog(this.getFrame(), Global.getMsg("sunsoft.jws.visual.rt.type.TypeEditor.Error"), true);
        }
        this.errorDialog.setLabel(string);
        this.errorDialog.pack();
        this.errorDialog.show();
    }
}

