:
:        CDC 114 SYSTEM EXERCISER
:
: File - stageI.sh
:
: This is the control shell for Stage I testing.
:
: Input parameters are
:  1 Maxpass - maximum number of passes allowed.
:  2 hdexp   - hard disk expansion flag - y or n.
:  3 fdflag  - flexible disk test flag - y or n.
:  4 prflag  - serial printer flag - n or 1 or 2 or 3.
:  5 nterm   - number of terminals on this system.
:  6 srcport - sending serial i/o port number, or n.
:  7 dstport - receiving serial i/o port number, or n.
:  8 p1      - process id for sleep on sending port.
:  9 p2      - process id for sleep on receiving port.
: . . . . . . . . . . . . . . . . . . . .
:
: Check for debug mode.
:
if test -f dbmode
   then set -xv
fi
: . . . . . . . . . . . . . . . . . . . .
:
: Find out how many passes the operator wants to run.
:
echo
echo Stage I. Sequential tests.
echo How many passes do you want to run ?
    entry=bad
    until test $entry = good
      do
        echo Enter a number from 1 to $1,
        echo -n or depress [newline] or [return]
        echo -n " for an indefinite number of passes."
        read npass
        if test $npass
           then if test $npass -ge 1 -a $npass -le $1
                   then entry=good
                fi
           else { npass=$1
                  entry=good
                }
        fi
      done
: . . . . . . . . . . . . . . . . . . . .
:
: Find out if operator wants to halt on error,
: or continue without pause.
:
entry=bad
until test $entry = good
  do
    echo -n Do you want to halt on error? [y or n].
    read errf
    if test $errf
       then if test $errf = y -o $errf = n
               then entry=good
            fi
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
echo
echo To terminate Stage I testing at any time,
echo depress the DEL key.
: . . . . . . . . . . . . . . . . . . . .
:
: Set up the test loop so that the operator may interrupt
: testing by depressing the DEL key.
:
stopgo=go
trap 'stopgo=stop' 2
: . . . . . . . . . . . . . . . . . . . .
:
: Write initial entry to test log file.
:
echo -n System Exerciser Stage I.  .  .  >> sysck.log
date >> sysck.log
: . . . . . . . . . . . . . . . . . . . .
:
: Initialize pass number and error counters.
:
passn=1
nmemerr=0
nfcerr=0
nrderr=0
nederr=0
nfderr=0
nserr=0
sfile=display.s
: . . . . . . . . . . . . . . . . . . . .
:
: Test loop begins here.
:
until test $stopgo = stop
  do
    nerr=0
    rm -f sio.d
    echo
    echo . . . . . . . . . . >> sysck.log
    echo Begin Pass $passn . >> sysck.log
    echo Begin Pass $passn .

    echo '                   Approximate Run Time  (mm:ss)'
 

    echo
    echo 'Test 1. Memory Check.                     00:10'
    memck.o > memck.t1 &
    memck.o > memck.t2 &
    wait
    cat memck.t1 memck.t2 > memck.t
    if test -s memck.t
       then { nmemerr=`expr $nmemerr + 1`
              nerr=`expr $nerr + 1`
              cat memck.t >> sysck.log
              echo Error in memory check. >> sysck.log
              echo Error in memory check.
              errcon.sh $errf
            }
    fi
: . . . . . . . . . . . .  . . . . .
:
: Bypass this test in debug mode.
:
if test -f dbmode
   then echo Test 2 bypassed in debug mode.
   elif test $stopgo = go
        then {
          echo
          echo 'Test 2. Rigid Disk File Integrity Check.  01:10'
          fsck -n > fsck.t
          if test $? != 0
             then { nfcerr=`expr $nfcerr + 1`
                    nerr=`expr $nerr + 1`
                    cat fsck.t >> sysck.log
                    echo Error in rigid disk integrity check. >> sysck.log
                    echo Error in rigid disk integrity check.
                    errcon.sh $errf
                  }
          fi
        }
fi
if test $stopgo = go
   then {
    echo
    echo 'Test 3. Rigid Disk Write/Read Check       00:15'
    cp rdisk.s rdisk.d > rdisk.t
    cmp rdisk.s rdisk.d >> rdisk.t
    if test -s rdisk.t
       then { nrderr=`expr $nrderr + 1`
              nerr=`expr $nerr + 1`
              cat rdisk.t >> sysck.log
              echo Error in rigid disk write/read check. >> sysck.log
              echo Error in rigid disk write/read check.
              errcon.sh $errf
            }
    fi
 
    if test $2 = y
       then { echo
              echo 'Test 3.5. Expansion Hard Disk Check.      00:15'
              cp  rdisk.s /hd1/rdisk.d > rdisk.t
              cmp rdisk.s /hd1/rdisk.d >> rdisk.t
              if test -s rdisk.t
                 then { nederr=`expr $nederr + 1`
                        nerr=`expr $nerr + 1`
                        cat rdisk.t >> sysck.log
                  echo Error in Expansion Hard Disk write/read check. >> sysck.log
                        echo Error in Expansion Hard Disk write/read check.
                        errcon.sh $errf
                      }
                fi
            }
    fi
    }
  fi
 

if test $stopgo = go
   then {
    if test $3 = y
       then
       {   echo
           echo 'Test 4. Flexible Disk Write/Read Check.   00:45'
           cp fdwr.sh sysx.t
           fdwr.sh >> sysck.log &
           pn=$!
           sleep 55
           if test -s sysx.t
              then { kill $pn > /dev/null
                     echo Flexible Disk Hardware
                     echo Flexible Disk Hardware EWrror >> sysx.t
                   }
              else cmp rdisk.s fdisk.d >> sysx.t
           fi
           if test -s sysx.t
              then { nfderr=`expr $nfderr + 1`
                     nerr=`expr $nerr + 1`
                     cat sysx.t >> sysck.log
                     echo Error in flexible disk write/read check. >> sysck.log
                     echo Error in flexible disk write/read check.
                     errcon.sh $errf
                   }
           fi
        }
    fi
   }
fi
 
if test $stopgo = go
   then {
    if test $6 != n
       then
       {   echo
           echo 'Test 5. Serial I/O Loopback Test.         01:15'
           cp fdwr.sh sysx.t
           pn=$!
           siochk.sh $6 $7 $sfile 2> /dev/null  &
           sleep 85
           if test -f sysx.t
              then kill $pn > /dev/null
              else cmp $sfile sio.d > siochk.t
           fi
           if test -s sysx.t -o -s siochk.t
              then { nserr=`expr $nserr + 1`
                     nerr=`expr $nerr + 1`
                     cat siochk.t >> sysck.log
                     echo Error in SIO loopback test. >> sysck.log
                     echo Error in SIO loopback test.
                     errcon.sh $errf
                   }
           fi
       }
    fi
   }
fi
 
if test $stopgo = go
   then {
    echo
    echo 'Test 6. Terminal CRT Output.              00:20 per CRT'
    crtcntrl.sh $5 $6 $7 1   2> /dev/null
    echo
   }
fi
 
if test $stopgo = go
   then {
    if test $4 != n
       then
        {   echo
            echo -n 'Test 7. Printer Output.            '
            if test $4 = 1 -o $4 = 3
               then { echo 01:40
                      stime=110
                    }
                else { echo 02:25
                       stime=155
                     }
            fi
            cp fdwr.sh sysx.t
            sprint.sh &
            pn=$!
            sleep $stime
            if test -f sysx.t
               then { kill $pn > /dev/null
                      echo Printer not ready.
                      echo Printer not ready. >> sysck.log
                      errcon.sh $errf
                    }
            fi
        }
    fi
   }
fi
: . . . . . . . . . . . . . . . . . . . .
:
: Check for last pass.
: If not, increment pass number.
:
    echo
    echo End of Pass $passn .
    if test $nerr = 0
       then echo No errors. >> sysck.log
    fi
    if test $passn = $npass
       then break
       elif test $stopgo = go
            then passn=`expr $passn + 1`
    fi
  done
: . . . . . . . . . . . . . . . . . . . .
:
: End of test loop. Write messages to test log file and crt.
:
echo . . . >> sysck.log
echo -n End of Stage I.  .  . >> sysck.log
date >> sysck.log
echo End of Stage I.
: . . . . . . . . . . . . . . . . . . . .
:
: Display summary information.
:
echo
echo Stage I Summary.
echo
esumm.sh $passn $nmemerr $nfcerr $nrderr $nederr $nfderr $nserr
: . . . . . . . . . . . . . . . . . . . .
:
: Clean up file litter.
:
rm -f fsck.t memck.t rdisk.t fdwr.t siochk.t sysx.t
rm -f memck.t1 memck.t2 print1.s rdisk.d sio.d /hd1/rdisk.d
 
: . . . . . . . . . . . . . . . . . . . .
:
: Execute Stage II control shell,
: unless operator wants out.
:
echo
entry=bad
until test $entry = good
  do
    echo -n Do you want to run Stage II ? [y or n].
    read stageII
    if test $stageII
       then if test $stageII = y -o $stageII = n
            then entry=good
            fi
    fi
  done
 

if test $stageII = y
   then exec stageII.sh $1 $2 $3 $4 $5 $6 $7 $8 $9
   else { rm -f display.s print2.s rdisk.s 
          if test $6 != n
             then { siofin.sh  $6 $7  2> /dev/null
                    waketty.sh $8 $9  2> /dev/null
                  }
          fi
          dlog.sh
         }
fi
 
: . . . . . . . . . . . . . . . . . . . .
:
: End of Stage I shell.
:
