/*************************************************************************
*
*
*	Name:  debdump.c
*
*	Description:  Debugger -  DUMP routines.
*
*
*	History:
*	Date		By		Comments
*
*	4/14/83		waf
*	5/02/83		waf		chk for line# table present for DUMP LT.
*	5/04/83		waf		Byte & char displays for DUMP UST.
*	5/12/83		waf		file & lock table displays.
*	5/16/83		waf		GOSUB & FOR/NEXT stack dumps.
*	10/11/83	waf		Add device codes to file table dump.
*	10/28/83	waf		Use BBCHANS param for file table dump.
*	11/03/83	waf		Added '@<offset>' option to DUMP LT cmd.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */



/*  Notes -


.SH */
#include	"debug.h"

debdump ()

{
	int	x,n,i;
	int	ptr,ix,os;
	int	varos,varix;
	char	vartype;
	int	nb;
	FNDES	*fsp;
	GSDES	*gsp;

	gettkn( -1 );		/* get nxt char */

	/* 
	.SH */

	if ( cmdcmp( "LT" ) == 0 ) {

		/** Dump Line Table **/

		if ( ltexists( 1 ) == FALSE )
			return( -1 );

		/* chk for starting line#/os */
		ix = 0 ;		/* assume start at first entry */
		n = 32766 ;		/*   and show all entries */
		gettkn( -1 );
		if ( token.typ != EOLN ) {

			/* get ix of starting offset/line# */
			stmt_os( 0 );	/* get os of this or next stmt */
			ix = ltix ;		/* line tbl ix of starting entry */

			/* chk for 'n' (# of lines to show) */
			if ( token.typ == EOLN )
				n = 32767 ;		/* show all */
			else {
				gettkn( PNUM );	/* skip ',' */
				n = (int) token.nval ;	/* # of entries to show */
				}
			}

		/* show it */
		sohead() ;		/* print header */
		ltloop( ix ) {
			showlo( ltix );
			if ( --n <= 0 )
				break;
			}
		}

	/* 
	.SH */

	else if ( cmdcmp( "UST" ) == 0 ) {

		/** Dump UST **/

		printf( "  %15.s    %s ", "ust entry", "val" );
		showbase();
		putchar( '\n' );

#define	ustn( A )		/* show an integer entry */ \
		printf( "  %15.s %6.s\n", "A", numstr(ust.A) );

#define	ustc( A )	/* show a character entry */ \
		printf( "  %15.s %6.s  ", "A", numstr( (int)ust.A & 0xff ) ); \
				showchar( ust.A ); \
		putchar( '\n' );

#define	usts( A )	/* show a string entry */ \
		printf( "  %15.s   %s\n", "A", ust.A );

		ustc(lcan);
		ustc(dele);
		ustc(del);
		ustc(unpend1);
		ustc(unpend2);
		ustc(ikey1);
		ustc(ikey2);
		ustn(pagewidth);
		ustn(tabsiz);
		ustn(inputmax);
		ustc(lcane1);
		ustc(lcane2);
		ustc(pad);
		ustn(padcnt);
		ustn(pushcnt);
		ustn(columncnt);
		usts(pname);
		usts(defoutput);
		ustn(termtype);
		ustn(swaperr)
			ustn(user1);
		ustn(user2);
		ustn(security);
		ustn(slibfd);
		ustn(slibhash);
		usts(libdir);
		usts(sysdir);
		ustn(ulibfd);
		ustn(ulibhash);
		ustn(pjobno);
		ustn(logintime);

		ustn(stmtx.trace);
		ustn(stmtx.ikey);
		ustn(stmtx.singstep);
		ustn(noecho);
		ustn(nocolumn);
		ustn(nomsgs);
		ustn(lower);
		ustn(ctlchar);
		ustn(xfrcrlf);
		ustn(noikey);
		ustn(flag2);
		ustn(alarmflag);
		}

	/* 
	.SH */

	else if ( cmdcmp( "FILES" ) == 0 ) {

		/** show file table **/
		printf( "    chan    fd   mode  inode    dev\n" );
		for ( i = 0 ; i <= BBCHANS ; i++ ) {
			printf( "    %2.d > %6.s %6.s %6.s %6.s\n",
			i, numstr(ust.ftab[i].xfd),
			numstr(ust.ftab[i].opmode), numstr(ust.ftab[i].ino),
			numstr(ust.ftab[i].dev) );
			}
		}



	else if ( cmdcmp( "LOCKS" ) == 0 ) {

		/** show lock table **/
		printf( "    no.   id     fd  start   size\n" );
		for ( i = 0 ; i < 32 ; i++ ) {
			printf( "    %2.d >  %3.s %6.s %6.s %6.s\n", i,
				numstr(ust.ltab[i].lno), numstr(ust.ltab[i].lfd),
				numstr(ust.ltab[i].lstart), numstr(ust.ltab[i].lsiz) );
			}
		}

	/* 
	.SH */

	else if ( cmdcmp( "GF" ) == 0 ) {

		/** Dump global frame info **/

#define	gfn( H, A)	printf( "  %20.s   ", H ); \
		showao( gframe.A ) ;

		gfn( "Error Vector", ERRVEC.B );
		gfn( "Interrupt Vector", INTVEC.B );
		gfn( "Base Stack Ptr", BSP.B );
		gfn( "Data table ptr", DTP.B );


		/** GOSUB stack **/
		printf( "  GOSUB stack -\n" );

		/* get desc */
		ix = varlookup( "?GOSUB" );		/* get ix of var entry */
		os = getvaros( ix );		/* stk os of desc */
		getades( os );

		/* get ptrs */
		gsp = (GSDES *)ades.adata.j ;		/* start of GS stack */
		iptr = (int *)gsp ;
		ix = adr_sos( iptr );		/* os of tos */
		printf( "    GS stack addr = %s, offset = %s\n",
		numstr(iptr), numstr(ix) );

		/* show stk */
		printf( "     #  " );  
		sohead() ;		/* show header */
		i = 0 ;
		while ( gsp < gframe.GSP ) {
			j = getstkw( ix );		/* ptr to stmt */
			k = adr_os( j );		/* os of stmt */
			printf( "    %2.d  ", ++i );	/* show entry # */
			showso( k );		/* show stmt# & os */

			ix += 2 ;
			gsp++ ;
			}


		/** FOR/NEXT list **/
		printf( "  FOR/NEXT list -\n" );

		/* get desc */
		ix = varlookup( "?FORNX" );	/* get ix of var entry */
		os = getvaros( ix );		/* stk os of desc */
		getades( os );

		/* get ptrs */
		fsp = (FNDES *)ades.adata.j ;		/* start of FN stk */
		iptr = (int *)fsp ;
		ix = adr_sos( iptr );		/* os of tos */
		printf( "    FNSP addr = %s, offset = %s\n",
		numstr(iptr), numstr(ix) );

		/* show stk */
		i = 0 ;
		printf("     #  cv adr  cv os  cv val  limit  step  loop\n" );
		while ( fsp < gframe.FNSP ) {

			/* # */
			printf( "    %2.d  ", ++i );

			/* cntrl var */
			j = getstkw( ix );		/* addr of cntrl var */
			k = adr_sos( j );			/* offset of val */
			printf( "%7.s %6.s %6.D  ", numstr(j), numstr(k), getstklw(k) );

			/* limit */
			ix = ix + sizeof(NPTR);
			printf( "%5.D  ", getstklw(ix) );

			/* step */
			ix = ix + sizeof(NUMVAL) ;
			printf( "%4.D", getstklw(ix) );

			/* loop */
			ix += sizeof(NUMVAL) ;
			j = getstkw( ix );		/* ptr to stmt */
			k = adr_os( j ) ;		/* os of stmt */
			showso( k );			/* show stmt# & offset */

			ix += 2 ;
			fsp++ ;
			}


		/** User Defined Functions **/
		printf( "  User defined functions -\n" );
		printf( "    fn    addr     os\n" );
		for ( i=0; i<=25 ; i++ ) {
			j = (int *)gframe.FUNC[i].J ;		/* addr of handler */
			if ( j != 0 ) {
				printf( "     %c  ", (char) (i + 65) );
				k = adr_os( (int) j );
				printf( " %6.s  %5.s\n", numstr(j), numstr(k) );
				}
			}
		}
	/* 
	.SH */

	else if ( cmdcmp( "STK" ) == 0 ) {

		/* Dump evaluation stack */
		printf( "  Enter # of bytes to display or 'all'\n" );
		getcmd();
		gettkn( -1 );
		if ( cmdcmp( "ALL" ) == 0 )
			n = pmhead.stksiz;
		else {
			if ( token.typ != NUM )
				syntax();
			n = (int) token.nval;
			}
		k = 16;		/* entries per line */
		j = k;
		for ( i=0 ; i<=n ; i++ ) {
			if ( j >= k ) {
				printf( "\n%4.s >  ", numstr(i) );
				j = 0 ;
				}
			printf( "%4.s", numstr( (int) (evalstk[i] & 255) ) );
			j++;
			if ( j == 8 )  putchar ( ' ' );
			}
		putchar( '\n' );
		}

	/* 
	.SH */

	else if ( cmdcmp( "VARS" ) == 0 ) {


		/** dump var table **/

		if ( stexists( 1 ) == FALSE )
			return( -1 );

		for ( i = VAR1 ; i < VARMAX ; i++ ) {

			/* chk end of table */
			if ( vtab[i].vname[0] == '\0' )  break ;

			/* show var name */
			printf( "\n%s -\n", vtab[i].vname );

			/* set up cmd line */
			clptr = 0 ;		/* reset parser */
			strcpy( cmdline, "; " );
			strcat( cmdline, vtab[i].vname );

			/* call debug to show this var */
			docmd();
			}


		return( 0 );
		}


	/* 
	.SH */


	else {

		/** Bad char **/
		error( "Bad Dump object" );
		}

	return( 0 );
	}
