0010 Rem - IBUILD.bb
:   IBUILD - Program to build an index file given a sorted tag file,
:            sorted data file, or another index file.
:
: ARGUEMENTS PASSED IN COMMON
:   LOC  LEN  USE
:    1    4   CHANNEL # OF INPUT FILE 
:    5    4   BYTE OFFSET TO REC # 0 OF INPUT FILE
:    9    4   LAST-RECORD-NUMBER IN INPUT FILE 
:   13    4   # OF BYTES PER RECORD IN INPUT FILE
:   17    4   CHANNEL # OF INDEX FILE 
:   21    4   BYTE OFFSET TO REC # 0 OF INDEX FILE
:   25    4   LAST-RECORD-NUMBER IN INDEX FILE 
:   29    4   # OF BYTES PER RECORD IN INDEX FILE 
:   33    2   # PER BLOCK (BLOCKING FACTOR)
:   35    2   FLAG TO DISALLOW DUPLICATE KEYS   
:   37    2   FLAG TO CHECK FOR DELETED RECORDS
:   39    2   TOTAL KEY FIELD LENGTH (BYTES)
:   41    2   # OF KEY FIELDS OR -1 (-1 = TAG FILE INPUT)
:             OR -2 (-2 = INDEX FILE INPUT)
:   43+  2*2  STARTING & ENDING BYTE # (RELATIVE TO 1) OF KEY
:             FIELDS IN ORDER OF SIGNIFIGANCE
:
: RETURNED
:   STMA 2,1,(ERROR CODE)
:   STMA 2,2,(LINE # IN ERROR)
:
: DATA FILE: KEY EXTRACTED FROM DATA RECORD COMPOSED OF THE FIELDS 
:   SPECIFIED, UP TO THE TOTAL KEY FIELD LENGTH. PADDING OF ODD SIZED
:   KEYS WITH NULLS IS AUTOMATIC.
:   DATA RECORDS 1 TO MAX#-1 ARE PROCESSED.
:
0100 ON ERR THEN GOTO 5030         :Return error traps to calling program
0101 REM IBUILD - REV 2.00 (09/26/77)
0110 LET ERCODE%=0                 :Init error code
0200 DIM X$[512]                   :Read arguments from common
0230 BLOCK READ X$
0260 LET INPCHN%=ASC(X$[1,4])      :Channel # of input file
0290 LET INPDSP%=ASC(X$[5,8])      :Displacement to input file
0320 LET INPMAX%=ASC(X$[9,12])     :Input record count
0350 LET INPSIZ%=ASC(X$[13,16])    :Input record size
0380 LET NDXCHN%=ASC(X$[17,20])    :Channel # of index file
0410 LET NDXDSP%=ASC(X$[21,24])    :Displacement to index file
0440 LET NDXMAX%=ASC(X$[25,28])    :Max # of index blocks
0470 LET NDXSIZ%=ASC(X$[29,32])    :Index block size (must be 512)
0510 LET KPBLOC%=ASC(X$[33,34])    :Blocking factor (keys/block)
0512 LET DUPKEY%=ASC(X$[35,36])    :Flag to disallow duplicate keys
0514 LET CKSTAT%=ASC(X$[37,38])    :Flag to check for deleted records
0516 LET KEYLEN%=ASC(X$[39,40])    :Input key length
0517 LET NKFLDS%=ASC(X$[41,42])    :Number of key fields 
0518 LET INPTYP%=OR(NKFLDS%,-AND(NKFLDS%,32768))
0519 IF INPTYP%>0 THEN GOTO 0523
0520 LET NKFLDS%=1                 :Adjust for index & tag input
0521 GOTO 0524
0523 LET INPTYP%=1                 :Flag for input file type (data)
0524 DIM KDEF%[NKFLDS%*2,0]        :Allocate key definition array
0525 FOR I%=43 TO 41+4*NKFLDS% STEP 2   :Extract field locations
0526   LET KDEF%[(I%-43)/2]=ASC(X$[I%,I%+1])
0527 NEXT I%
0528 LET NKFLDS%=NKFLDS%-1         :Change 1:n to 0:n-1
0530 DIM KDEF%[NKFLDS%,1]          :ReDIM for easier access
0535 DIM REC$[INPSIZ%]             :Allocate input record
0600 IF INPTYP%<>-1 THEN GOTO 0740
0610 LET INPTYP%=0                 :Set flag for tag input file
0620 LET KDEF%[0,0]=1              :First col
0630 LET KDEF%[0,1]=KEYLEN%        :Last col
0640 LET CKSTAT%=0                 :No status in tag files
0740 LET BLKDSP%=NDXDSP%/512       :Convert byte disp to block disp
0770 IF MOD(NDXDSP%,512) THEN GOTO 5008      :Required to be on block boundary
0800 LET KEYSIZ%=KEYLEN%+4+AND(KEYLEN%,1)    :Key entry size must be even
0830 LET KPBLOK%=508/KEYSIZ%       :Max number of keys per block
0860 LET LSTBLK%=NDXMAX%           :Keep last block #
0890 LET NXTBLK%=1                 :Beginning block #
0920 LET NXTL0%=NXTBLK%            :Next level 0 block
0950 LET BLKFAC%=KPBLOC%           :Keep blocking factor
0980 LET BOTLEV%=0                 :Init bottom level pointer
1010 IF INPTYP%=-2 THEN LET INPMAX%=INPMAX%*KPBLOK%
1040 LET X%=INPMAX%                :Compute # of levels needed in index
1070 LET ITMP=0
1100 LET X%=X%/KPBLOC%+SGN(MOD(X%,KPBLOC%))  :Keys this level
1130 LET ITMP=ITMP+X%              :Count # of blocks
1160 LET BOTLEV%=BOTLEV%+1         :Bump level #
1190 IF X%>KPBLOC% THEN GOTO 1100  :Need another level?
1220 IF NDXSIZ%<>512 THEN GOTO 5007     :Index block size must be 512
1250 IF KPBLOC%>=KPBLOK% THEN GOTO 5009  :Illegal blocking factor
1280 LET BUFSIZ%=(BOTLEV%+1)*512   :Allocate buffer large enough to hold 1 block from each level
1310 DIM KENTRY$[KEYSIZ%],LSTKEY$[KEYLEN%],BUFFER$[BUFSIZ%]
1340 LET BUFFER$=FILL$(0)          :Initialize buffer
1370 LET LSTKEY$=""                :Clear comparison key
1400 LET NDFLAG%=0                 :Clear EOF flag
1410 LET BOTLEV%=0                 :Reset pointer to root level of index
1430 IF INPTYP%<>-2 THEN GOTO 2800      :Input an index file???
:
:   Processing loop for INDEX input file
2500 DIM LFTABL$[52],NBUF$[544]     :Yes, allocate descriptor and buffer
2505 LET LFTABL$=FILL$(0)
2510 LOPEN FILE[1,INPCHN%,3],"","I",512,INPMAX%,INPDSP%
2520 LET RECNO1=0
2530 LET KENTRY$=""                :Find beginning of index
2540 KFIND 1,NBUF$,KENTRY$,RECNO1
2550 IF ASC(NBUF$[1,2])>INPSIZ% THEN GOTO 5005    :Block 0 indicates index is larger than spec
2560 LET RECNO1=ABS(RECNO1)        :Correct sign on pointer
2570 GOTO 2600                     :Jump into processing loop
2580 KNEXT 1,NBUF$,KENTRY$,RECNO1  :Next key entry
2590 IF RECNO1<=0 THEN GOTO 3000   :End of index???
2600 GOSUB 3300                    :Put entry into buffer
2610 GOTO 2580                     :Next!!
:
:   Processing loop for TAG and DATA files
2800 POSITION FILE[INPCHN%,INPSIZ%*INPTYP%+INPDSP%]    :Beginning record
2810 FOR ITMP=INPTYP% TO INPMAX%        :Process specified # of input recs
2820   LET RECNO1=ITMP             :Current input record #
2840   GOSUB 3200                  :Call record input & processing procedure
2860   IF EOF(INPCHN%) THEN GOTO 3000   :File shorter than specified
2880 NEXT ITMP
:   EOJ processing
3000 GOSUB 3500                    :Insert last key & flush all buffers
3010 LET BLK0%=NXTBLK%-1           :Compute loc of top block
3020 POSITION FILE[NDXCHN%,NDXDSP%]     :Write block 0
3030 WRITE FILE[NDXCHN%],KEYSIZ%,KPBLOK%,LSTBLK%,NXTBLK%,BLK0%,BLKFAC%,DUPKEY%
3035 STMA 2,1,0
3040 END 
:
:   TAG and DATA record processing procedure
3200 POSITION FILE[INPCHN%,RECNO1*INPSIZ%+INPDSP%]
3220 READ FILE[INPCHN%],REC$       :Read record
3250 IF EOF(INPCHN%) THEN RETURN   :File shorter than specified
3260 IF CKSTAT% THEN IF REC$[1,2]="<0><0>" THEN RETURN    :Skip deleted records
3264 LET KENTRY$=""                 :Clear key
3266 FOR I%=0 TO NKFLDS%         :Compose key
3268   LET KENTRY$[0]=REC$[KDEF%[I%,0],KDEF%[I%,1]]
3270 NEXT I%
3290 IF INPTYP%=0 THEN LET RECNO1=ASC(REC$[KEYLEN%+1,KEYLEN%+4])  :Extract rec # from TAG rec
3300 IF KENTRY$[1,KEYLEN%]<LSTKEY$ THEN GOTO 5006      :Sequence check
3310 IF DUPKEY%=0 THEN IF KENTRY$[1,KEYLEN%]=LSTKEY$ THEN GOTO 5003  :Duplicate key check
3320 LET LSTKEY$=KENTRY$           :Save current key entry
3330 IF AND(KEYLEN%,1) THEN LET KENTRY$[KEYLEN%+1]="<0>"    :Pad key if length is odd
3340 LET KENTRY$[KEYSIZ%-3]=CHR$(RECNO1,4)   :Insert Rec # into key
3350 IF ASC(KENTRY$[KEYSIZ%-3,KEYSIZ%])<=0 THEN GOTO 5004   :Valid rec # check
3360 GOTO 3600                     :Enter key insert procedure
:
:   Close index procedure
3500 LET KENTRY$[1,KEYSIZ%]=FILL$(-1)   :Generate HI-KEY as end of index flag
3520 LET NDFLAG%=1                 :Set END flag
:   Key insert procedure
3600 LET BLKLEV%=0                 :Key will be inserted as level 0
3610 LET BLKBAS%=BLKLEV%*512       :Base pointer to buffer stack
3620 LET KEYCNT%=ASC(BUFFER$[BLKBAS%+1,BLKBAS%+2])     :Current key count at this level
3630 LET NXEDSP%=KEYCNT%*KEYSIZ%+5      :Disp to next available entry slot
3640 LET BUFFER$[BLKBAS%+NXEDSP%,BLKBAS%+NXEDSP%+KEYSIZ%-1]=KENTRY$  :Insert key entry
3650 LET BUFFER$[BLKBAS%+1,BLKBAS%+2]=CHR$(KEYCNT%+1,2)     :Bump key count this level
3660 IF NDFLAG% THEN GOTO 3800     :On END update & flush all levels
3670 IF KEYCNT%+1<KPBLOC% THEN RETURN   :Done if more room at this level
:   Buffer flush procedure
3800 LET BUFFER$[BLKBAS%+NXEDSP%+KEYSIZ%,BLKBAS%+512]=FILL$(-1)  :Fill remainder of level with HI-KEYs
3810 IF BLKLEV%<>0 THEN GOTO 3870  :Skip level 0 processing for higher levels
3820 LET BUFFER$[3,4]=CHR$(NXTBLK%+1,2)      :Update sequential chain
3830 IF NDFLAG% THEN LET BUFFER$[3,4]=CHR$(-1,2)  :On END mark end of chain
3840 LET BLKNO%=NXTL0%             :Location for this level 0 block
3850 LET NXTL0%=ASC(BUFFER$[3,4])  :Reserve location for next level 0 block
3860 GOTO 3890                     :Skip available block update
3870 IF NXTBLK%=NXTL0% THEN LET NXTBLK%=NXTBLK%+1      :Skip block reserved for level 0
3880 LET BLKNO%=NXTBLK%            :Location for this block
3890 BLOCK WRITE FILE[NDXCHN%,BLKNO%+BLKDSP%],BUFFER$[BLKBAS%+1,BLKBAS%+512]
3900 LET KENTRY$[KEYSIZ%-3]=CHR$(BLKNO%,4)   :Build key entry for next level up tree
3910 LET BUFFER$[BLKBAS%+1,BLKBAS%+512]=FILL$(0)  :Clear buffer segment for this level
3920 LET NXTBLK%=NXTBLK%+1         :Bump next available block #
3930 IF NXTBLK%>LSTBLK% THEN GOTO 5010  :Index full??
3940 LET BLKLEV%=BLKLEV%+1         :Bump buffer stack pointer
3950 IF NDFLAG% THEN IF BLKLEV%>BOTLEV% THEN RETURN    :Done when all level updated & flushed
3960 IF BLKLEV%>BOTLEV% THEN LET BOTLEV%=BLKLEV%  :Current top block full, add new top block
3970 GOTO 3610                     :Key insert procedure calls itsself to add entry pointing to level just flushed
3980 RETURN 
:
:   Error code returns
5000 DATA 68,150,148,45,149,151,85,146
5003 READ ERCODE%        : 146 - Duplicate entry
5004 READ ERCODE%        : 077 - Invalid record pointer
5005 READ ERCODE%        : 151 - Key size found > specified
5006 READ ERCODE%        : 149 - Input record out of sequence
5007 READ ERCODE%        : 045 - Illegal index record size(<>512)
5008 READ ERCODE%        : 148 - Illegal index file displacement
5009 READ ERCODE%        : 150 - Illegal blocking factor
5010 READ ERCODE%        : 068 - Index space exhausted
5015 LET X%=0                     :Clear line #, not a BASIC error
5020 GOTO 5050
5030 LET ERCODE%=SYS(7)           :BASIC error code
5040 LET X%=SYS(20)         :Line # in error
5050 STMA 2,2,X%
5060 STMA 2,1,ERCODE%
5090 LET X$=FILL$(0)               :Clobber block 0 of index so it won't be used
5100 POSITION FILE[NDXCHN%,NDXDSP%]
5110 WRITE FILE[NDXCHN%],X$
5150 END

