/*************************************************************************
*
*
*	Name:  bopen.c
*
*	Description:  OPEN FILE and CLOSE [FILE] statements.
*
*
*	History:
*	Date		By		Comments
*
*	03/14/83	WEB
*	04/06/83	MAS	changed open to handle ?LPT files
*	04/13/83	WEB	fixed bug w/ create not allowing
*				reads in mode 0
*	04/14/83	WEB	changed '/bbsyslib' to '/bb/syslib' and
*				'/bbsyslib/spool' to '/bb/spool', added
*				support for read-only access to 'syslib'
*	04/25/83	WEB	fixed a problem with EOPENing a file twice
*				in the same process
*	04/27/83	WEB	fixed a problem with global close not 
*				IDLE'ing the channels
*	04/29/83	MAS	added mode 12 and 13 to open
*	05/03/83	WEB	added pseudo-link resolution in '/bb/syslib'
*				in modes 3 & 4
*	05/11/83	WEB	fixed lastfileno to be set by open, etc.,
*				added support for character i/o
*	05/18/83	mas	added call to spscan to remove trailing
*				spaces and control chars from file name
*	05/20/83	mas	added call to chkpath to search BBPATH
*				in read only opens
*	05/25/83	mas	fixed bug where open mode was not cleared
*				in open mode 12 or 13
*	06/15/83	mas	changed to open file as given first and if
*				it fails to then call resolve
*	06/16/83	mas	squeeze memory and speed
*	07/11/83	mas	fixed bug in bclose where all opened 
*				files were being unlocked if channel was '16'.
*	07/21/83	mas	changed bclose to call unlks() if the file
*				being closed had any locks
*	09/09/83	waf		bclose() - call bpclose() to close a given fd,
*					in case the file was opened mode 12 or 13.
*	09/13/83	waf		bopen() - recursive calls to 'bopen()' after EMFILE
*					error were misnamed 'open()'. Re-named to 'bopen()'.
*						Also, report EMFILE error if no more fd's available.
*	09/14/83	waf		** Rewrite bopen() - Reduce code size & fix bug.
*	10/11/83	waf		Use ust.ftab[].dev to make ust.ftab[].ino unique across
*					multiple file systems.
*	10/27/83	waf		Added BBCHANS param.
*						Also moved spos(),gpos(),&eof() to filefns.c.
*	10/28/83	waf		Use badchan()/badfchan() macros to chk legal channel #.
*						Also, use chanloop() macro.
*	11/16/83	waf		Use LCKTBLSIZ parameter.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

09/09/83	waf
	Files opened in mode 12 or 13 (pipes to the shell) must call bpclose()
  when they are closed in order to clean up the pipe process.

09/14/83	waf
	bopen() - if we ran out of fd's during an open call, and were not able
  to find any extra, the error code returned was previously incorrect.
  This was fixed, and the code squeezzed by using (boo!) 'goto's.


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/pcondcomp.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#define NBRLOCK 4			/* non-blocking, read-permitted lock */
#define UNLOCK 1
#define ALL 0L				/* lock/unlock entire file */
#define PMODE 0666			/* protection mode for create */
#define FILOFFSET 0L			/* offset and origin for */
#define FILEND 2			/*    lseek to append to file */

extern int errno;
extern long lseek();

bopen (err, channel, lmode, file)
NUMDES	err;
int	channel;
long	lmode;
STRDES	file;
{
	register int    mode;
	register int	fd;
	int	e,rwm;
	long	l;
	char   fname[PATHSIZE], fname2[PATHSIZE];
	struct stat stats;
	struct frec *ftr;

	if ( badfchan(channel) ) {
		errchk(&err, BEIFN);		/* illegal file channel number */
		return;
		}

	mode = lmode;	/* get mode in register */

	if ((mode < 0 || mode > 6) && mode != 12 && mode != 13) {
		errchk(&err, BEMOD);			/* illegal mode */
		return;
		}

	ftr = &ust.ftab[channel];

	if (ftr->xfd != IDLE) {
		errchk(&err, BEFAO); 			/* channel in use */
		return;
		}

	/* get filename */
	movs( file.data, fname, file.curlth );
	fname[file.curlth] = '\0' ;		/* term filename */
	spscan(fname);					/* remove trailing junk */

	if (mode == 12 || mode == 13) {


		/**  Open Pipe  **/

		rwm = (mode == 13) ? 0 : 1;
		if ((fd = bpopen(fname, rwm)) < 0) {
			clserr( 1 );		/* need 2 fd's for pipe */


openerr:	/* Error ocurred while opening file.
				Chk error code,
				If EMFILE, retry bopen() after scavenging fd's.
				If other error, report error. */
			if (errno == EMFILE) {

				/* no more fd's, try closing basic.er and/or basic.no */
				if(clserr(1) == TRUE) {
					/* try again after closing .er & .no */
					bopen(err,channel,lmode,file);
					return;
					}
				else
					/* no more fd's */
					errno = EMFILE ;		/* reset errno */
				}

			/* report error (in errno) */
			errxechk( &err );
			return;
			}


		ftr->opmode = SH_FM;			/* set open mode to something*/
		e = 0;
		} 


	/**  Open File  **/

	else {
		if (fname[0] == '?') {			/* spool file if "?" */

			/** Spool File **/
			/* chk mode */
			if ( mode != 1 && mode != 2 ) {
				errchk( &err, BEMOD );
				return;
				}

			/* Create unique spool file name */
			l = sys(0);
			do {					/* keep trying until it works */
				strcpy(fname2, xspooldir);
				strcat( fname2, fname+1);
				strcat(fname2, "$");
				cbdl(&fname2[strlen(fname2)], l, 0); 	/* put time on end */
				l++;
				} 
			while (access(fname2, 0) == 0);
			strcpy(fname,fname2);			/* copy name to tmp */
			}

		else

			/* resolve file name */
			resolve( fname, fname );

		/** Modes  3 - 6 **/

		if (mode >= 3 && mode <= 6) {
			rwm = (mode <= 4) ? 0 : 2;		/* set mode for open */
			fd = open( fname, rwm );	/* open it */
			if (fd < 0 ) {
				if ( errno != ENOENT )
					goto openerr;	/* report error */

				/* file not found */
				if ( mode >= 5 )
					goto openerr ;	/* report error */

				/* Chk 'default' dirs in modes 3 & 4 */
				strcpy(fname2,fname);
				if (chkpath(fname2, fname) == ERLDE) {
					errchk(&err, ERLDE);
					return;
					}
				fd = open(fname, rwm );
				if ( fd < 0 ) {
					goto openerr ;	/* report error */
					}
				}
			}
		else {


		/** Modes  0 - 3 **/

			e = 0 ;		/* flags file not found in modes 0,2 */
			if (mode == 0 || mode == 2) {

				/* chk for existing file */
				rwm = (mode == 0) ? 2 : 1;		/* set mode for open */
				fd = open( fname, rwm );	/* open it */
				if ( fd < 0 ) {
					if ( errno != ENOENT )
						goto openerr ;		/* report error */
					e = 1 ;		/* flag not found */
					}
				}
			if (e == 1 || mode == 1) {

				/* Mode 1 or File not found in Mode 0 or 2 */
				if ((fd = creat(fname, PMODE)) < 0)	/* create file */
					goto openerr ;	/* report error */
				if (mode == 0) {
					close(fd);				/* close & re-open if mode 0 */
					fd = open(fname, 2);	/*   to get R/W operation */
					}
				}
			}

		/** chk exclusive/shared modes **/

		if ( mode <= 2 || mode == 6 ) {

			/* exclusive mode */
#ifndef NOLOCKING
			if (locking(fd, NBRLOCK, ALL) < 0) {	/* lock file as EOPEN */
				errchk(&err, ERFIU);		/* error if in use */
				return;
				}
#endif
			ftr->opmode = EX_FM;			/* set exclusive mode */
			} 
		else

			/* shared mode */
			ftr->opmode = SH_FM;			/* set shared mode */

		if (mode == 2)
			lseek(fd, FILOFFSET, FILEND);		/* position for append mode */
		}	/* end mode select */


	/** Set remaining mode flags **/
	switch (mode) {
	case 0:
		ftr->opmode |= RW_FM;
		break;
	case 1:
		ftr->opmode |= WR_FM + SEQ_FM;
		break;
	case 12:
	case 2:
		ftr->opmode |= WR_FM + SEQ_FM;
		break;
	case 13:
	case 3:
		ftr->opmode |= RD_FM + SEQ_FM;
		break;
	case 4:
		ftr->opmode |= RD_FM;
		break;
	case 5:
		ftr->opmode |= RW_FM;
		break;
	case 6:
		ftr->opmode |= RW_FM;
		break;
		} /* end-switch */

	fstat(fd, &stats);				/* get file stats */

	if ((ftr->opmode & EX_FM) == EX_FM)
		/* check for EOPEN with self */
		chanloop( e ) {
			if ( e == 16 )
				continue ;		/* skip console */
			if (ust.ftab[e].xfd != IDLE && ust.ftab[e].ino == stats.st_ino
					&& ust.ftab[e].dev == stats.st_dev ) {
				/* already open'ed */
				close(fd);
				errchk(&err, ERFIU);
				return;
				}
			}

	/* save info in file table entry */
	ftr->xfd = fd;				/* file descriptor */
	ftr->ino = stats.st_ino;	/* i-node */
	ftr->dev = stats.st_dev;	/* file system dev codes */

	if ((stats.st_mode & S_IFCHR) == S_IFCHR ||	/* check for character file */
	stats.st_mode == 0x8000)		/* check for pipe */
		ftr->opmode |= CHAR_FM;		

	lastfileno = channel;			/* set last-file-accessed */

	errchk(&err, NOERR);				/* set no-error */

	} /* end-bopen */

clserr (fdcount)

int	fdcount;
/*
synopsis -
	Close some bb system files to try to regain some fd's.

description -
	Input val fdcount = # of files to be closed.
	basic.er file and basic.no file are tried, in order.

return -
	return val	=	TRUE if a file was closed.
					FALSE if no files could be closed.
	*/

{
	register int	i;

	i = 0;

	/* close basic.er, if open */
	if (errfd != IDLE) {
		close(errfd);
		errfd = IDLE;
		++i;
		}

	if (i == fdcount) {
goodret:
		return(TRUE);
		}

	/* close basic.no, if open */
	if (numfd != IDLE) {
		close(numfd);
		numfd = IDLE;
		++i;
		}

	if (i == fdcount) 
		goto goodret ;

	return(FALSE);		/* couldn't close any */
	}

bclose (channel)
int	channel;
{
	register int  ch;
	register struct frec *ftr;
	int	i;

	if ( badchan(channel) )
		bberr(BEIFN);				/* illegal channel number */

	if (channel != 16) {				/* close single channel */

		/** CLOSE FILE **/
		ftr = &ust.ftab[channel];
		if (ftr->xfd == IDLE)
			bberr(BEFNO); 				/* file not open */
		if ((ftr->opmode & EX_FM) == EX_FM)
			locking(ftr->xfd, UNLOCK, ALL);	/* unlock if EOPENed */
		for (i=0; i<LCKTBLSIZ; ++i) {
			if(ust.ltab[i].lfd == ftr->xfd)	/* look for locks on this fd */
				unlks(ust.ltab[i].lno);		/* unlock it */
			}

		/* bpclose() the file */
		bpclose( ftr->xfd );		/* close the fd (and kill pipe if exists)*/

		ftr->xfd = IDLE;				/* mark file table as closed */
		lastfileno = channel;			/* set last-file-accessed */
		} 

	else {

		/** Global CLOSE **/
		unlks(0);					/* unlock everything */

		/* close all open chan's */
		chanloop( ch ) {
			if ( ch == 16 )
				continue ;		/* skip console */
			ftr = &ust.ftab[ch];
			if (ftr->xfd != IDLE) {
				if ((ftr->opmode & EX_FM) == EX_FM)
					locking(ftr->xfd, UNLOCK, ALL);
				bpclose( ftr->xfd );	/* close fd & kill pipe if exists */
				ftr->xfd = IDLE;
				lastfileno = ch;
				}
			}
		}

	} /* end-bclose */
