/*************************************************************************
*
*
*	Name:  xcall11.c
*
*	Description:  XCALL 11 statement
*
*
*	History:
*	Date		By		Comments
*
*	4/21/83	
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/


#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"


xcall11 ( lstr, rstr, splpt )

STRDES	lstr, rstr;		/* left & right string descriptors */
int	splpt;			/* split point, neg = justify */

{
   int	bors,	/* beginning of right segment */
	eors,	/* end of right segment */
	bols,	/* beginning of left segment */
	eols,	/* end of left segment */
	nws,	/* number of white spaces - adjacent spaces count 1 */
	pads,	/* pad spaces needed */
	splat,	/* split at point */
	i,j,m,n,p;	/* temporaries */
   STRDES	tstr;	/* temporary string desc for movdd */
   register char *bos,	/* beginning of left string (biased -1) */
	*cp,*lp,*rp;	/* temporaries */

   eols = bors = lstr.curlth;
   eors = bors - 1;
   bos = lstr.data - 1;
   splat = abs( splpt );
                    
/*debug   printf("splat,splpt,bos,eols: %6d %6d %6d %6d\n",splat,splpt,bos,eols);*/
   if ( splat < eols ) {		/* Enough to split?? */
      for ( cp = bos + (p = splat); cp >= bos; cp--, p--) 
	 if ( *cp == ' ' ) break;	/* skip over spaces at splat */
      for ( ; cp >= bos; cp--, p--) 
	 if ( *cp != ' ' ) break;	/* scan for last non-space */
      eols = p;				/* end of left seg is last non-space */

      /* Check for a right segment */
      for ( cp = bos + (p = eols + 1), j = bors; p <= j; cp++, p++)
	 if ( *cp != ' ' ) {		/* scan for last non-space in string */
	    if ( bors > p ) bors = p;	/* save beginning of right segment */
	    eors = p;			/* save end of right segment */
	 } /* end-if */
   } /* end-if */

   /* Move right segment to rstr */
   tstr.data = bos + bors;		/* point to right segment */
   tstr.curlth = eors - bors + 1;	/* set right segment current length */
   movdd ( &tstr, &rstr );		/* move right portion of string */
   updcl ( &rstr );			/* update current length of parent */

/*debug   printf("splat,splpt,bos,eols,lstr.maxlth: %5d %5d %6d %5d %5d\n",splat,splpt,bos,eols,lstr.maxlth);*/
   if ( splpt < 0 ) {			/* Justify ??? */
      if ( lstr.maxlth < splat ) return;	/* room to pad?? */
      bols = nws = i = m = n = 0;	/* clear temporaries */
      pads = splat - eols;		/* needed spaces */
      for ( p = 1; p <= eols; p++ ) {	/* scan & tally white spaces */
	 if ( *(p+bos) == ' ' ) {	/* found space, any adjacent */
	    if (bols != 0) nws++;	/* bump white space count */
	    for ( j = p+1; j <=eols; j++ )	/* any adjacent spaces?? */
	       if ( *(j+bos) != ' ' ) break;
	    p = j;			/* point past adjacent spaces */
	 } /* end-if */
	 if ( bols == 0 ) bols = p;	/* beginning of first word */
      } /* end-for */
/*debug   printf("bols,nws,p: %6d %5d %5d\n",bols,nws,p);*/
      if ( nws ) {			/* there was white space */
	 lp = bos + eols;		/* point to last non-space */
	 rp = bos + (p = eols = splat);	/* point to desired eos */
	 i = 0;
/*debug   printf("p,lp,rp,bols,eols: %6d %6d %6d %6d %6d\n",p,lp,rp,bols,eols);*/
	 for ( ; p > bols; p-- ) {	/* shuffle it all down now */
	    if ( *lp == ' ' ) {		/* found space - pad as needed */
	       i++;
	       n = (i*pads)/nws;	/* number of spaces to generate */
	       j = n - m;
	       m = n;
/*debug   printf("p,m,n,j,i: %5d %5d %5d %5d %5d\n",p,m,n,j,i);*/
	       for ( ; j >= 1; j-- ) {
		  *rp-- = ' ';		/* generate spaces */
		  p--;			/* bump toward bos */
	       } /* end-for */
	    } /* end-if */
	    *rp-- = *lp--;		/* move character down */
	 } /* end-for */
      } /* end-if */
   } /* end-if */
   lstr.maxlth -= eols;			/* adjust maxlth for updcl */
   lstr.data = eols + bos + 1;		/* point to end of left seg */
   updcl ( &lstr );			/* update cur len of parent */

} /* end-xcall11 */

