:! BINBCD - Convert a number to an 8 byte packed decimal string
:#
:     BINBCD converts a signed BINary number in X to a
:     packed decimal (Binary Coded Decimal) string in X$.
:     Conversion is signed with hex C in the low order nibble for
:     positive and hex D for negative.  The number is right justified
:     in X$ with a length of 8.  Leading zeros are supplied to allow
:     for output of a 15 digit number (although 9 is the max for X).
:> CALLING SEQUENCE
:     X  - signed BINary number to be converted
:     GOSUB 8000
:     X$ - packed decimal (BCD) string
:$ STORAGE USED
:     I% - OUTPUT STR CHAR POINTER
:     Y% - SIGN ( 12=POS, 13=NEG, 15=ZERO )
:     Y  - TEMPORARY VALUE OF X
::
8000 REM \ BINBCD (BIN->BCD)
8002 LET Y%=12                         :Assume a positive number
8004 ON SGN(X)+2 THEN GOTO 8008, 8006, 8010      :Test sign
8006 LET Y%=Y%+2                       :Hex F on zero
8008 LET Y%=Y%+1                       :Hex D on negative
8010 LET Y=ABS(X)                      :Need to work with absolute value
8012 LET X$=FILL$(0,7),CHR$(SHFT(MOD(Y,10),4)+Y%)     :Handle last digit & sign
8014 LET I%=7                          :Start with byte 7 & work backward
8016 LET Y=Y/10                        :Get rid of digit just used
8018 IF Y=0 THEN RETURN                :Done when Y is zero
8020 LET X$[I%,I%]=CHR$(SHFT(MOD(Y/10,10),4)+MOD(Y,10)) :Add next pair of digits
8022 LET I%=I%-1                       :Point to next higher byte
8024 LET Y=Y/100                       :Get rid of pair of digits used
8026 GOTO 8018                         :Go round again
8030 REM * END BINBCD.SL 8/28/78
