
/*************************************************************************
*
*
*	Name:  phdump.c
*
*	Description:  Dump pcode/pc histogram data file.
*
*
*	History:
*	Date		By	Comments
*
*	08/09/83	waf	Added profil() data support.
*	08/19/83	waf	Changed showsym() to show all symbols in the address
*					bucket range.
*	08/25/83	waf	Show symbols whose code ends in the displayed bucket.
*					Also show bucket start.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

This stand alone program displays the histogram data which was dumped by
a program which was run with the histogram option set.
The 'data' may be pcode frequency or the output of the profil() system
monitor function.
The dump file ( <pgmname>.st ) has a header at the start which describes
the type of data in the file.

*/

#define	REV		"1.3"		/* revision # */

#define	DBUG	0
#define	NOTNOW	0
int	dbug	= DBUG ;

#include <stdio.h>
#include "/bb/include/ptype.h"

#if	NOTNOW
	/* get opcodes (for pcode dump) */
#define DEBDEF 1
#include "/bb/run/src/dasm.c"
#endif

#define	datasiz	16000	/* size ( *words* ) of data storage space available */

	/* global data */
PHHEAD	header;		/* hist file header */
long	phtab[datasiz/2];	/* data table.
								(table entries are typed for pcode dump) */
int		*tblptr;	/* ptr into data table */
char	nxtsym[10],cursym[10];
unsigned nxtadr,curadr;
unsigned symcnt;	/* frequency counter for a given symbol */
int	fd;
FILE	*fp;
long	cntacc;		/* count acc */
unsigned bktsize;	/* size of address 'bucket' (scaling factor in profil()) */
unsigned bktptr;	/* bucket ptr */
#define	ATSIZE	2000
unsigned adrtbl[ATSIZE];	/* symbol address table */
int		atix;			/* index into adr table */
char	loadmap[16];	/* load map filename */
unsigned convbkt(),nxtblk();	/* addr conversion fn's */
char	lastsym[10];		/* last (previous) symbol */
unsigned lastadr,lastcnt;	/* addr & count of last symbol */

/**/

main (argc,argv)
int argc;
char *argv[];
{
	int	i,j;
	char	buf[PATHSIZE],*cptr,c;
	unsigned *uptr,chk;
	int	bsize;
	int	wos;
	unsigned blkstart;

	if (dbug) 	{
		printf( ">> Debug level = %d\n", dbug );
		puts( "Enter debug level (0-10)" );
		gets( buf );
		j = sscanf( buf, "%d", &i );
		if ( j > 0 ) {
			dbug = i ;
			printf ( ">> Debug level = %d\n", dbug );
			}
		}

	if (argc < 2) 	{
		printf("\nUsage: %s <dump_file>\n",argv[0]);
		exit(-1);
	}

	printf( "\nphdump  rev. %s\n", REV );

		/* open file */
	strcpy( buf, argv[1] );		/* filename */
	if ((fd = open(buf,0)) < 0) 	{
		strcat( buf, ".st" );	/* retry filename with '.st' ext */
		if ((fd=open(buf,0)) < 0) 	{
			printf("Can't open %s\n",argv[1]);
			exit(-1);
			}
		}
	printf( "dump of %s\n", buf );

		/* get header */
	if ( read(fd, &header, sizeof(header)) != sizeof(header) )  	{
		puts("Can't read pcode histogram file");
		exit( -1 );
		}
	if ( strcmp(header.phtype,"profil")!=0
			&& strcmp(header.phtype,"pcodes")!=0 ) 	{
		puts( "Can't identify phtype value (bad header)" );
		exit( -1 );
		}

		/* read data */
	printf( "data table = %d (dec) words\n", header.phwords );
	tblptr = phtab ;		/* int (word) ptr to data */
	bsize = header.phwords << 1 ;	/* # bytes of data */
	if ( header.phwords > datasiz ) 	{
		puts( "Data table too large" );
		exit( -1 );
		}
	if ( read(fd, tblptr, bsize) != bsize ) 	{
		puts( "Data read error" );
		exit( -1 );
		}
	swab(tblptr,tblptr,sizeof(phtab));

		/** branch on type of dump **/
	if ( strcmp(header.phtype, "pcodes") == 0 )
		goto PCDUMP;
	else 
		goto PRDUMP;

/**/

	PCDUMP:		/** display p-code dump **/

#if	NOTNOW
	puts( "\n/* P-code dump */" );

	for (i=0; i<1024; ++i) 	{
		if (phtab[i] != 0L) 	{
			if (i>0 && i<4)
				cptr = "L/I";
			else 	{
				if (i>=128 && i<256)
					j = (int)(char)i;
				else
					j = i;
				cptr = dasm(j);
			}
			printf("%5d %-8s %10D\n",j,cptr,phtab[i]);
		}
	}
	exit(0);
#endif

/**/

	PRDUMP:		/** display profil() dump **/

	puts( "\n* profil() dump */" );


	/** get 'bucket' size.
		The scale factor determines the size of 'buckets' (pc addr's grouped
		into one reference cntr) used by profil() **/
	printf( "scale = %o (octal)\n", header.phscale );
	i = header.phscale ;
	i-- ;		/*  <<<*** adjust scale (?) */
	bktsize = 2 ;		/* ?? */
	while ( i > 0 ) 	{
		bktsize <<= 1;
		i <<= 1 ;
		}
	printf( "Address grouping (addr's per counter word) = %d (dec)\n",
				bktsize );


	/** open load map file **/
	if ( argc < 3 ) 	{
		printf( "\nUsage: %s <dump_file> <load_map>\n", argv[0] );
		puts( "\nDo you want an address dump? (y/n)" );
		gets( buf );
		sscanf( buf, "%c", &c );
		if ( c == 'y' )
			dmpadrs();		/* dump addresses */
		else
			exit( -1 );
		}
	else {
		if ( (fp=fopen(argv[2],"r")) == NULL ) 	{
			printf( "Can't open load map file - %s\n", argv[2] );
			exit( -1 );
			}
		else {
			strcpy( loadmap, argv[2] );		/* save load map filename */
			dmpbkts();		/* dump buckets */
			}
		}
	exit( 0 );
	}
	
/**/

dmpbkts ()	 /*  dump buckets  */
{
	unsigned	blkstart,wos;
	unsigned	blkstop;
	int		i,j;
	int		bktcnt;


	/** load symbol address table **/
	i = 0;		/* addr cntr */
	getsym2();	/* get 1st symbol */
	while ( (adrtbl[i]=curadr) != 0xffff ) {
		if ( ++i >= ATSIZE ) {
			puts( "Address Table overflow" );
			exit( -1 );
			}
		getsym2();
		}
	if (dbug>9)
		for ( i=0 ; adrtbl[i++] != 0xffff ; )
			printf( "addr table entry %d = %x\n", i,adrtbl[i] );
	
	/* reset load map file */
	fclose( fp );
	if ( (fp=fopen(loadmap,"r")) < 0 ) {
		printf( "Error reopening loadmap - %s\n", loadmap );
		exit( -1 );
		}
	curadr = nxtadr = 0;


	getsym();		/* get first symbol */
	getsym();		/* and addr of next sym */
	puts( "\n  count   bucket    addr    symbol" );

	blkstart=0;		/* start of first 'block' */
	blkstop = nxtblk( atix );	/* start of next block */

	for ( bktptr=0,wos=0 ; wos < header.phwords ; bktptr+=bktsize,wos++ ) 	{
		bktcnt = *(tblptr+wos);
		cntacc += bktcnt ;		/* add to count accumulator */
		if (dbug>9)	{
			printf( "dmpbkt: addr,bktcnt = %x %d\n", bktptr,bktcnt );
			}

		/* chk symbol range */
		if ( bktptr < blkstop )
			symcnt += bktcnt;		/* add to cntr for this symbol */
		else 	{

			/** we are through accumulating for current symbol **/
			showsym(blkstart);	/* show this symbol and others in bucket */
			lastcnt = symcnt;	/* save cnt of last symbol */
			symcnt = bktcnt;	/* begin accumulating cnt for this sym */
			getsym();			/* get next sym */

			/* get start and end addr's for next block */
			blkstart = bktptr;	/* block starts at current bucket */
			blkstop = nxtblk( atix );	/* and ends at bktstart of nxt block */
			if (dbug)
				printf( "dmpbkt: block start,end = %x %x\n",
					blkstart,blkstop );

			}
		if (dbug>9)
			printf( "dmpbkt: symcnt = %d\n", symcnt );
		}
	showsym();		/* show last symbol */

	printf( "\n%7D = counter total (dec)\n", cntacc );
	puts( "\nNote - quantization errors may be present." );
	puts( "       Symbols which do not start at even buckets may include");
	puts( "       count for previous symbol." );
	puts( "\n *   - The count shown may include the previous (displayed) symbol" );
	puts(" **  - The count shown may include this symbol (which was not previously displayed)" );

	}
/**/

dmpadrs ()			/** dump addresses **/
{
	unsigned wos;
	int		bktcnt;

	puts( "\n  bos  wos     addr count" );
	for ( bktptr=0,wos=0 ; wos < header.phwords ; bktptr+=bktsize,wos++ ) 	{
		bktcnt = *(tblptr+wos);
		if ( bktcnt != 0 )
			printf( "%5x %4x     %4x %5d\n", (wos*2),wos,bktptr,bktcnt );
		}
	}
/**/

getsym ()

/*  get next (text) symbol from load map.
	Return:	cursym,curadr = current ('next') symbol info
			nxtsym,nxtadr = next ('next'+1) symbol info
			atix = entry# of current symbol in adr table.
*/

{
	
	getsym2();

	/* set atix to current addr entry */
	if ( adrtbl[++atix] != curadr )		/* try next sequential first */
		for ( atix=0 ; adrtbl[atix] != curadr && atix < ATSIZE ; atix++ ) ;

	if (dbug>8) 	{
		printf( "getsym: cur sym = %x %s\n", curadr,cursym );
		printf( "        next sym = %x %s\n", nxtadr,nxtsym );
		printf( "        atix = %d\n", atix );
		}
	}

getsym2()

/* version of getsym() that doesn't set atix */

{
	char	type;

	/* chk for symbol list empty */
	if ( curadr == 0xffff )
		goto nsxit;

	/* set 'last' symbol to 'current' symbol */
	strcpy( lastsym, cursym );
	lastadr = curadr;

	/* set 'current' symbol to 'next' symbol */
	strcpy( cursym, nxtsym );
	curadr = nxtadr ;

	/* chk for end of symbol list */
	if ( curadr == 0xffff )
		goto nsxit;

	/* get next symbol */
	while ( (fscanf(fp, "%x %c %s", &nxtadr, &type, nxtsym)) != -1 ) 	{
		if ( type == 'T' ) {
			/* found it */
			goto nsxit;
			}
		}

	/* no more symbols */
	strcpy( nxtsym, "$" );
	nxtadr = 0xffff;

	nsxit:
	return;
	}


unsigned	convbkt ( addr )

/* convert the given addr to the addr of the bucket it is in */

unsigned addr;
{
	unsigned rv;
	
	rv = addr - (addr % bktsize);	
	if (dbug > 4 )
		printf( "convbkt: in,out = %x %x\n", addr,rv );
	return( rv );
	}


unsigned	nxtblk( ix )

/* return addr of next 'block' after addr in adrtbl[ix].
	The address returned will be the beginning address of the bucket
	which contains the next symbol.
	Symbols which are in the starting bucket (adrtbl[ix]) must be skipped. */

int	ix;
{
	unsigned start,rv;
	int	i;

	start = convbkt( adrtbl[ix] );		/* starting bucket */
	
	/* skip all symbols in the starting bucket */
	i = ix ;
	while ( (rv=convbkt(adrtbl[++i])) == start ) ;

	if (dbug>4)
		printf( "nxtblk: ix, adr, start, next block = %d %x %x %x\n",
			ix,adrtbl[ix],start,rv );
	
	return( rv );
	}

/**/

showsym ( blkstart )

/*  Show current symbol and it's cntr  */
/*  Also show any other symbols in the addr bucket  */

unsigned blkstart;		/* start of last bucket with non-zero count */
{
	unsigned	nxtbkt,strt;
	int	n;

	if (dbug>5)
		printf( "showsym: symcnt,sym = %d %s\n", symcnt,cursym );

	/* show current symbol & (conditionally) last symbol */
	strt = convbkt(curadr);		/* bucket start addr */
	if ( symcnt != 0 ) {
		if ( curadr == strt )	/* cursym starts at bkt */
			printf( "  %5u     %4x    %4x    %-8s\n",
					symcnt,strt,curadr,cursym );
		else if ( lastcnt != 0 )	/* last symbol was shown */
			printf( "  %5u     %4x    %4x *  %-8s\n",
					symcnt,strt,curadr,cursym );
		else {		/* last symbol was not shown */
			printf( "  %5u     %4x    %4x ** %-8s\n",
					symcnt,strt,lastadr,lastsym );
			printf( "  %5s     %4s    %4x    %-8s\n",
					"","",curadr,cursym );
			}
		}

	/** show other symbols in this bucket **/
	nxtbkt = blkstart + bktsize ;		/* start of nxt bucket */
	while ( nxtadr < nxtbkt && nxtadr != 0xffff ) 	{
		if (dbug>7)
			printf("showsym: blkstart,nxtbkt,bktsize = %x %x %x\n",
				blkstart,nxtbkt,bktsize);
		getsym();		/* get next symbol */
		if ( symcnt != 0 )
			printf( "  %5s     %4s    %4x    %-8s\n","","",curadr,cursym );
		}

	}
