/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */


#include <stdio.h>
#include <sgtty.h>
#include <signal.h>
#include "comm.h"


static	struct	sgttyb	oldmode;       /* terminal characteristics */
static	struct	sgttyb	newmode;       /*          buffers         */
static	struct	tchars	oldchar;
static	struct	tchars	newchar;


main()
{
   int escape();

#ifdef DEBUG  			             /* conditional debug code */
   printf("\nrunning in DEBUG mode\n\n");
#endif                                       /* end-condition */

   setup();
   initcomm();
   comm();
   logstats();
   waitbye();
   resetcomm();
   display("Communications complete - system restored");
} /* end-main */

setup()
{
   char ans[6], filname[14];
   printf("(M)aster or (S)lave: ");
   getline(stdin, ans, 6);
   if (ans[0] == 'S' || ans[0] == 's') {
      master = 0; seq = -1;
   } else {
      master = 1; seq = 0; nrtys = 100;
      printf("MASTER mode not implemented, using SLAVE mode\n");
      master = 0; seq = -1; nrtys = 3;
   }
   printf("Log file name: ");
   getline(stdin, filname, 14);
   if (length(filname))
      if ((lp = fopen(filname, "w")) != NULL)
	 lc = 0;
      else
	 printf("***   Can't open log file   ***\n");
   printf("Command file name: ");
   getline(stdin, filname, 14);
   if (length(filname))
      if ((cp = fopen(filname, "r")) != NULL)
	cc = 1; 
      else
	 printf("***   Can't open command file   ***\n");

   /* set interrupt trap(s) */
   signal(SIGINT, escape);
   signal(SIGQUIT, escape);
   signal(SIGTERM, escape);
} /* end-setup */

logstats()
{
   char stats[133];
   sprintf(stats,"timeouts = %d, cksums = %d, ", tos, cksums);
   sprintf(&stats[length(stats)], "seqs = %d, naks = %d, ", seqs, naks);
   sprintf(&stats[length(stats)], "bads = %d", bads);
   if (lc >= 0)
      log(stats);
   else
      display(stats);
} /* end-logstats */

waitbye()
{
   char ans[4];
   do {
      display("transfer complete, enter BYE to terminate");
      getline(stdin, ans, 4);
   } while (strcmp(ans, "BYE") != 0 && strcmp(ans, "bye") != 0);
} /* end-waitbye */

initcomm()
{
   commin = fileno(stdin);
   commout = fileno(stdout);
   ioctl(commin, TIOCGETP, &oldmode);
   ioctl(commin, TIOCGETP, &newmode);
   ioctl(commin, TIOCGETC, &oldchar);
   ioctl(commin, TIOCGETC, &newchar);

#ifndef DEBUG     		/* change terminal characteristics */
   newmode.sg_flags &= CRMOD;
   newmode.sg_flags &= ~ECHO;
   newchar.t_brkc = RET;
#endif                          /* end-condition */

   ioctl(commin, TIOCSETP, &newmode);
   ioctl(commin, TIOCSETC, &newchar);

} /* end-initcomm */

resetcomm()
{
   ioctl(commin, TIOCSETP, &oldmode);
   ioctl(commin, TIOCSETC, &oldchar);
} /* end-resetcomm */

display(txt)
char *txt;
{

#ifdef DEBUG  			             /* conditional debug code */
   putchar('\034');
#endif                                       /* end-condition */

   while (*txt != NUL)
      putchar(*txt++);
   putchar(EOL);

#ifdef DEBUG  			             /* conditional debug code */
   putchar('\035');
#endif                                       /* end-condition */

} /* end-display */

log(msg)
char *msg;
{
   char c;
   if (lc != -1) {
      while (c = *msg++)
	 putc(c, lp);
      putc(EOL, lp);
   }

#ifdef DEBUG  			             /* conditional debug code */
   if (lc == -1)
      display(msg);
#endif                                       /* end-condition */

} /* end-log */

getline(fp, line, lim)
FILE *fp;
char *line;
int lim;
{
   int c, i;
   i = 0;
   while (--lim > 0 && (c = getc(fp)) != EOF && c != EOL)
      line[i++] = c;
   line[i] = NUL;
   while (c != EOF && c != EOL)
      c = getc(fp);
   return(c);
} /* end-getline */

pos(str, c)
char str[], c;
{
   int i;
   char t;
   i = 0;
   while ((t = str[i++]))
      if (t == c)
	 return(i-1);
   return(-1);
} /* end-pos */

copy(dest, src)
char *dest, *src;
{
   while (*dest++ = *src++)
      ;
} /* end-copy */

concat(dest, src)
char dest[], src[];
{
   int p1, p2;
   p1 = p2 = 0;
   while (dest[p1] != NUL)
      p1++;
   while (dest[p1++] = src[p2++])
      ;
} /* end-concat */

append(str, c)
char str[], c;
{
   int slen;
   slen = length(str);
   str[slen] = c;
   str[slen + 1] = NUL;
} /* end-append */

length(str)
char *str;
{
   char *tmp = str;
   while (*tmp)
      tmp++;
   return(tmp - str);
} /* end-length */

hex(x)
int x;
{
   return( ((x&15) <= 9) ? ((x & 15) + '0') : (((x & 15) - 10) + 'A') );
} /* end-hex */

itohex(outstr, inpval, prec)
char outstr[];
int inpval, prec;
{
   int i;
   outstr[prec] = NUL;
   for (i = prec - 1; i >= 0; inpval >>= 4, i--)
      outstr[i] = hex(inpval);
} /* end-itohex */

hextoi(inpstr)
char *inpstr;
{
   int outval;
   for (outval = 0; *inpstr != '\0'; inpstr++)
      outval = outval * 16 + (*inpstr - (*inpstr <= '9' ? '0' : 'A' - 10));
   return(outval);
} /* end-hextoi */

abend(exitcode)
int exitcode;
{
   resetcomm();
   printf("\n\nAbnormal termination: %d\n\n", exitcode);
   exit(exitcode);
   return;
} /* end-abend */

escape()
{
   resetcomm();
   printf("\n\nProcess interrupted\n\n");
   exit(0);
   return;
} /* end-escape */

#ifdef DEBUG  			             /* conditional debug code */
linedisp(x)
char x[];
{
int i;
for (i = 0; i < length(x); i++)
   if ((x[i] >= 32) && (x[i] <= 127))
      printf("%c", x[i]);
   else
      printf("<%o>", x[i]);
} /* end-linedisp */
#endif                                       /* end-condition */
