
#include "irma.h"

int slverr, i, j, k, l, cursor, memloc, memadr;
int errno;

union {
   char *name;
   int count;
   } *dptr, dlist[] = {

      3,"ERSC","EAOC","EMBC",
      3,"EESC","ETCC","EPTC",
      1,"EOVC",
      2,"KEY.DATA","AUX.STATUS",
      2,"TERMINAL.ID","TERMINAL.STATUS",
      1,"EAB.STATUS",
      3,"SELECTOR.ROW","SELECTOR.FIELD","SELECTOR.PENDING",
      2,"LOW.LED.TIM","HIGH.LED.TIM",
      2,"STATUS.LSB","STATUS.MSB",
      3,"LAST.TRIGGER.DATA","LAST.MAIN.STATUS","LAST.DEVICE.CONTROL",
      2,"TRIGGER.LSA","TRIGGER.MSA",
      2,"TRIGGER.MASK","TRIGGER.DATA",
      1,"INT.CONDITIONS",
      2,"REVLOW","REVHIGH",
      0 };

main()
{
   slverr = 0;

   putst("\nIRMA Register and Status Dump - Rev 1.10\n\n");

   gstat(&i); gcpos(&j);

   if (slverr) { putst("IRMA failed to respond. DEAD.\n"); return; };

   pname("IRMA status",i,4);
   pname("Cursor position",j,4);
   putst("\n\n");

   dptr = &dlist; 
   memadr = 6144-1;

   while((j = dptr++ -> count) != 0) {
      for(i = 1; i <= j; i++, --memadr) {
	 rdabs(&memadr,&memloc);
	 pname(dptr++ -> name,memloc,2);
      }
   putch('\n');
   }
}

putst(string)
char *string;
{
   while(*string != '\0') putch(*string++);
}

pname(string,number,len)
char *string;
int number, len;
{
   int c;
   c = 0;
   while(*string != '\0') { putch(*string++); c++; };
   while(c++ <= 22-len) putch('.');
   puthex(number,len);
   putst("  ");
}

puthex(word,lth)
int word, lth;
{
   int i, c;
   for(i = lth - 1; i >= 0; i--) {
      c = (word>>(i<<2)) & 0xf;
      if (c >= 10) c += 7;
      putch(c+'0');
   };
}

putch(ch)
char ch;
{
   struct { int ax, bx, cx, dx } regs;
   if (ch == '\n') putch('\r');
   regs.ax = 0x0200;
   regs.dx = ch;
   bios(0x21,&regs);
}

_msdcl() {}

open() {}
