; ****************************************************************************
;
; init386.s (INIT0.ASM)
; ----------------------------------------------------------------------------
;
; Retro UNIX 386 v1 Kernel - /etc/init file executing test (30/06/2015)
;
; [ Last Modification: 13/08/2015 ]
;
; ****************************************************************************

; 07/08/2015
; 30/06/2015
; 14/07/2013
; UNIX v1 system calls
_rele 	equ 0
_exit 	equ 1
_fork 	equ 2
_read 	equ 3
_write	equ 4
_open	equ 5
_close 	equ 6
_wait 	equ 7
_creat 	equ 8
_link 	equ 9
_unlink	equ 10
_exec	equ 11
_chdir	equ 12
_time 	equ 13
_mkdir 	equ 14
_chmod	equ 15
_chown	equ 16
_break	equ 17
_stat	equ 18
_seek	equ 19
_tell 	equ 20
_mount	equ 21
_umount	equ 22
_setuid	equ 23
_getuid	equ 24
_stime	equ 25
_quit	equ 26	
_intr	equ 27
_fstat	equ 28
_emt 	equ 29
_mdate 	equ 30
_stty 	equ 31
_gtty	equ 32
_ilgins	equ 33
_sleep	equ 34 ; Retro UNIX 8086 v1 feature only !
_msg    equ 35 ; Retro UNIX 386 v1 feature only !

%macro sys 1-4
    ; 13/04/2015
    ; Retro UNIX 386 v1 system call.		
    mov eax, %1
    %if %0 >= 2   
        mov ebx, %2
        %if %0 >= 3    
            mov ecx, %3
            %if %0 = 4
               mov edx, %4   
            %endif
        %endif
    %endif
    int 30h	   
%endmacro

[BITS 32] ; We need 32-bit intructions for protected mode

[ORG 0] 

START_CODE:
	sys _intr, 0  ; disable time-out function 
	sys _quit, 0  ; disable quit (ctrl+brk) signal
	;
        sys _open, ctty, 0 ; open tty0
	jc short error
	;
	inc byte [error_stage]
	;
        sys _open, ctty, 1 ; for read and write
	jc short error
	;
	inc byte [error_stage]
	;
	sys _write, 1, running_msg, sizeof_msg
        jc short error
        ;
	inc byte [error_stage]
	;
	sys _read, 0, tchar, 1
	jnc short c_msg
	;
	inc byte [error_stage]
	;
error:
	sys _msg, error_msg, 255, 0Ch ; error message with red color (max. 255 chars)
exit:
	sys _exit

haltsys:
	hlt
	jmp short haltsys

c_msg:
	sys _msg, copy_right_msg, 255, 0Fh ; copy right message with white color
	jmp short exit

align 2
tchar:  db 0

align 2
ctty:   db "/dev/tty", 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

running_msg:
    		db 0Dh, 0Ah, 07h
                db 'Retro UNIX 386 v1 Kernel Function Test : <sysexec> Function is OK!'
                db 0Dh, 0Ah
                db 0Dh, 0Ah
                db 'Retro UNIX 386 v1 </etc/init> loading and running test is OK!'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
sizeof_msg equ $ - running_msg 
        	db 0

copy_right_msg:
                db  '(c) Erdogan TAN - 13/08/2015'
		db  0Dh, 0Ah, 0

error_msg:
		db 0Dh, 0Ah, 07h
		db '/etc/init386 stage '
error_stage:	db '0 error ! '
		db 0
