; ****************************************************************************
;
; INIT01.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 28/10/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	; from 'sysexec' system calls
	; cs=ds=es=ss
	; ax=bx=cx=dx=si=di=bp=0
	;  (stack pointer -sp- points to 
	; to the head of arguments list which is 
	; on top the stack, backward from 'ecore'.) 
	; sp = offset argc (argument count)

	mov si, offset copyright
	call print_msg
	;
	mov bp, sp
	mov ax, word ptr [bp]
	call hex_double
	mov word ptr [argc], ax
	mov word ptr [argc]+2, dx
	mov ax, word ptr [bp]+2
	call hex_double
	mov word ptr [argv], ax
	mov word ptr [argv]+2, dx
	mov si, offset msg_args
	call print_msg
	mov si, offset msg_fn
	call print_msg
	mov si, word ptr [bp]+2
	call print_msg

	;xor ah, ah
	;int 16h

	call getc

	mov ax, cs
	call hex_double
	mov word ptr [csv], ax
	mov word ptr [csv]+2, dx
	mov ax, ds
	call hex_double
	mov word ptr [dsv], ax
	mov word ptr [dsv]+2, dx
	mov ax, es
	call hex_double
	mov word ptr [esv], ax
	mov word ptr [esv]+2, dx
	mov ax, ss
	call hex_double
	mov word ptr [ssv], ax
	mov word ptr [ssv]+2, dx
	mov ax, sp
	call hex_double
	mov word ptr [spv], ax
	mov word ptr [spv]+2, dx
	;
	mov si, offset msg_regs
	call print_msg
	
	;xor ah, ah
	;int 16h

	call getc

	mov si, offset msg_OK
	call print_msg

	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
	          ; (Terminate process for DOS!)
here:
	hlt
	jmp short here


print_msg:
	mov ah, 0Eh               
        mov bx, 07h
@@:
        lodsb         ; Load byte at DS:SI to AL
        and al, al            
        jz short @f      
            
        int 10h       ; BIOS Service func ( ah ) = 0Eh
                      ; Write char as TTY
                      ;AL-char BH-page BL-color
	jmp short @b         
@@:
        retn


hex_double:
	;push cx
        xor dx, dx
        mov cx, 10h
        div cx      ; Q in AX, R in DX (DL)
        push dx     ; DH= 0, R in DL <- CX= 10h 
        xor dl, dl  ;
        div cx	    ; DH= 0, R in DL, AX <= FFh
        div cl      ; AL <= 0Fh
       	            ; R in AH, Q in AL
        pop cx      ; R in CL
	mov dh, cl
	
        or dx,'00'

        cmp dl,'9'
        jna short @f
        add dl,7
@@:
        cmp dh,'9'
        jna short @f
        add dh,7
@@:
        or ax, '00'

        cmp al,'9'
        jna short @f
        add al,7
@@:
        cmp ah,'9'
        jna short @f
        add ah,7
@@:
        ;pop cx

        retn

getc:
	mov ax, 5 ; sysopen
	mov bx, offset ctty
	mov cx, 0 ; open for read
	int 20h   ; sys _open, ctty, 0

	mov ax, 3 ; sysread
	mov bx, 0 ; file descriptor
	mov cx, offset tchr
	mov dx, 1 ; count
	int 20h   ; sys _read, 0, tchr, 1
	
	mov ax, 6 ; sysclose
	mov bx, 0 ; file descriptor
	int 20h	  ; sys _close, 0

	xor al, al
	xchg al, byte ptr [tchr]
	cmp al, 0Dh ; ENTER key
	jne short getc
	
	retn

tchr:	db 0
ctty:	db '/dev/tty', 0

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

msg_args:
		db 0Dh, 0Ah 
                db 'Argument Count    : '
argc:           dd 30303030h
		db 'h', 0Dh, 0Ah
		db 'Argument 0 Offset : '
argv: 		dd 30303030h
		db 'h', 0Dh, 0Ah, 0
msg_fn:
		db 'Argument 0 - Name : '
		db 0
copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 25/07/2013'
		db  0Dh, 0Ah, 0	
msg_regs:
		db 0Dh, 0Ah
		db 0Dh, 0Ah
		db 'CS: '
csv: 		dd 30303030h
		db 'h', 0Dh, 0Ah
		db 'DS: '
dsv: 		dd 30303030h
		db 'h', 0Dh, 0Ah
		db 'ES: '
esv: 		dd 30303030h
		db 'h', 0Dh, 0Ah
		db 'SS: '
ssv: 		dd 30303030h
		db 'h', 0Dh, 0Ah
		db 'SP: '
spv: 		dd 30303030h
		db 'h', 0dh, 0ah, 0

msg_OK:		db 0Dh, 0Ah
		db 'OK.'
		db 0Dh, 0Ah, 0

UNIX     	ends

                end     START_CODE