; ****************************************************************************
;
; INIT02.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 25/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset copyright
	call print_msg
	;
	mov ax, 13   ; systime
	int 20h
	jc short error

	; DX:AX = unix time (epoch)

	push dx
	push ax
	push dx
	call hex_double
	mov word ptr [txt_dtime_h]+4, ax	
	mov word ptr [txt_dtime_h]+6, dx
	pop ax
	call hex_double
	mov word ptr [txt_dtime_h], ax	
	mov word ptr [txt_dtime_h]+2, dx
	pop ax
	pop dx
	call convert_from_epoch
	mov ax, word ptr [year]
	mov si, offset txt_dtime_year
	;mov cx, 4
	mov cl, 4
	call bin_to_decimal
	mov ax, word ptr [month]
	mov si, offset txt_dtime_month
	mov cl, 2
	call bin_to_decimal
	mov ax, word ptr [day]
	mov si, offset txt_dtime_day
	mov cl, 2
	call bin_to_decimal
	mov ax, word ptr [hour]
	mov si, offset txt_dtime_hour
	mov cl, 2
	call bin_to_decimal
	mov ax, word ptr [minute]
	mov si, offset txt_dtime_minute
	mov cl, 2
	call bin_to_decimal
	mov ax, word ptr [second]
	mov si, offset txt_dtime_second
	mov cl, 2
	call bin_to_decimal

	mov si, offset msg_date_time	
	call print_msg
@@:	
	xor ah, ah
	int 16h

	iret

	;mov 	ax, 1 ; 'sysexit'
	;int 	20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	mov     AH,0Eh                  
        mov     BX,07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn


hex_double:
	;push cx
        xor dx, dx
        mov cx, 10h
        div cx      ; Q in AX, R in DX (DL)
        push dx     ; DH= 0, R in DL <- CX= 10h 
        xor dl, dl  ;
        div cx	    ; DH= 0, R in DL, AX <= FFh
        div cl      ; AL <= 0Fh
       	            ; R in AH, Q in AL
        pop cx      ; R in CL
	mov dh, cl
	
        or dx,'00'

        cmp dl,'9'
        jna short @f
        add dl,7
@@:
        cmp dh,'9'
        jna short @f
        add dh,7
@@:
        or ax, '00'

        cmp al,'9'
        jna short @f
        add al,7
@@:
        cmp ah,'9'
        jna short @f
        add ah,7
@@:
        ;pop cx

        retn

convert_from_epoch:
	mov cx, 60
	call div32
	;mov word ptr [imin], ax   ; whole minutes
	;mov word ptr [imin]+2, dx ; since 1/1/1970
	mov word ptr [second], bx  ; leftover seconds
	; mov cx, 60
	call div32
	;mov word ptr [ihrs], ax   ; whole hours
	;mov word ptr [ihrs]+2, dx ; since 1/1/1970
	mov word ptr [minute], bx  ; leftover minutes
	; mov cx, 24
	mov cl, 24
	call div32
	;mov word ptr [iday], ax  ; whole hours
				  ; since 1/1/1970
	; mov word ptr [iday]+2, dx ; DX = 0
	mov word ptr [hour], bx   ; leftover hours
	add ax, 365+366		  ; whole day since
				  ; 1/1/1968 	
	; adc dx, 0	          ;  DX = 0
	; mov word ptr [iday], ax
	push ax
	mov cx, (4*365)+1	  ; 4 years = 1461 days
	call div32
	pop cx
	;mov word ptr [lday], ax  ; count of quadyrs (4 years)
	push bx
	;mov word ptr [qday], bx  ;  days since quadyr began
	cmp bx, 31 + 29           ; if past feb 29 then
	cmc			  ; add this quadyr's leap day
	adc ax, 0		  ; to # of qadyrs (leap days)
	;mov word ptr [lday], ax  ; since 1968			  
	;mov cx, word ptr [iday]
	xchg cx, ax		  ; CX = lday, AX = iday		  
	sub ax, cx		  ; iday - lday
	mov cx, 365
	;xor dx, dx		  ; DX  = 0
	; AX = iday-lday, DX = 0
	call div32
	;mov word ptr [iyrs], ax   ; whole years since 1968
	; jday = iday - (iyrs*365) - lday
	;mov word ptr [jday], bx  ; days since 1/1 of current year
	add ax, 1968		  ; compute year
	mov word ptr [year], ax
	mov dx, ax		
	;mov ax, word ptr [qday]
	pop ax
	cmp ax, 365		  ; if qday <= 365 and qday >= 60	
	ja short @f		  ; jday = jday +1
	cmp ax, 60	          ; if past 2/29 and leap year then
        cmc			  ; add a leap day to the # of whole
	adc bx, 0		  ; days since 1/1 of current year
@@:			
	;mov word ptr [jday], bx
	mov cx, 12		  ; estimate month
	xchg cx, bx		  ; CX = jday, BX = month 	
	mov ax, 366		  ; mday, max. days since 1/1 is 365
	and dx, 11b		  ; year mod 4	(and dx, 3) 
@@:	; Month calculation	  ; 0 to 11  (11 to 0)	
	cmp cx, ax		  ; mday = # of days passed from 1/1
	jnb short @f
	dec bx			  ; month = month - 1
	shl bx, 1 
	mov ax, word ptr DMonth[BX] ; # elapsed days at 1st of month
	shr bx, 1		  ; bx = month - 1 (0 to 11)
	cmp bx, 1		  ; if month > 2 and year mod 4  = 0	
	jna short @b		  ; then mday = mday + 1
	or dl, dl		  ; if past 2/29 and leap year then
	jnz short @b		  ; add leap day (to mday)
	inc ax			  ; mday = mday + 1
	jmp short @b
@@:
	inc bx 			  ; -> bx = month, 1 to 12
	mov word ptr [month], bx
	sub cx, ax		  ; day = jday - mday + 1	
	inc cx 			  
	mov word ptr [day], cx
	
	; ax, bx, cx, dx is changed at return
	; output ->
	; [year], [month], [day], [hour], [minute], [second]

	retn

div32:
	mov  bx, dx
	xchg ax, bx
	xor  dx, dx
	div  cx         ; at first, divide DX
	xchg ax, bx     ; remainder is in DX
			; now, BX has quotient
			; save remainder
	div  cx         ; so, DX_AX divided and
			; AX has quotient
			; DX has remainder
	xchg dx, bx     ; finally, BX has remainder

	retn


bin_to_decimal:
	;push bp
	;push si
@@:
        mov byte ptr [SI], "0"
        inc si
        loop @b
        mov bp, sp
        xor dx, dx
	mov cx, 10
@@:
        div cx
	add dl,'0'
        push dx
        xor dx, dx
	dec si
	or ax, ax
	jnz short @b
@@: 
        pop dx
        mov byte ptr [SI], dl
        inc si
        cmp bp, sp
        jne short @b
        ;pop si
        ;pop bp  
 
        retn


;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 25/07/2013'
		db  0Dh, 0Ah, 0	
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
                db 0Dh, 0Ah, 0

year: 		dw 1970
month: 		dw 1
day: 		dw 1
hour: 		dw 0
minute: 	dw 0
second: 	dw 0

DMonth:
		dw 0
		dw 31
		dw 59
		dw 90
		dw 120
		dw 151
		dw 181
		dw 212
		dw 243
		dw 273
		dw 304
		dw 334

msg_date_time:
		db 0Dh, 0Ah
		db "Current Date & Time : "
txt_dtime_h:
		db "00000000h"
		db 20h, 20h
		db "["
txt_dtime_day:
		db "00"
		db "/"
txt_dtime_month:
		db "00"
		db "/"
txt_dtime_year:
		db "0000"
		db ","
txt_dtime_hour:
		db "00"
		db ":"
txt_dtime_minute:
		db "00"
		db ":"
txt_dtime_second:		
		db "00"
		db "]"
		db 0Dh, 0Ah
		db 0

UNIX     	ends

                end     START_CODE
