; ****************************************************************************
;
; INIT03B.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 26/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset copyright
	call print_msg
	;

	mov bx, offset dirname
	mov ax, 12   ; syschdir
	int 20h
        jc error

	mov si, offset msg_cdir
	call print_msg

	mov si, offset dirname
	call print_msg
	
	mov si, offset nextline
	call print_msg

openfile:
	mov bx, offset drvname
	mov cx, 0 	; open for read
	mov ax, 5   	; sysopen
	int 20h
        jc error
        mov word ptr [fnumber], ax

	mov si, offset drvname
	call print_msg

        mov ax, word ptr [fnumber]
	call hex_double
        mov word ptr [fnumber_str], ax 
        mov word ptr [fnumber_str]+2, dx

	mov si, offset msg_fnumber
	call print_msg

	;mov word ptr [snumber], 0	
readfile_s:
	mov ax, word ptr [snumber]
	call hex_double
	mov word ptr [snumber_str], ax
	mov word ptr [snumber_str]+2, dx

	mov si, offset msg_snumber
 	call print_msg

	mov si, offset nextline
 	call print_msg

	mov cx, 256
	mov di, offset buffer
	xor ax, ax
	rep stosw ; clear buffer
	;
        mov bx, word ptr [fnumber]  ; file descriptor/number
	mov cx, offset buffer 	    ; buffer (512 bytes)
	mov dx, 512		    ; byte count (512)
	mov ax, 3		    ; sysread
	int 20h	
	jc short error				

	and ax, ax
	jz short closefile

	mov si, offset buffer
	mov cx, 32
readfile_r:
	push cx
	mov cx, 8
	mov di, offset row	
@@:
	lodsw
	xchg ah, al 
	call hex_double
	stosw
	mov al, 20h
	stosb
	mov ax, dx
	stosw	
	mov al, 20h
	stosb
	loop @b
	mov al, 0
	stosb
	
	push si
	mov si, offset row
	call print_msg

	xor ah, ah
	int 16h

	push ax
	mov si, offset nextline
	call print_msg
	pop ax

	pop si

	pop cx

	cmp al, 1Bh  ; ESC key
	je short closefile

	loop readfile_r
	inc word ptr [snumber]
	jmp short readfile_s	
	
closefile:
        mov bx, word ptr [fnumber]
	mov ax, 6 ; sysclose
	int 20h

	mov si, offset msg_ok
	call print_msg

	xor ah, ah
	int 16h

	iret
@@:
	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	mov     AH,0Eh                  
        mov     BX,07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn


hex_double:
	push cx
        xor dx, dx
        mov cx, 10h
        div cx      ; Q in AX, R in DX (DL)
        push dx     ; DH= 0, R in DL <- CX= 10h 
        xor dl, dl  ;
        div cx	    ; DH= 0, R in DL, AX <= FFh
        div cl      ; AL <= 0Fh
       	            ; R in AH, Q in AL
        pop cx      ; R in CL
	mov dh, cl
	
        or dx,'00'

        cmp dl,'9'
        jna short @f
        add dl,7
@@:
        cmp dh,'9'
        jna short @f
        add dh,7
@@:
        or ax, '00'

        cmp al,'9'
        jna short @f
        add al,7
@@:
        cmp ah,'9'
        jna short @f
        add ah,7
@@:
        pop cx

        retn

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 26/07/2013'
		db  0Dh, 0Ah, 0	
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
nextline:
		db 0Dh, 0Ah, 0

msg_cdir:
		db 0Dh, 0Ah
		db 'Current directory : '
		db 0
dirname:	db '/dev'
		db 0
drvname:
		db 'hd0'
		db 0

fnumber:       dw 0 

buffer:
		db 512 dup(0)

msg_fnumber:
		db ' file number : '
fnumber_str:
		dd 30303030h
		db 'h', 0Dh, 0Ah, 0
msg_snumber:
		db 0Dh, 0Ah
		db 'Sector number : '
snumber_str:
		dd 30303030h
		db 'h', 0Dh, 0Ah, 0
snumber:	
		dw 0
msg_ok:	
		db 0Dh, 0Ah
		db 'OK. '
		db 0Dh, 0Ah, 0
row:
		db 50 dup(0) 

UNIX     	ends

                end     START_CODE
