; ****************************************************************************
;
; INIT04.ASM
; ----------------------------------------------------------------------------
;
; RETRO UNIX 8086 (Retro Unix == Turkish Rational Unix)
; Operating System Project (v0.1) by ERDOGAN TAN (Beginning: 11/07/2012) 
; Retro UNIX 8086 v1 Kernel - /etc/init file executing test
;
; [ Last Modification: 26/07/2013 ]
;
; ****************************************************************************

.8086

UNIX   	SEGMENT PUBLIC 'CODE'
        assume cs:UNIX,ds:UNIX,es:UNIX,ss:UNIX

START_CODE:
	mov si, offset copyright
	call print_msg

	xor ah, ah
	int 16h

openfile:
	mov bx, offset filename
	mov cx, 0 	; open for read
	mov ax, 5   	; sysopen
	int 20h
        jc error
        mov word ptr [fnumber], ax

      	mov si, offset msg_fname
	call print_msg

	mov si, offset filename
	call print_msg

	call show_file
	jc short error				

closefile:
        mov bx, word ptr [fnumber]
	mov ax, 6 ; sysclose
	int 20h

	xor ah, ah
	int 16h

	iret
@@:
	mov ax, 1 ; 'sysexit'
	int 20h   ; UNIX system call 
		      ;	(Terminate process for DOS!)
here:	
	hlt
	jmp short here

error:
	mov si, offset msg_err
	call print_msg
        jmp short @b
 
print_msg:
	mov     AH,0Eh                  
        mov     BX,07h  
@@:
        lodsb                           ; Load byte at DS:SI to AL
        and     AL,AL            
        jz      short @f      
            
        int     10h                     ; BIOS Service func ( ah ) = 0Eh
                                        ; Write char as TTY
                                        ;AL-char BH-page BL-color
	jmp     short @b         
@@:
        retn


show_file:
	; 26/07/2013 Modified for 'sys read'
	; 07/01/2013 UNIXCOPY.ASM
	; 06/01/2013
	; derived from TRDOS command interpreter file (CMDINTR.ASM)
	; 'show' procedure (13/09/2011)

        mov si, offset nextline
        call print_msg
suf_0:
	mov dx, 512		    ; byte count (512)
	mov cx, 22
suf_1:
	push cx
        mov bx, word ptr [fnumber]  ; file descriptor/number
	mov cx, offset buffer 	    ; buffer (512 bytes)
	mov ax, 3		    ; sysread
	int 20h	
	pop cx
	jc short suf_4		

	or ax, ax
	jz short suf_3		

	mov word ptr [nread], ax
	mov di, ax
                
	mov si, offset buffer
        jmp short suf_6
suf_2:
        and cx, cx
        jnz short suf_6
	xor ah, ah
	int 16h
	cmp al, 1Bh ; ESCAPE Key
	jne short suf_5
suf_3:
	mov si, offset nextline
        call print_msg
suf_4:
	retn
suf_5:
	mov cx, 20
suf_6:
        xor bh, bh ; mov bh, 0
        mov bl, 7

	lodsb
	cmp al, 0Dh ; ENTER/RETURN Char
	jne short suf_7
	dec cx
	jmp short suf_8	
suf_7:
	cmp al, 09h ; TAB Space Char
        je short suf_10
suf_8:
        mov ah, 0Eh
        ;xor bh, bh ; mov bh, 0
        ;mov bl, 7
	int 10h
suf_9:
	dec di
	jnz short suf_2
	mov dx, word ptr [nread]
	jmp short suf_1
suf_10:
        push cx
        ;xor bh, bh ; mov bh, 0
        mov ah, 03h ; get cursor position and size.
        int 10h
	mov al, dl
	mov cx, 8
;suf_11a:
;	cmp al, cl
;	jb short suf_11b
;	sub al, cl
;	jmp short suf_11a
;suf_11b:
;	 sub cl, al
suf_11:
	; 07/01/2013
	xor ah, ah
	div cl
	sub cl, ah	
	;
        mov al, 20h
        mov ah, 0Eh 
        ;mov bl, 7 ; char color attribute	
suf_12:
	int 10h
        loop suf_12
        pop cx
	jmp short suf_9 


;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;  messages
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

copyRight:
		db 0Dh, 0Ah
		db 'Retro UNIX 8086 v1 <sysexec> test (for /etc/init) !'
		db  0Dh, 0Ah
		db  0Dh, 0Ah	
                db  '(c) Erdogan TAN - 26/07/2013'
		db  0Dh, 0Ah, 0	
msg_err:
		db 0Dh, 0Ah 
                db 'Error ! '
nextline:
		db 0Dh, 0Ah, 0
msg_fname:
		db 0Dh, 0Ah
		db 'File Name : '
		db 0
filename:	db '/tmp/unix.asm'
		db 0
fnumber:      
		dw 0 
buffer:
		db 512 dup(0)
nread:	
		dw 0

UNIX     	ends

                end     START_CODE
